/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.gui.model.MonitorModel;
import eu.europa.ec.jrc.qcs.gui.view.GenericPanel;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorView
extends GenericPanel {
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private MouseListener mouseListener = new TextAreaMouseListener();
    protected static Logger logger = LoggerFactory.getLogger(MonitorView.class);

    public MonitorView(MonitorModel model) {
        Document document = model.getDocument();
        this.textArea = new JTextArea(document);
        this.textArea.setColumns(20);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setViewportView(this.textArea);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.scrollPane);
        this.textArea.addMouseListener(this.mouseListener);
        model.setView(this);
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
    }

    class TextAreaMouseListener
    implements MouseListener {
        TextAreaMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                // empty if block
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

