/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.gui.controller.SelectInputAction;
import eu.europa.ec.jrc.qcs.gui.view.GenericView;
import eu.europa.ec.jrc.qcs.gui.view.action.GeneralActions;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuBar
extends GenericView
implements GeneralActions {
    private JMenuBar menuBar = new JMenuBar();
    private JMenuItem selectInputItem = new JMenuItem();
    private JMenuItem saveOptionsMenuItem = new JMenuItem();
    private JMenuItem exitMenuItem = new JMenuItem();
    private JMenuItem optionsMenuItem = new JMenuItem();
    private JMenuItem checkSchemaMenuItem = new JMenuItem();
    private JMenuItem checkAllSchemasMenuItem = new JMenuItem();
    private JMenuItem loadProtocolMenuItem = new JMenuItem();
    private JMenuItem browseProtocolMenuItem = new JMenuItem();
    private JMenuItem helpMenuItem = new JMenuItem();
    private JMenuItem aboutMenuItem = new JMenuItem();
    private JMenuItem clearMenuItem = new JMenuItem();
    protected static Logger logger = LoggerFactory.getLogger(MenuBar.class);

    public MenuBar() {
        JMenu fileMenu = this.initFileMenu();
        JMenu optionMenu = this.initOptionMenu();
        JMenu helpMenu = this.initHelpMenu();
        this.menuBar.add(fileMenu);
        this.menuBar.add(optionMenu);
        this.menuBar.add(helpMenu);
    }

    private JMenu initFileMenu() {
        String name = Configuration.getInstance().getLabel(Label.FILE);
        if (logger.isTraceEnabled()) {
            logger.trace("initFileMenu() - Translated label File -> " + name);
        }
        JMenu menu = new JMenu(name);
        menu.setMnemonic(70);
        menu.add(this.selectInputItem);
        menu.add(this.saveOptionsMenuItem);
        menu.add(this.exitMenuItem);
        return menu;
    }

    private JMenu initOptionMenu() {
        String name = Configuration.getInstance().getLabel(Label.SETTINGS);
        if (logger.isTraceEnabled()) {
            logger.trace("initOptionMenu() - Translated label Option -> " + name);
        }
        JMenu menu = new JMenu(name);
        menu.setMnemonic(83);
        menu.add(this.checkAllSchemasMenuItem);
        menu.add(this.checkSchemaMenuItem);
        menu.addSeparator();
        menu.add(this.loadProtocolMenuItem);
        menu.add(this.browseProtocolMenuItem);
        menu.addSeparator();
        menu.add(this.optionsMenuItem);
        menu.add(this.clearMenuItem);
        return menu;
    }

    private JMenu initHelpMenu() {
        String name = Configuration.getInstance().getLabel(Label.HELP);
        if (logger.isTraceEnabled()) {
            logger.trace("initHelpMenu() - Translated label Help -> " + name);
        }
        JMenu menu = new JMenu(name);
        menu.setMnemonic(72);
        menu.add(this.helpMenuItem);
        menu.add(this.aboutMenuItem);
        return menu;
    }

    @Override
    public void setSelectInputAction(SelectInputAction selectInputAction) {
        this.selectInputItem.setAction(selectInputAction);
    }

    @Override
    public void setSelectOutputAction(Action action) {
    }

    @Override
    public void setSaveOptionsAction(Action action) {
        this.saveOptionsMenuItem.setAction(action);
    }

    @Override
    public void setExitAction(Action action) {
        this.exitMenuItem.setAction(action);
    }

    @Override
    public void setCheckSchemaAction(Action action) {
        this.checkSchemaMenuItem.setAction(action);
    }

    @Override
    public void setCheckAllSchemasAction(Action action) {
        this.checkAllSchemasMenuItem.setAction(action);
    }

    @Override
    public void setLoadProtocolAction(Action action) {
        this.loadProtocolMenuItem.setAction(action);
    }

    @Override
    public void setBrowseProtocolAction(Action action) {
        this.browseProtocolMenuItem.setAction(action);
    }

    @Override
    public void setOptionsAction(Action action) {
        this.optionsMenuItem.setAction(action);
    }

    @Override
    public void setCleanMonitor(Action action) {
        this.clearMenuItem.setAction(action);
    }

    @Override
    public void setHelpAction(Action action) {
        this.helpMenuItem.setAction(action);
    }

    @Override
    public void setAboutAction(Action action) {
        this.aboutMenuItem.setAction(action);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }
}

