/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.gui.view.MainFrame;
import eu.europa.ec.jrc.qcs.gui.view.MainView;
import eu.europa.ec.jrc.qcs.gui.view.MonitorView;
import eu.europa.ec.jrc.qcs.gui.view.ProgressView;
import eu.europa.ec.jrc.qcs.gui.view.ValidationBar;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainViewImpl
extends MainView {
    protected ValidationBar validationBar;
    protected MonitorView monitorView;
    protected ProgressView progressView;
    protected MainFrame mainFrame;
    protected static Logger logger = LoggerFactory.getLogger(MainViewImpl.class);

    public MainViewImpl() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.southPanel = new JPanel();
        this.northPanel.setLayout(new BorderLayout());
        this.northPanel.add(this.getImagePanel(Property.BANNER_IMG));
        this.centerPanel.setLayout(new BorderLayout());
        String comment = Configuration.getInstance().getComment();
        Object version = Configuration.getInstance().getProperty(Property.VERSION);
        if (comment != null) {
            version = (String)version + " <span style='font-size:8px'>(" + comment + ")</span>";
        }
        JLabel versionLabel = new JLabel("<html><p style='font-size:10px;padding-left:0px'>" + (String)version + "</p></html>");
        this.southPanel.add(versionLabel);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.mainPanel.setOpaque(true);
        if (logger.isDebugEnabled()) {
            logger.debug("Created default MainView");
        }
    }

    public MainViewImpl(MainFrame mainFrame) {
        this();
        this.mainFrame = mainFrame;
        this.mainFrame.setMainView(this);
    }

    @Override
    public void setButtonsBar(ValidationBar buttons) {
        this.validationBar = buttons;
        this.centerPanel.add((Component)buttons.getPanel(), "North");
    }

    @Override
    public void setMonitorView(MonitorView monitor) {
        this.monitorView = monitor;
        this.centerPanel.add((Component)monitor.getPanel(), "Center");
    }

    @Override
    public void setProgessView(ProgressView monitor) {
        this.progressView = monitor;
        this.centerPanel.add((Component)monitor.getProgressBar(), "South");
    }

    @Override
    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public ValidationBar getValidationBar() {
        return this.validationBar;
    }

    public ProgressView getProgressView() {
        return this.progressView;
    }

    public MonitorView getMonitorView() {
        return this.monitorView;
    }
}

