/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.view.GenericView;
import eu.europa.ec.jrc.qcs.gui.view.ImagePanel;
import eu.europa.ec.jrc.qcs.gui.view.MainFrame;
import eu.europa.ec.jrc.qcs.gui.view.MonitorView;
import eu.europa.ec.jrc.qcs.gui.view.ProgressView;
import eu.europa.ec.jrc.qcs.gui.view.ValidationBar;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainView
extends GenericView {
    protected MainController controller;
    protected ImagePanel imagePanel;
    protected JPanel mainPanel;
    protected JPanel northPanel;
    protected JPanel centerPanel;
    protected JPanel southPanel;
    protected static Logger logger = LoggerFactory.getLogger(MainView.class);

    public void setController(MainController controller) {
        this.controller = controller;
    }

    public MainController getController() {
        return this.controller;
    }

    public abstract void setButtonsBar(ValidationBar var1);

    public abstract void setMonitorView(MonitorView var1);

    public abstract void setProgessView(ProgressView var1);

    public abstract MainFrame getMainFrame();

    public JComponent getMainPanel() {
        return this.mainPanel;
    }

    protected ImagePanel getImagePanel(Property bannerKey) {
        if (this.imagePanel == null) {
            try {
                Configuration configuration = Configuration.getInstance();
                URL banner = this.getClass().getResource(configuration.getProperty(bannerKey));
                URL thinColumn = this.getClass().getResource(configuration.getProperty(Property.BANNER_COL));
                this.imagePanel = new ImagePanel(banner, thinColumn);
            }
            catch (Exception e) {
                logger.error("getImagePanel() - Failed to load images for the north panel !!!");
                this.imagePanel = new ImagePanel();
            }
        }
        return this.imagePanel;
    }

    public JFrame getWindowAncestor() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.getMainPanel());
    }
}

