/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.Main;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputDialog
extends JDialog {
    private static final long serialVersionUID = 6345488776810200464L;
    private JTextField textField;
    private String password;
    private boolean result;
    protected static Logger logger = LoggerFactory.getLogger(Main.class);

    public static boolean showDialog(String password) {
        InputDialog dialog = new InputDialog(password);
        return dialog.getResult();
    }

    public InputDialog(String password) {
        this.password = password;
        this.setTitle("Restoring factory database");
        JLabel titleLabel = new JLabel("WARNING", 0);
        titleLabel.setFont(new Font("Arial", 1, 16));
        titleLabel.setForeground(Color.RED);
        titleLabel.setBackground(Color.YELLOW);
        titleLabel.setOpaque(true);
        titleLabel.setPreferredSize(new Dimension(500, 40));
        titleLabel.setAlignmentX(0.5f);
        String message = "<html>The local database storing the QCS configuration differs from the factory database.<br>Do you wish to restore the factory database?<br><br/>To restore the factory configuration, write the word <b>" + this.password + "</b> in the text box below and press OK.</html>";
        JLabel messageLabel = new JLabel(message);
        messageLabel.setFont(new Font("Arial", 0, 12));
        messageLabel.setAlignmentX(0.5f);
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(80, 25));
        JPanel inputPanel = new JPanel(new FlowLayout(1));
        inputPanel.add(this.textField);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            String input = this.textField.getText();
            if (password.equalsIgnoreCase(input)) {
                this.result = true;
                this.dispose();
                if (logger.isDebugEnabled()) {
                    logger.debug("InputDialog() - User entered the correct password");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Wrong text: try again or cancel", "Error", 0);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.result = false;
            this.dispose();
            if (logger.isDebugEnabled()) {
                logger.debug("InputDialog() - User canceled the confirm action");
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add(titleLabel);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(messageLabel);
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(inputPanel);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(buttonPanel);
        this.add(mainPanel);
        this.setSize(500, 250);
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.setVisible(true);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean getResult() {
        return this.result;
    }
}

