/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = -1661549903808710937L;
    private Image image;
    private Image col;
    private int startWidth;
    private int startHeight;
    protected static Logger logger = LoggerFactory.getLogger(ImagePanel.class);

    public ImagePanel() {
        JLabel label = new JLabel("Error: failed to load images");
        this.add(label);
    }

    public ImagePanel(URL image, URL col) {
        this(new ImageIcon(image).getImage(), new ImageIcon(col).getImage());
    }

    public ImagePanel(Image image, Image col) {
        this.image = image;
        this.col = col;
        this.startWidth = image.getWidth(null);
        this.startHeight = image.getHeight(null);
        if (logger.isDebugEnabled()) {
            logger.debug("Created with images: " + String.valueOf(image) + ", " + String.valueOf(col));
        }
        Dimension size = new Dimension(this.startWidth, this.startHeight);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
        this.setLayout(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        int colWidth = (int)(size.getWidth() - (double)this.startWidth);
        if (logger.isTraceEnabled()) {
            logger.trace("paintComponent - size: " + size.getWidth() + " x " + size.getHeight());
        }
        g.drawImage(this.image, 0, 0, null);
        g.drawImage(this.col, this.startWidth, 0, colWidth, this.startHeight, null);
        if (logger.isTraceEnabled()) {
            logger.trace("paintComponent - width: " + size.getWidth() + " vs " + this.startWidth);
        }
    }
}

