/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPanel
implements Runnable {
    private String title = "ENCR QCS Help";
    private String[] lines = new String[4];
    private String link;
    private JFrame parent;
    private JDialog dialog;
    protected static Logger logger = LoggerFactory.getLogger(HelpPanel.class);

    public HelpPanel() {
        this.lines[0] = "Please find below a button leading to the folder with the relevant ";
        this.lines[1] = "documents for the QCS.";
        this.lines[2] = "You can look for updates at the address: ";
        this.lines[3] = "In case of questions, you are welcome to contact us writing at JRC-ENCR@ec.europa.eu";
        this.link = "https://encr.eu/tools-for-registries";
        this.dialog = new JDialog(this.parent, "Help", true);
    }

    @Override
    public void run() {
        JButton button = new JButton("Open documents folder");
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add(button);
        Container pane = this.dialog.getContentPane();
        this.applyBoxLayout(pane, bottomPanel);
        button.addActionListener(new ShowDialogListener());
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setPreferredSize(new Dimension(400, 300));
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    protected void applyBoxLayout(Container pane, JPanel footer) {
        pane.setLayout(new BoxLayout(pane, 1));
        String style = "font-size:10px;";
        String titlestyle = style + "margin:2px 0px 0px 100px; font-weight:bold;";
        String linestyle = style + "margin:2px 10px 0px 10px;";
        String linkstyle = style + "margin:2px 10px 0px 10px;";
        this.addJLabel(pane, this.title, titlestyle);
        this.addJLabel(pane, "&nbsp;", style);
        this.addJLabel(pane, this.lines[0] + this.lines[1], linestyle);
        this.addJLabel(pane, this.lines[2], linestyle);
        this.addHyperLink(pane, this.link, linkstyle);
        this.addJLabel(pane, "&nbsp;", style);
        this.addJLabel(pane, this.lines[3], linestyle);
        this.addJLabel(pane, "&nbsp;", style);
        this.addJLabel(pane, "&nbsp;", style);
        pane.add(footer);
    }

    protected void addJLabel(Container container, String text, String style) {
        String openHTML = "<html><p style='";
        String closeStyle = "'>";
        String closeHTML = "</p></html>";
        String formattedText = openHTML + style + closeStyle + text + closeHTML;
        JLabel label = new JLabel(formattedText);
        label.setAlignmentX(0.5f);
        container.add(label);
    }

    protected void addHyperLink(Container container, final String text, final String style) {
        String openHTML = "<html><p style='";
        String closeStyle = "'>";
        String closeHTML = "</p></html>";
        final String formattedText = "<html><p style='" + style + "'>" + text + "</p></html>";
        final JLabel hyperlink = new JLabel(formattedText);
        hyperlink.setForeground(Color.BLUE.darker());
        hyperlink.setAlignmentX(0.5f);
        hyperlink.setCursor(Cursor.getPredefinedCursor(12));
        container.add(hyperlink);
        hyperlink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (logger.isInfoEnabled()) {
                    logger.info("mouseClicked() - Opening URI: " + text);
                }
                try {
                    Desktop.getDesktop().browse(new URI(text));
                }
                catch (IOException | URISyntaxException ioe) {
                    logger.error("mouseClicked() - " + ioe.getMessage());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("mouseEntered()");
                }
                String formattedText2 = "<html><p style='" + style + "'><a href=''>" + text + "</a></p></html>";
                hyperlink.setText(formattedText2);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("mouseExited()");
                }
                hyperlink.setText(formattedText);
            }
        });
    }

    protected void applyBorderLayout(Container pane, JPanel footer) {
        if (logger.isDebugEnabled()) {
            logger.debug("applyBorderLayout() - Applying border layout");
        }
        logger.info("applyBorderLayout() - Applying border layout");
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<body style='margin:5px 10px;'>");
        builder.append("<p style='margin: 0px 0px 0px 100px; font-size: 10px; font-weight: bold; border: 0px solid blue;'>");
        builder.append(this.title);
        builder.append("</p>");
        builder.append("</body></html>");
        JLabel title = new JLabel(builder.toString());
        String style = "padding:5px; background-color:#EAEAEA; border:0px dashed yellow;";
        String paragraph = "<p style='" + style + "'>";
        String lastParagraph = "<p style='margin:0px 0px 100px 0px; " + style + "'>";
        StringBuilder help = new StringBuilder();
        help.append("<html>");
        help.append("<body style='margin:0px 10px'>");
        help.append(paragraph);
        help.append(this.lines[0] + "<br/>" + this.lines[1]);
        help.append("</p>");
        help.append(paragraph);
        help.append(this.lines[2]);
        help.append("<br/>");
        help.append("<a href=''>" + this.link + "</a>");
        help.append("</p>");
        help.append(lastParagraph);
        help.append(this.lines[3]);
        help.append("</p>");
        help.append("</body></html>");
        JLabel body = new JLabel(help.toString());
        pane.add((Component)title, "First");
        pane.add((Component)body, "Before");
        pane.add((Component)footer, "Last");
    }

    class ShowDialogListener
    implements ActionListener {
        ShowDialogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String targetFolder = "docs/";
            if (logger.isInfoEnabled()) {
                logger.info("actionPerformed() - Opening manuals directory: " + targetFolder);
            }
            try {
                Desktop.getDesktop().open(new File(targetFolder));
            }
            catch (Exception exception) {
                logger.error("Failed to open the \"" + targetFolder + "\" directory: " + exception.getMessage());
            }
        }
    }
}

