/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.gui.model.workers.GeneralWorker;
import eu.europa.ec.jrc.qcs.gui.view.MainFrame;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertDialog {
    protected static AlertDialog alertPanel;
    protected JFrame parent;
    protected JDialog dialog;
    protected GeneralWorker worker;
    protected String title = "Modal Panel";
    protected String message = "No message";
    protected String firstButtonMessage = "Cancel";
    protected String secondButtonMessage;
    protected int padding = 10;
    protected int width = 350;
    protected int height = 180;
    protected int action = 0;
    protected Dialog.ModalityType modalType = Dialog.ModalityType.DOCUMENT_MODAL;
    public static final int CLOSE = 0;
    public static final int QUIT = 1;
    public static final int STOP = 2;
    protected static Logger logger;

    private AlertDialog() {
        if (logger.isDebugEnabled()) {
            logger.debug("Constructor() - Created with title: " + this.title);
        }
    }

    private AlertDialog(JFrame parent) {
        this();
        this.parent = parent;
    }

    public static void initPanel(MainFrame parent) {
        if (alertPanel != null) {
            logger.warn("initPanel() - Panel was already configured: overriding previous instance");
        }
        if (parent instanceof JFrame) {
            JFrame jFrame = (JFrame)((Object)parent);
            alertPanel = new AlertDialog(jFrame);
        }
    }

    public static AlertDialog getInstance() {
        if (alertPanel != null) {
            return alertPanel;
        }
        logger.error("getInstance() - Found null singleton instance (no parent jFrame?)");
        return null;
    }

    public void openPanel() {
        if (logger.isDebugEnabled()) {
            logger.debug("openPanel() - Thread: " + Thread.currentThread().getName());
        }
        this.dialog = new JDialog((Window)this.parent, this.title, this.modalType);
        Rectangle bounds = this.parent.getBounds();
        int centerX = (int)(bounds.getCenterX() - (double)(this.width / 2));
        int centerY = (int)(bounds.getCenterY() - (double)(this.height / 2));
        this.dialog.setBounds(centerX, centerY, this.width, this.height);
        if (logger.isDebugEnabled()) {
            logger.debug("Bounds : " + String.valueOf(bounds));
            logger.debug("Center : " + centerX + "," + centerY);
        }
        JLabel label = new JLabel(this.message);
        JButton button_1 = new JButton(this.firstButtonMessage);
        JButton button_2 = this.secondButtonMessage != null ? new JButton(this.secondButtonMessage) : null;
        button_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertDialog.this.handleFirstAction(e);
            }
        });
        if (button_2 != null) {
            button_2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlertDialog.this.handleSecondAction(e);
                }
            });
        }
        if (logger.isDebugEnabled()) {
            logger.debug("openPanel() - Added action listeners");
        }
        JPanel pane = (JPanel)this.dialog.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(this.padding, this.padding, this.padding, this.padding));
        pane.add((Component)label, "Center");
        JPanel south = new JPanel();
        south.add(button_1);
        if (button_2 != null) {
            south.add(button_2);
        }
        pane.add((Component)south, "South");
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AlertDialog.this.handleFirstAction(e);
            }
        });
        this.dialog.setVisible(true);
        if (logger.isInfoEnabled()) {
            logger.info("openPanel() - Set visible dialog: " + String.valueOf(this.dialog));
        }
    }

    public void handleFirstAction(AWTEvent event) {
        switch (this.action) {
            case 0: {
                this.closePanel();
                break;
            }
            case 1: {
                this.closeApplication(event);
                break;
            }
            default: {
                this.closePanel();
            }
        }
    }

    public void handleSecondAction(AWTEvent event) {
        switch (this.action) {
            case 0: {
                logger.warn("handleSecondAction() - Panels in CLOSE mode should have only one button (basic alerts with no other choice)");
                break;
            }
            case 1: {
                this.closePanel();
                break;
            }
            case 2: {
                if (this.worker != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info("handleSecondAction() - Stopping Swing worker: " + String.valueOf(this.worker));
                    }
                    this.worker.stop();
                } else {
                    logger.error("handleSecondAction() - Null reference to worker's thread");
                }
                this.closePanel();
                break;
            }
            default: {
                this.closePanel();
            }
        }
    }

    public void closePanel() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        if (logger.isDebugEnabled()) {
            logger.debug("closePanel [" + Thread.currentThread().getName() + "]");
        }
    }

    private void closeApplication(AWTEvent e) {
        this.closePanel();
        this.parent.setVisible(false);
        this.parent.dispose();
        if (e instanceof WindowEvent) {
            ((WindowEvent)e).getWindow().dispose();
        }
        logger.warn("closeApplication() - User quit alert panel -> exiting...");
        System.exit(0);
    }

    public JFrame getParent() {
        return this.parent;
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getFirstButtonMessage() {
        return this.firstButtonMessage;
    }

    public void setFirstButtonMessage(String buttonMessage) {
        this.firstButtonMessage = buttonMessage;
    }

    public String getSecondButtonMessage() {
        return this.secondButtonMessage;
    }

    public void setSecondButtonMessage(String secondButtonMessage) {
        this.secondButtonMessage = secondButtonMessage;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public Dialog.ModalityType getModalType() {
        return this.modalType;
    }

    public void setModalType(Dialog.ModalityType modalType) {
        this.modalType = modalType;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public GeneralWorker getWorker() {
        return this.worker;
    }

    public void setWorker(GeneralWorker worker) {
        this.worker = worker;
    }

    static {
        logger = LoggerFactory.getLogger(AlertDialog.class);
    }
}

