/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.gui.controller.CheckLicenseAction;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.view.MainFrame;
import eu.europa.ec.jrc.qcs.gui.view.MainView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutPanel
implements Runnable {
    private String title;
    private String eurolog;
    private String collaboration;
    private String institute;
    private String copyright;
    private String version;
    private String dbVersion;
    private String license;
    private JFrame parent;
    private JDialog frame;
    private String credits;
    protected static Logger logger = LoggerFactory.getLogger(AboutPanel.class);

    public AboutPanel(JFrame parent) {
        this.parent = parent;
        this.title = "JRC-ENCR Quality Check Software";
        this.eurolog = "Developed by the European Commission Joint Research Centre.";
        this.collaboration = "In support of the European Network of Cancer Registries (ENCR).";
        this.institute = "Directorate F - Health, Consumers and Reference Materials. Disease Prevention Unit.";
        this.copyright = "Copyright 2016-2025 European Union";
        this.license = "Licensed under the EUPL";
        this.version = Configuration.getInstance().getProperty(Property.VERSION);
        this.dbVersion = Configuration.getInstance().getDatabaseVersion();
        if (logger.isDebugEnabled()) {
            logger.debug("Constructor() - Using parent frame: " + String.valueOf(this.parent));
        }
        this.frame = new JDialog(this.parent, "About", true);
    }

    @Override
    public void run() {
        StringBuilder about = new StringBuilder();
        about.append("<html>");
        about.append("<body style='margin: 0px 10px'>");
        about.append("<span style='font-size: 10px;'><strong>");
        about.append(this.title);
        about.append("</strong></span><br/><br/>");
        about.append(this.eurolog);
        about.append("<br/>");
        about.append(this.institute);
        about.append("<br/><br/>");
        about.append(this.collaboration);
        about.append("<br/><br/>");
        about.append("QCS Version:&nbsp;");
        about.append(this.version);
        about.append("<br/>");
        about.append("DB version:&nbsp;");
        about.append(this.dbVersion);
        about.append("<br/>");
        about.append("<span style='font-size: 8px;'><em>");
        about.append("Build: ");
        about.append(Configuration.getBuildNumber());
        about.append("</em></span>");
        about.append("<br/><br/>");
        about.append(this.copyright);
        about.append("<br/>");
        about.append(this.license);
        about.append("</body></html>");
        JLabel label = new JLabel(about.toString());
        String[][] jars = new String[][]{{"commons-cli-1.3.1.jar", "Link 1"}, {"commons-logging-1.2.jar", "Link 2"}, {"fontbox-2.0.12.jar", "Link 3"}, {"hamcrest-core-1.3.jar", "Link 4"}, {"junit-4.12.jar", "Link 5"}, {"log4j-api-2.17.1.jar", "Link 6"}, {"log4j-core-2.17.1.jar", "Link 7"}, {"log4j-slf4j-impl-2.17.1.jar", "Link 8"}, {"pdfbox-2.0.23.jar", "Link 9"}, {"pdfbox-debugger-2.0.12.jar", "Link 10"}, {"pdfbox-tools-2.0.12.jar", "Link 11"}, {"slf4j-api-1.7.32.jar", "Link 13"}, {"snakeyaml-2.2.jar", "Link 14"}};
        StringBuilder builder = new StringBuilder();
        for (String[] library : jars) {
            builder.append(library[0] + "\n");
        }
        this.credits = builder.toString();
        this.frame.setDefaultCloseOperation(2);
        this.frame.setPreferredSize(new Dimension(450, 350));
        Container mainPane = this.frame.getContentPane();
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)label, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        mainPane.add((Component)buttonPanel, "Last");
        MainController controller = null;
        if (this.parent instanceof MainFrame) {
            MainFrame mainFrame = (MainFrame)((Object)this.parent);
            MainView mainView = mainFrame.getMainView();
            controller = mainView.getController();
            if (logger.isDebugEnabled()) {
                logger.debug("run() - Fetched reference to main controller: " + String.valueOf(controller));
            }
        }
        if (controller != null) {
            JButton licenseButton = new JButton("License");
            buttonPanel.add(licenseButton);
            licenseButton.addActionListener(new ShowLicenseListener(controller));
        } else if (logger.isWarnEnabled()) {
            logger.warn("run() - Null main controller -> no license button!");
        }
        JButton librariesButton = new JButton("Libraries");
        buttonPanel.add(librariesButton);
        librariesButton.addActionListener(new ShowLibrariesListener());
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public class ShowLicenseListener
    implements ActionListener {
        private MainController controller;

        public ShowLicenseListener(MainController controller) {
            this.controller = controller;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckLicenseAction checkLicenseAction = this.controller.getCheckLicenseAction();
            if (logger.isInfoEnabled()) {
                logger.info("actionPerformed() - Showing application license using action: " + String.valueOf(checkLicenseAction));
            }
            checkLicenseAction.actionPerformed(null);
        }
    }

    class ShowLibrariesListener
    implements ActionListener {
        ShowLibrariesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (logger.isInfoEnabled()) {
                logger.info("actionPerformed() - Showing list of JAR libraries");
            }
            JTextArea textArea = new JTextArea(6, 25);
            textArea.setText(AboutPanel.this.credits);
            textArea.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            JOptionPane.showMessageDialog(AboutPanel.this.frame, scrollPane, "Libraries", -1);
        }
    }
}

