/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model.workers;

import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.gui.model.MessageLayout;
import eu.europa.ec.jrc.qcs.gui.model.workers.GeneralWorker;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationWorker
extends GeneralWorker {
    private ValidationEngine validationEngine;
    private int progressedItems;
    protected boolean demo;
    public static final String STARTED = "Validation started";
    public static final String COMPLETED = "Validation completed";
    protected static Logger logger = LoggerFactory.getLogger(ValidationWorker.class);

    public ValidationWorker(ValidationEngine validationEngine) {
        this.validationEngine = validationEngine;
        if (this.isVerbose()) {
            logger.info("Set engine: " + GenericModel.getObjectIdentifier(validationEngine));
        }
    }

    @Override
    protected List<String> doInBackground() throws Exception {
        if (this.isVerbose()) {
            logger.info("doInBackground() - Running engine: " + GenericModel.getObjectIdentifier(this.validationEngine));
        }
        this.setWorkerThread(Thread.currentThread());
        if (!this.demo) {
            this.sendMessage("\nPlease wait: initialising validation engine");
            this.validationEngine.resetAllStopSignals();
            this.validationEngine.run();
            this.complete();
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("doInBackground() - Running demo process");
            }
            this.demoProcess();
        }
        return null;
    }

    @Override
    protected void process(List<String> chunks) {
        if (this.isVerbose()) {
            logger.info("process() - Logging chunks");
        }
        this.logAllChunks(chunks);
        this.progressedItems += chunks.size();
        int progress = this.evalProgress(this.progressedItems);
        if (this.isVerbose()) {
            logger.info("process() - Evaluated progress value: " + progress);
        }
        if (progress >= 0 && progress <= 100) {
            this.setProgress(progress);
        } else {
            logger.warn("process() - Wrong progressedItems: " + this.progressedItems + " -> " + progress);
        }
    }

    @Override
    protected void done() {
        if (this.isVerbose()) {
            logger.info("done() - Resetting worker's status");
        }
        this.setMessageLayout(MessageLayout.BLACK);
        if (this.validationEngine.isStopValidation()) {
            this.validationEngine.hardReset();
            if (logger.isWarnEnabled()) {
                logger.warn("done() - Triggered HARD_RESET to the validation engine");
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("done() - Validation worker completed");
        }
    }

    @Override
    public void stop() {
        Thread actualThread = this.getWorkerThread();
        if (logger.isInfoEnabled()) {
            logger.info("stop() - Stopping validation engine: " + GenericModel.getObjectIdentifier(this.validationEngine) + " [" + String.valueOf(actualThread) + "]");
        }
        this.validationEngine.setStopValidation(true);
    }

    public ValidationEngine getValidationEngine() {
        return this.validationEngine;
    }

    public void setValidationEngine(ValidationEngine validationEngine) {
        this.validationEngine = validationEngine;
    }

    public int getProgressedItems() {
        return this.progressedItems;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean demo) {
        this.demo = demo;
    }

    protected void demoProcess() throws Exception {
        this.maxProgress = 40;
        this.sleepAWhile();
        for (int i = 0; i < this.maxProgress; ++i) {
            this.sleepAWhile();
            this.publish(String.valueOf(i));
        }
        this.sleepAWhile();
    }
}

