/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model.workers;

import eu.europa.ec.jrc.qcs.gui.model.MessageLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneralWorker
extends SwingWorker<List<String>, String> {
    protected Thread workerThread;
    protected volatile int maxProgress;
    protected boolean verbose;
    public static final String STATE_EVENT = "state";
    public static final String PROGRESS_EVENT = "progress";
    public static final String MESSAGE_EVENT = "message";
    public static final String LAYOUT_EVENT = "layout";
    protected static Logger logger = LoggerFactory.getLogger(GeneralWorker.class);

    public void stop() {
        Thread actualThread = this.getWorkerThread();
        if (logger.isInfoEnabled()) {
            logger.info("stop() - Stopping validation thread: " + String.valueOf(actualThread));
        }
        try {
            actualThread.interrupt();
            if (logger.isInfoEnabled()) {
                logger.info("stop() - Stopped thread (perhaps) ??? " + String.valueOf(actualThread));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    protected void done() {
        if (logger.isInfoEnabled()) {
            logger.info("done() - Worked process completed");
        }
    }

    public void sendMessage(String message) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(message);
        if (logger.isDebugEnabled()) {
            logger.debug("sendMessage() - Firing next message: " + message);
        }
        this.firePropertyChange(MESSAGE_EVENT, null, list);
    }

    public void setMessageLayout(MessageLayout layout) {
        if (logger.isDebugEnabled()) {
            logger.debug("setMessageLayout() - Setting next message layout: " + String.valueOf(layout));
        }
        this.firePropertyChange(LAYOUT_EVENT, null, layout);
    }

    public void updateProgress(int value) {
        this.publish(String.valueOf(value));
    }

    protected void logAllChunks(List<String> chunks) {
        if (chunks.size() == 1) {
            String string = chunks.get(0);
            if (logger.isDebugEnabled()) {
                logger.debug("process() - New element: " + string);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("process() - Many elements: " + String.valueOf(chunks));
        }
    }

    protected int evalProgress(int progressedItems) {
        int progress = (int)(100.0 / (double)this.maxProgress * (double)progressedItems);
        return progress;
    }

    protected void complete() {
        int lastProgress = this.evalProgress(this.maxProgress);
        if (logger.isInfoEnabled()) {
            logger.info("complete() - Completed with: maxProgress = " + this.maxProgress + ", lastProgress = " + lastProgress);
        }
        this.setProgress(100);
    }

    protected void sleepAWhile() {
        try {
            Thread.yield();
            long timeToSleep = 15L;
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            logger.info("sleepAWhile() - Paused woker: " + e.getMessage());
        }
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public Thread getWorkerThread() {
        return this.workerThread;
    }

    public void setWorkerThread(Thread workerThread) {
        this.workerThread = workerThread;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

