/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model.workers;

import eu.europa.ec.jrc.qcs.gui.model.workers.GeneralWorker;
import eu.europa.ec.jrc.qcs.test.FlatFileTester;
import eu.europa.ec.jrc.qcs.test.SchemasAnalyzer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckIntegrityWorker
extends GeneralWorker {
    protected int schemaID;
    protected static Logger logger = LoggerFactory.getLogger(CheckIntegrityWorker.class);

    public CheckIntegrityWorker(Object model) {
    }

    @Override
    protected List<String> doInBackground() throws Exception {
        this.maxProgress = 4;
        ArrayList<String> dummy = new ArrayList<String>();
        this.publish("Starting integrity check (all schemas)\n");
        FlatFileTester flatFileDAOTester = new FlatFileTester();
        boolean flatFileConfiguration = flatFileDAOTester.checkFlatFilesConfiguration(this.schemaID);
        if (logger.isInfoEnabled()) {
            logger.info("Flat files configuration: " + (flatFileConfiguration ? "OK" : "ERROR"));
        }
        if (flatFileConfiguration) {
            this.publish("Checking existence of configuration files...");
        } else {
            this.publish("Checking existence of configuration files... ERROR");
        }
        if (!flatFileConfiguration) {
            logger.warn("Found invalid flat file configuration: skipping next checks");
        } else {
            this.publish("Checking integrity of single files...");
            SchemasAnalyzer schemasAnalyzer = new SchemasAnalyzer();
            schemasAnalyzer.checkSchemasComponents();
            this.publish("Checking integrity of configuration files...\n");
            schemasAnalyzer.propagateErrors(this.schemaID);
            String report = this.schemaID > 0 ? schemasAnalyzer.getResultsBySchema(this.schemaID) : schemasAnalyzer.getAllResults();
            this.publish(report);
        }
        return dummy;
    }

    @Override
    protected void process(List<String> delta) {
        this.logAllChunks(delta);
        this.firePropertyChange("message", null, delta);
    }

    public int getSchemaID() {
        return this.schemaID;
    }

    public void setSchemaID(int schemaID) {
        this.schemaID = schemaID;
    }
}

