/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TableDataUIModel {
    protected JTable table;
    protected Dimension dimension;
    protected DefaultTableCellRenderer renderer;
    public static final int MID_SCROLLABLE = 1;
    public static final int FILLS_HEIGHT = 2;
    public static final int SCROLLABLE_1100X500 = 3;

    public TableDataUIModel(JTable table) {
        this.table = table;
    }

    public void setTemplate(int template) {
        switch (template) {
            case 1: {
                this.setPreferredScrollableViewportSize(400);
                break;
            }
            case 2: {
                this.setFillsViewportHeight();
                break;
            }
            case 3: {
                this.setFixedScrollableViewportSize(1100, 500);
                break;
            }
            default: {
                this.setPreferredScrollableViewportSize(300);
            }
        }
    }

    public void setPreferredScrollableViewportSize(int height) {
        this.dimension = this.table.getPreferredSize();
        this.dimension.setSize(this.dimension.getWidth(), (double)height);
        this.table.setPreferredScrollableViewportSize(this.dimension);
    }

    public void setFillsViewportHeight() {
        this.dimension = this.table.getPreferredSize();
        this.table.setPreferredScrollableViewportSize(this.dimension);
        this.table.setFillsViewportHeight(true);
    }

    public void setFixedScrollableViewportSize(int width, int height) {
        this.dimension = new Dimension(width, height);
        this.table.setPreferredScrollableViewportSize(this.dimension);
        this.table.setFillsViewportHeight(true);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public DefaultTableCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DefaultTableCellRenderer renderer) {
        this.renderer = renderer;
    }
}

