/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.engine.RulesFactory;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.gui.model.TableDataModel;
import java.util.ArrayList;
import java.util.List;

public class RuleTableDataModel
extends TableDataModel {
    protected List<ProtocolToRule> protocolToRules;
    protected RulesFactory rulesFactory = new RulesFactory();
    protected AbstractRule ruleImpl;
    protected int lastRow = -1;

    public void addProtocolToRule(int index, ProtocolToRule protocolToRule) {
        if (this.protocolToRules == null) {
            this.protocolToRules = new ArrayList<ProtocolToRule>();
        }
        this.protocolToRules.add(index, protocolToRule);
        if (logger.isDebugEnabled()) {
            logger.debug("addProtocolToRule() - Added ProtocolToRule: " + index + " -> " + String.valueOf(protocolToRule));
        }
    }

    public String getRuleName(int row) {
        if (this.checkRowNumber(row)) {
            return (String)this.data[row][1];
        }
        return "Undef";
    }

    public String getRuleImplementation(int row) {
        if (this.checkRowNumber(row)) {
            return (String)this.data[row][2];
        }
        return "Unknown";
    }

    public String getErrorCode(int row) {
        if (this.checkRowNumber(row)) {
            return (String)this.data[row][4];
        }
        return "";
    }

    public String getRuleDescription(int row) {
        AbstractRule ruleImpl = this.getAbstractRule(row);
        return ruleImpl.getLongDescription();
    }

    public String getRuleType(int row) {
        AbstractRule ruleImpl = this.getAbstractRule(row);
        RuleConfiguration ruleConfiguration = ruleImpl.getRuleConfiguration();
        RuleType ruleType = ruleConfiguration.getRuleType();
        return ruleType.description;
    }

    public AbstractRule getAbstractRule(int row) {
        if (!this.checkRowNumber(row)) {
            logger.error("Impossibile to fetch target rule (wrong row index)");
        }
        if (this.protocolToRules == null) {
            logger.error("Impossibile to fetch target rule (no protocol-to-rule)");
        }
        if (row > this.protocolToRules.size()) {
            logger.error("Impossibile to fetch target rule (row index is too big)");
        }
        if (this.lastRow != row) {
            if (logger.isDebugEnabled()) {
                logger.debug("getAbstractRule() - Changing last row index: " + this.lastRow + " -> " + row);
            }
            this.lastRow = row;
            this.ruleImpl = null;
        }
        if (this.ruleImpl != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getAbstractRule() - Returning cache rule: " + String.valueOf(this.ruleImpl));
            }
            return this.ruleImpl;
        }
        ProtocolToRule protocolToRule = this.protocolToRules.get(row);
        if (logger.isDebugEnabled()) {
            logger.debug("getAbstractRule() - Getting info for row: " + row + " -> " + String.valueOf(protocolToRule));
        }
        RuleDefinition ruleDefinition = protocolToRule.getRule();
        this.ruleImpl = this.rulesFactory.getRuleImplementation(ruleDefinition);
        return this.ruleImpl;
    }

    protected boolean checkRowNumber(int row) {
        if (row < 0) {
            logger.error("checkRowNumber() - Negative row number: " + row);
            return false;
        }
        if (row > this.data.length) {
            logger.error("checkRowNumber() - Row number too big: " + row);
            return false;
        }
        return true;
    }

    public List<ProtocolToRule> getProtocolToRules() {
        return this.protocolToRules;
    }

    public void setProtocolToRules(List<ProtocolToRule> protocolToRules) {
        this.protocolToRules = protocolToRules;
    }
}

