/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import java.util.Map;
import java.util.Set;

public class OptionModel<T> {
    private Property property;
    private T value;
    private String label;
    private Map<T, String> optionsLabels;

    public OptionModel(Property property, T value) {
        this(property);
        this.value = value;
    }

    public OptionModel(Property property) {
        this.property = property;
    }

    public int getNumberOfOptions() {
        if (this.optionsLabels == null) {
            return 1;
        }
        return this.optionsLabels.size();
    }

    public Set<T> getAllOptionsValues() {
        if (this.optionsLabels == null) {
            return null;
        }
        return this.optionsLabels.keySet();
    }

    public String getOptionLabel(T value) {
        if (this.optionsLabels == null) {
            return this.label;
        }
        return this.optionsLabels.get(value);
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<T, String> getOptionsLabels() {
        return this.optionsLabels;
    }

    public void setOptionsLabels(Map<T, String> optionsLabels) {
        this.optionsLabels = optionsLabels;
    }
}

