/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.gui.controller.MonitorException;
import eu.europa.ec.jrc.qcs.gui.controller.ValidationWorkerMonitor;
import eu.europa.ec.jrc.qcs.gui.model.ListDataModel;
import eu.europa.ec.jrc.qcs.gui.model.MessageLayout;
import eu.europa.ec.jrc.qcs.gui.view.MonitorView;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorModel
implements ValidationWorkerMonitor {
    private Document document;
    private MonitorView view;
    private MessageLayout messageLayout;
    private ListDataModel<SchemasGroup> schemaGroupModel;
    private ListDataModel<Protocol> protocolModel;
    private SchemaGroupSelectionListener schemaGroupSelectionListener = new SchemaGroupSelectionListener();
    private ProtocolSelectionListener protocolSelectionListener = new ProtocolSelectionListener();
    protected static Logger logger = LoggerFactory.getLogger(MonitorModel.class);

    public MonitorModel() {
        this.document = new PlainDocument();
    }

    @Override
    public void setWorkerProgress(int progress) {
    }

    @Override
    public void setWorkerMessage(String message) {
        this.appendString(message + "\n");
    }

    @Override
    public void setMessageLayout(MessageLayout layout) {
        this.messageLayout = layout;
        if (logger.isDebugEnabled()) {
            logger.debug("setMessageLayout() - Set new message layout: " + String.valueOf(this.messageLayout));
        }
    }

    public void insertString(String string) {
        try {
            this.document.insertString(0, string, null);
        }
        catch (BadLocationException e) {
            String message = "Failed to insert the string: " + string;
            logger.error(message);
            throw new MonitorException(message, e);
        }
    }

    public void appendString(String string) {
        int length = this.document.getLength();
        if (this.messageLayout != null) {
            JTextArea textArea = this.getView().getTextArea();
            textArea.setForeground(this.messageLayout.getColor());
            if (logger.isDebugEnabled()) {
                logger.debug("appendString() - Changed message layout: " + String.valueOf(this.messageLayout));
            }
        }
        try {
            this.document.insertString(length, string, null);
        }
        catch (BadLocationException e) {
            String message = "Failed to append the string: " + string;
            logger.error(message);
            throw new MonitorException(message, e);
        }
    }

    public void clear() {
        try {
            this.document.remove(0, this.document.getLength());
        }
        catch (BadLocationException e) {
            String message = "Failed to clean document";
            logger.error(message);
            throw new MonitorException(message, e);
        }
    }

    public void setSchemaGroupDataModel(ListDataModel<SchemasGroup> schemaGroupModel) {
        this.schemaGroupModel = schemaGroupModel;
        ListSelectionModel selectionModel = schemaGroupModel.getListSelectionModel();
        if (selectionModel != null) {
            selectionModel.addListSelectionListener(this.schemaGroupSelectionListener);
        }
    }

    public void setProtocolDataModel(ListDataModel<Protocol> protocolModel) {
        this.protocolModel = protocolModel;
        ListSelectionModel selectionModel = protocolModel.getListSelectionModel();
        if (selectionModel != null) {
            selectionModel.addListSelectionListener(this.protocolSelectionListener);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public MonitorView getView() {
        return this.view;
    }

    public void setView(MonitorView view) {
        this.view = view;
    }

    private class SchemaGroupSelectionListener
    implements ListSelectionListener {
        private SchemaGroupSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel listSelectionModel = MonitorModel.this.schemaGroupModel.getListSelectionModel();
            int index = listSelectionModel.getMinSelectionIndex();
            SchemasGroup group = MonitorModel.this.schemaGroupModel.getElementAt(index);
            int id = group.getId();
            String selection = group.getDescription();
            Configuration configuration = Configuration.getInstance();
            String label = configuration.getLabel(Label.GROUP_SELECTED);
            String message = label + " " + selection + " [pos=" + index + " id=" + id + "]\n";
            if (logger.isDebugEnabled()) {
                logger.debug("SchemaGroupSelectionListener.valueChanged(): changed schema group: " + message);
            }
            MonitorModel.this.appendString(message);
            if (logger.isDebugEnabled()) {
                logger.debug("SchemaGroupSelectionListener.valueChanged(): [pos=" + index + " id=" + id + "]");
            }
        }
    }

    private class ProtocolSelectionListener
    implements ListSelectionListener {
        private ProtocolSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel listSelectionModel = MonitorModel.this.protocolModel.getListSelectionModel();
            int index = listSelectionModel.getMinSelectionIndex();
            Protocol protocol = MonitorModel.this.protocolModel.getElementAt(index);
            int id = protocol.getId();
            String selection = protocol.getDescription();
            Configuration configuration = Configuration.getInstance();
            String label = configuration.getLabel(Label.GROUP_SELECTED);
            String message = label + " " + selection + "\n";
            if (logger.isDebugEnabled()) {
                logger.debug("ProtocolSelectionListener.valueChanged(): changed protocol: " + message);
            }
            MonitorModel.this.appendString(message);
            if (logger.isDebugEnabled()) {
                logger.debug("ProtocolSelectionListener.valueChanged(): [pos=" + index + " id=" + id + "]");
            }
        }
    }
}

