/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDataModel<E>
extends AbstractListModel<E> {
    private List<E> list = new ArrayList();
    private ListSelectionModel listSelectionModel = new DefaultListSelectionModel();
    private String defaultItemID;
    private static final long serialVersionUID = -7234964428290820671L;
    protected static Logger logger = LoggerFactory.getLogger(ListDataModel.class);

    public ListDataModel() {
        this.listSelectionModel.setSelectionMode(0);
    }

    public ListDataModel(List<E> elements) {
        this();
        this.addAll(elements);
    }

    public void addAll(List<E> elements) {
        if (this.list.addAll(elements)) {
            this.fireIntervalAdded(elements.size());
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public E getElementAt(int index) {
        return this.list.get(index);
    }

    public void addElement(E element) {
        if (this.list.add(element)) {
            this.fireIntervalAdded(1);
        }
    }

    public void removeElement(E element) {
        int index = 0;
        ListIterator<E> iter = this.list.listIterator();
        while (iter.hasNext()) {
            Object entry = iter.next();
            if (entry.equals(element)) {
                iter.remove();
                if (logger.isDebugEnabled()) {
                    logger.debug("removeElement() - Removed " + String.valueOf(entry) + " [" + index + "]");
                }
                this.fireIntervalRemoved(index);
                return;
            }
            ++index;
        }
        logger.warn("removeElement() - Failed to remove element: " + String.valueOf(element));
    }

    protected void fireIntervalAdded(int elementCOunt) {
        int index = this.list.size() - elementCOunt;
        if (logger.isDebugEnabled()) {
            logger.debug("fireIntervalAdded(): " + Math.max(0, index) + ".." + Math.max(0, this.list.size() - 1));
        }
        this.fireIntervalAdded(this, Math.max(0, index), Math.max(0, this.list.size() - 1));
    }

    protected void fireIntervalRemoved(int removedItem) {
        if (logger.isDebugEnabled()) {
            logger.debug("fireIntervalRemoved(): " + Math.max(0, removedItem) + ".." + Math.max(0, removedItem));
        }
        this.fireIntervalRemoved(this, Math.max(0, removedItem), Math.max(0, removedItem));
    }

    public List<E> getList() {
        return this.list;
    }

    public void setList(List<E> list) {
        this.list = list;
    }

    public ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    public void setListSelectionModel(ListSelectionModel listSelectionModel) {
        this.listSelectionModel = listSelectionModel;
    }

    public String getDefaultItemID() {
        return this.defaultItemID;
    }

    public void setDefaultItemID(String defaultItemID) {
        this.defaultItemID = defaultItemID;
    }
}

