/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseModel {
    public static String HASHED_MAC;
    public static String SHORT_MAC;
    public static final String DEFAULT = "no";
    public static final String DEMO_MODE = "demo";
    protected static Logger logger;

    protected void init() {
        try {
            String macAddress = this.getMacAddress();
            if (macAddress == null) {
                macAddress = this.getMacOSAddress();
            }
            if (macAddress != null) {
                HASHED_MAC = this.calculateMD5Hash(macAddress);
                if (logger.isDebugEnabled()) {
                    logger.debug("init() - MAC Address: " + macAddress);
                    logger.debug("init() - MD5 Hashed MAC Address: " + HASHED_MAC);
                }
                SHORT_MAC = HASHED_MAC.substring(0, 5);
            } else {
                logger.error("init() - Failed to get the MAC address");
                this.forceLicenceKey();
            }
        }
        catch (Exception e) {
            logger.error("init() - Error when calculating the license key");
            e.printStackTrace();
            this.forceLicenceKey();
        }
    }

    private String getMacOSAddress() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("getMacOSAddress() - Trying to check MAC address on macOS");
        }
        ProcessBuilder processBuilder = new ProcessBuilder("/sbin/ifconfig");
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("ether")) continue;
                return line.trim().split("\\s+")[1];
            }
            int exitCode = process.waitFor();
            if (logger.isInfoEnabled()) {
                logger.info("getMacOSAddress() - Exited with code: " + exitCode);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private void forceLicenceKey() {
        SHORT_MAC = "ACK";
        HASHED_MAC = "The quick brown fox jumped over the lazy dog";
        if (logger.isWarnEnabled()) {
            logger.warn("forceLicenceKey() - Forced license key (fallback code)");
        }
    }

    public boolean checkLicenseKey() {
        String expectedValue = this.getExpectedLicenseKey();
        String storedValue = Configuration.getInstance().getProperty(Property.GUI_LICENSE_VALUE);
        if (logger.isDebugEnabled()) {
            logger.debug("checkLicense() - Current license key: " + storedValue + " VS expected value: " + expectedValue);
        }
        if (storedValue != null) {
            storedValue = storedValue.trim();
        }
        if (expectedValue == null || storedValue == null) {
            return false;
        }
        boolean result = expectedValue.equals(storedValue);
        if (logger.isDebugEnabled()) {
            logger.debug("checkLicense() - Correct license key ? " + result);
        }
        return result;
    }

    public String getLicenseText() {
        if (HASHED_MAC == null || SHORT_MAC == null) {
            this.init();
            if (logger.isDebugEnabled()) {
                logger.debug("getLicenseText() - Fetched hashed MAC: " + HASHED_MAC);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("getLicenseText() - Reusing hashed MAC: " + HASHED_MAC);
        }
        StringBuilder licenseText = new StringBuilder();
        if (logger.isInfoEnabled()) {
            logger.info("getLicenseText() - Short license key: " + SHORT_MAC);
        }
        try {
            String line;
            String filePath = "Licence.txt";
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(filePath), StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                licenseText.append(line).append("\n");
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return licenseText.toString();
    }

    public String getMacAddress() throws UnknownHostException, SocketException {
        byte[] mac;
        InetAddress localHost = InetAddress.getLocalHost();
        NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localHost);
        if (networkInterface != null && (mac = networkInterface.getHardwareAddress()) != null) {
            StringBuilder macAddress = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                macAddress.append(String.format("%02X", mac[i]));
                if (i >= mac.length - 1) continue;
                macAddress.append(":");
            }
            return macAddress.toString();
        }
        return null;
    }

    public String getExpectedLicenseKey() {
        if (HASHED_MAC == null || SHORT_MAC == null) {
            this.init();
            if (logger.isDebugEnabled()) {
                logger.debug("getExpectedLicenseKey() - Fetched hashed MAC: " + HASHED_MAC);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("getExpectedLicenseKey() - Reusing hashed MAC: " + HASHED_MAC);
        }
        return SHORT_MAC;
    }

    public boolean isDemoMode(String licenseKey) {
        return DEMO_MODE.equalsIgnoreCase(licenseKey);
    }

    protected String calculateMD5Hash(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(input.getBytes());
        StringBuilder hash = new StringBuilder();
        for (byte b : digest) {
            hash.append(String.format("%02x", b));
        }
        return hash.toString();
    }

    static {
        logger = LoggerFactory.getLogger(LicenseModel.class);
    }
}

