/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;

public class DataSetModel {
    private LocalFile localFile;
    private int numberOfRecords;
    private String localDirectory;

    public DataSetModel() {
        String defaultDirectory = Configuration.getInstance().getProperty(Property.DEFAULT_INPUT_DIR);
        String defaultFile = Configuration.getInstance().getProperty(Property.DEFAULT_INPUT_FILE);
        this.localFile = new LocalFile(defaultFile);
        this.localDirectory = defaultDirectory;
    }

    public DataSetModel(String localFile) {
        this.localFile = new LocalFile(localFile);
    }

    public DataSetModel(LocalFile localFile) {
        this.localFile = localFile;
    }

    public boolean hasLocalDirectory() {
        if (this.localDirectory == null) {
            return false;
        }
        return this.localDirectory.trim().length() > 0;
    }

    public LocalFile getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(LocalFile localFile) {
        this.localFile = localFile;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void setNumberOfRecords(int numberOfRecords) {
        this.numberOfRecords = numberOfRecords;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }
}

