/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.model;

import eu.europa.ec.jrc.qcs.gui.model.ListDataModel;
import java.awt.Color;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComboBoxUIModel<E>
extends AbstractListModel<E>
implements ComboBoxModel<E> {
    private ListDataModel<E> listDataModel;
    private ListSelectionModel listSelectionModel;
    private ListSelectionUpdater listSelectionUpdater = new ListSelectionUpdater();
    private ListModelUpdater listModelUpdater = new ListModelUpdater();
    private JComboBox<E> component;
    private String entityName;
    private static final long serialVersionUID = -4466796359532096224L;
    protected static Logger logger = LoggerFactory.getLogger(ComboBoxUIModel.class);

    public ComboBoxUIModel(ListDataModel<E> listDataModel) {
        this.setListDataModel(listDataModel);
    }

    public void setListDataModel(ListDataModel<E> listDataModel) {
        if (this.listDataModel != null) {
            this.listDataModel.removeListDataListener(this.listModelUpdater);
        }
        this.listDataModel = listDataModel;
        if (listDataModel != null) {
            this.listDataModel.addListDataListener(this.listModelUpdater);
        }
        ListSelectionModel selectionModel = listDataModel.getListSelectionModel();
        this.setListSelectionModel(selectionModel);
    }

    public void setListSelectionModel(ListSelectionModel listSelectionModel) {
        if (this.listSelectionModel != null) {
            this.listSelectionModel.removeListSelectionListener(this.listSelectionUpdater);
            if (logger.isDebugEnabled()) {
                logger.debug(this.entityName + " setListSelectionModel() - Removed listener: " + String.valueOf(this.listSelectionUpdater));
            }
        }
        this.listSelectionModel = listSelectionModel;
        if (listSelectionModel != null) {
            this.listSelectionModel.addListSelectionListener(this.listSelectionUpdater);
            if (logger.isDebugEnabled()) {
                logger.debug(this.entityName + " setListSelectionModel() - Added listener: " + String.valueOf(this.listSelectionUpdater));
            }
        }
    }

    public void reset() {
        this.listSelectionModel = new DefaultListSelectionModel();
    }

    @Override
    public E getElementAt(int index) {
        if (logger.isTraceEnabled()) {
            logger.trace(this.entityName + " getElementAt() - index : " + String.valueOf(this.listDataModel.getElementAt(index)));
        }
        return this.listDataModel.getElementAt(index);
    }

    @Override
    public int getSize() {
        if (logger.isTraceEnabled()) {
            logger.trace(this.entityName + " getElementAt() - size  : " + this.listDataModel.getSize());
        }
        return this.listDataModel.getSize();
    }

    @Override
    public void setSelectedItem(Object item) {
        if (logger.isTraceEnabled()) {
            logger.trace(this.entityName + " setSelectedItem(): listSelectionModel = " + String.valueOf(this.listSelectionModel));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.entityName + " setSelectedItem(): item = " + String.valueOf(item) + " [size = " + this.getSize() + "]");
        }
        int index = -1;
        boolean found = false;
        for (int i = 0; i < this.getSize(); ++i) {
            E elementAt = this.listDataModel.getElementAt(i);
            if (elementAt == null || !elementAt.equals(item)) continue;
            index = i;
            found = true;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.entityName + " setSelectedItem() - index = " + index);
        }
        if (found) {
            this.listSelectionModel.setSelectionInterval(index, index);
            JComboBox<E> component = this.getComponent();
            component.setBackground(Color.WHITE);
        } else {
            this.component.setBackground(Color.ORANGE);
            logger.error(this.entityName + " setSelectedItem() - Wrong selection index = " + index);
        }
    }

    @Override
    public Object getSelectedItem() {
        int minIndex = this.listSelectionModel.getMinSelectionIndex();
        if (logger.isDebugEnabled()) {
            int maxIndex = this.listSelectionModel.getMaxSelectionIndex();
            int leadIndex = this.listSelectionModel.getLeadSelectionIndex();
            int anchorIndex = this.listSelectionModel.getAnchorSelectionIndex();
            logger.debug(this.entityName + " getSelectedItem() - min=" + minIndex + " max=" + maxIndex + " lead=" + leadIndex + " anchor=" + anchorIndex);
        }
        if (minIndex < 0) {
            return null;
        }
        return this.getElementAt(minIndex);
    }

    public ListDataModel<E> getListDataModel() {
        return this.listDataModel;
    }

    public void setComponent(JComboBox<E> component) {
        this.component = component;
    }

    public JComboBox<E> getComponent() {
        return this.component;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    private class ListSelectionUpdater
    implements ListSelectionListener {
        private ListSelectionUpdater() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug(ComboBoxUIModel.this.entityName + " ListSelectionUpdater.valueChanged()");
            }
            ComboBoxUIModel.this.fireContentsChanged(this, 0, ComboBoxUIModel.this.getSize() - 1);
        }
    }

    private class ListModelUpdater
    implements ListDataListener {
        private ListModelUpdater() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug("ListModelUpdater.intervalAdded()");
            }
            ComboBoxUIModel.this.fireIntervalAdded(this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug("ListModelUpdater.intervalRemoved()");
            }
            ComboBoxUIModel.this.fireIntervalRemoved(this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug("ListModelUpdater.contentsChanged()");
            }
            ComboBoxUIModel.this.fireContentsChanged(this, e.getIndex0(), e.getIndex1());
        }
    }
}

