/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.gui.controller.GenericAction;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.MonitorException;
import eu.europa.ec.jrc.qcs.gui.controller.WorkerMonitor;
import eu.europa.ec.jrc.qcs.gui.model.MessageLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkerAction
extends GenericAction {
    private List<WorkerMonitor> monitorList = new ArrayList<WorkerMonitor>();
    protected PropertyChangeListener listener = new WorkerChangeListener();
    private static String monitorErrorMessage;
    private static final long serialVersionUID = 5106506446286919744L;
    protected static Logger logger;

    public WorkerAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    public abstract void setValues();

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public void addWorkerMonitor(WorkerMonitor view) {
        this.monitorList.add(view);
    }

    static {
        logger = LoggerFactory.getLogger(WorkerAction.class);
        StringBuilder message = new StringBuilder("<html><body>");
        message.append("<p>Error updating the progress monitor: <code>");
        message.append("%OBJ_NAME%");
        message.append("</code></p>");
        message.append("<br/>");
        message.append("<p>This is not a critical issue: execution will proceed as expected, ");
        message.append("but the application will stop notifying the process status to the user.</p>");
        message.append("<br/>");
        message.append("</body></html>");
        monitorErrorMessage = message.toString();
    }

    private class WorkerChangeListener
    implements PropertyChangeListener {
        private WorkerChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingWorker swingWorker = (SwingWorker)evt.getSource();
            String propertyName = evt.getPropertyName();
            if (logger.isDebugEnabled()) {
                logger.debug("propertyChange() - property " + propertyName.toUpperCase() + " changed: " + String.valueOf(evt.getOldValue()) + " -> " + String.valueOf(evt.getNewValue()));
            }
            Iterator<WorkerMonitor> iterator = WorkerAction.this.monitorList.iterator();
            while (iterator.hasNext()) {
                Object message = null;
                int progress = swingWorker.getProgress();
                WorkerMonitor monitor = iterator.next();
                if (WorkerAction.this.isDemo() && propertyName.equals("progress")) {
                    String label = Configuration.getInstance().getLabel(Label.WORKER_PROGRESS);
                    message = label + " " + progress;
                }
                if (propertyName.equals("message")) {
                    Object newValue = evt.getNewValue();
                    if (newValue != null && newValue instanceof List && ((List)newValue).get(0) instanceof String) {
                        String eol = "";
                        StringBuilder builder = new StringBuilder();
                        List messages = (List)newValue;
                        for (String string : messages) {
                            builder.append(eol);
                            builder.append(string);
                            eol = "\n";
                        }
                        message = builder.toString();
                    } else {
                        logger.error("Wrong event's new value - ignoring message: " + String.valueOf(newValue));
                    }
                }
                MessageLayout messageLayout = null;
                if (propertyName.equals("layout")) {
                    Object newValue = evt.getNewValue();
                    if (logger.isDebugEnabled()) {
                        logger.debug("propertyChange() - Handling message layout new value: " + String.valueOf(newValue));
                    }
                    if (newValue instanceof MessageLayout) {
                        messageLayout = (MessageLayout)newValue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("propertyChange() - Handled new message layout: " + String.valueOf(messageLayout));
                        }
                    }
                }
                try {
                    monitor.setWorkerProgress(progress);
                    if (logger.isDebugEnabled()) {
                        logger.debug("propertyChange() - Set worker progress: " + progress);
                    }
                    if (messageLayout != null) {
                        monitor.setMessageLayout(messageLayout);
                    }
                    if (message == null) continue;
                    monitor.setWorkerMessage((String)message);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("propertyChange() - Sent message to monitor: " + (String)message);
                }
                catch (MonitorException e) {
                    iterator.remove();
                    logger.error("Error updating monitor: " + String.valueOf(monitor) + " -> remove from monitors list");
                    String warning = monitorErrorMessage.replaceAll("%OBJ_NAME%", monitor.getClass().getSimpleName());
                    WorkerAction.this.notifyWarning(warning);
                }
            }
        }
    }
}

