/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.ProtocolBasedAction;
import eu.europa.ec.jrc.qcs.gui.model.DataSetModel;
import eu.europa.ec.jrc.qcs.gui.model.workers.ValidationWorker;
import eu.europa.ec.jrc.qcs.gui.view.AlertDialog;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartValidationAction
extends ProtocolBasedAction {
    private static final long serialVersionUID = -5702109733093943280L;
    protected static Logger logger = LoggerFactory.getLogger(StartValidationAction.class);

    public StartValidationAction(MainController mainController) {
        super(mainController);
        this.setDemo(false);
    }

    @Override
    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.START_CHECKS);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean showAlert;
        ValidationOptions validationOptions;
        boolean licenseAccepted;
        if (logger.isDebugEnabled()) {
            logger.debug("actionPerformed() - Checking user license");
        }
        if (!(licenseAccepted = (validationOptions = Configuration.getInstance().getValidationOptions()).checkLicenseKey())) {
            this.getMainController().getCheckLicenseAction().notifyMissingLicense();
            if (logger.isWarnEnabled()) {
                logger.warn("actionPerformed() - License not accepted. Quitting validation process now");
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("--------------------------------------------------");
            logger.info("actionPerformed() - Started new validation process");
        }
        DataSetModel dataSetModel = this.getMainController().getSelectInputAction().getDataSetModel();
        LocalFile localFile = dataSetModel.getLocalFile();
        String filePath = localFile.getAbsolutePath();
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Current input file: " + filePath);
        }
        DataSetReader dataSetReader = this.validationEngine.getDataSetReader();
        dataSetReader.setFilePath(filePath);
        ProtocolView protocolView = this.getCurrentProtocolView();
        int protocolID = protocolView.getProtocolID();
        if (logger.isInfoEnabled()) {
            String message = filePath + " (protocolID=" + protocolID + ")";
            logger.info("actionPerformed() - " + this.getObjectIdentifier(this.validationEngine) + " -> " + message);
        }
        ValidationWorker validationWorker = new ValidationWorker(this.validationEngine);
        validationWorker.setDemo(this.demo);
        this.validationEngine.setValidationWorker(validationWorker);
        validationWorker.addPropertyChangeListener(this.listener);
        validationWorker.execute();
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Started Swing worker: " + String.valueOf(validationWorker));
        }
        if (showAlert = Configuration.getInstance().getBooleanProperty(Property.GUI_INIT_ALERT)) {
            this.notifyInitialisation(validationWorker);
        } else if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - gui_init_alert is false -> showing no alert in the GUI");
        }
    }

    protected void notifyInitialisation(ValidationWorker validationWorker) {
        if (this.validationEngine.hasValidRules()) {
            if (logger.isInfoEnabled()) {
                logger.info("notifyInitialisation() - Engine has rule -> re-using protocol -> no need for notification panel");
            }
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html>Please wait, application is initializing...<br/><br/>");
        builder.append("<strong>Note</strong>: <em>to perform other checks against this protocol, just select the new file without closing the application.");
        String message = builder.toString();
        logger.warn("notifyInitialisation() - Notifying message: " + message);
        AlertDialog alert = AlertDialog.getInstance();
        if (alert != null) {
            alert.setTitle("Initialisation");
            alert.setFirstButtonMessage("OK");
            alert.setSecondButtonMessage("Stop");
            alert.setAction(2);
            alert.setMessage(message);
            alert.setWorker(validationWorker);
            alert.openPanel();
        } else {
            JOptionPane.showMessageDialog(null, message);
            logger.error("notifyInitialisation() - Failed to open notification panel");
        }
    }
}

