/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.gui.controller.GenericAction;
import eu.europa.ec.jrc.qcs.gui.model.ComboBoxUIModel;
import java.awt.event.ActionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSchemaGroupAction
extends GenericAction {
    private static final long serialVersionUID = 2636985714796751517L;
    private ComboBoxUIModel<SchemasGroup> model;
    protected static Logger logger = LoggerFactory.getLogger(SelectSchemaGroupAction.class);

    public SelectSchemaGroupAction() {
        this.setValues();
    }

    public SelectSchemaGroupAction(ComboBoxUIModel<SchemasGroup> model) {
        this.model = model;
        this.setValues();
    }

    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.SELECT_SCHEMA_GROUP);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        SchemasGroup group = (SchemasGroup)this.model.getSelectedItem();
        if (group != null) {
            if (logger.isInfoEnabled()) {
                logger.info("SelectSchemaGroupAction -> " + group.getDescription());
            }
        } else {
            logger.warn("SelectSchemaGroupAction -> null event: maybe the group was removed");
        }
    }
}

