/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.gui.controller.GenericAction;
import eu.europa.ec.jrc.qcs.gui.model.ComboBoxUIModel;
import java.awt.event.ActionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectProtocolAction
extends GenericAction {
    private static final long serialVersionUID = 621639649992663751L;
    private ComboBoxUIModel<Protocol> model;
    protected static Logger logger = LoggerFactory.getLogger(SelectProtocolAction.class);

    public SelectProtocolAction() {
        this.setValues();
    }

    public SelectProtocolAction(ComboBoxUIModel<Protocol> model) {
        this.model = model;
        this.setValues();
    }

    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.SELECT_PROTOCOL);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    public ComboBoxUIModel<Protocol> getModel() {
        return this.model;
    }

    public void setModel(ComboBoxUIModel<Protocol> model) {
        this.model = model;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Protocol protocol = (Protocol)this.model.getSelectedItem();
        if (protocol != null) {
            if (logger.isInfoEnabled()) {
                logger.info("actionPerformed(): " + protocol.getDescription());
            }
        } else {
            logger.warn("actionPerformed()() - Null event: is the protocol still supported?");
        }
    }
}

