/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerTXT;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.gui.controller.GenericAction;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.model.DataSetModel;
import eu.europa.ec.jrc.qcs.gui.view.ValidationBar;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectInputAction
extends GenericAction {
    private static final long serialVersionUID = -1806014592595137638L;
    private DataSetModel dataSetModel;
    public static final String FILE_CHOOSER_AWT = "awt";
    public static final String FILE_CHOOSER_SWING = "swing";
    protected static Logger logger = LoggerFactory.getLogger(SelectInputAction.class);

    public SelectInputAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.SELECT_FILE);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String component;
        if (logger.isDebugEnabled()) {
            logger.debug("actionPerformed() - Local directory ? " + this.dataSetModel.hasLocalDirectory() + " -> " + this.dataSetModel.getLocalDirectory());
        }
        File directory = this.dataSetModel.hasLocalDirectory() ? new File(this.dataSetModel.getLocalDirectory()) : new File(System.getProperty("user.dir"));
        try {
            directory = directory.getCanonicalFile();
        }
        catch (IOException e) {
            logger.error(" - Invalid user's directory:" + String.valueOf(directory));
        }
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Canonical path = " + String.valueOf(directory));
        }
        if (FILE_CHOOSER_AWT.equalsIgnoreCase(component = Configuration.getInstance().getProperty(Property.GUI_FILE_CHOOSER))) {
            this.openFileDialog(directory);
        } else if (FILE_CHOOSER_SWING.equalsIgnoreCase(component)) {
            this.openJFileChooser(directory);
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("actionPerformed() - Wrong file chooser option: " + component + " -> using fallback choice");
            }
            this.openJFileChooser(directory);
        }
    }

    protected void openJFileChooser(File directory) {
        LocalFile localFile = this.dataSetModel.getLocalFile();
        if (logger.isInfoEnabled()) {
            logger.info("openJFileChooser() - Opening new file chooser");
        }
        JFileChooser jfc = new JFileChooser(directory);
        jfc.setPreferredSize(new Dimension(600, 400));
        if (logger.isDebugEnabled()) {
            logger.debug("openJFileChooser() - Opened file chooser in directory: " + String.valueOf(directory));
        }
        int returnValue = jfc.showOpenDialog(null);
        if (logger.isInfoEnabled()) {
            logger.info("openJFileChooser() - Opened directory: " + String.valueOf(directory) + " (ret_val = " + returnValue + ")");
        }
        if (returnValue == 0) {
            File selectedFile = jfc.getSelectedFile();
            localFile.setFileName(selectedFile.getName());
            localFile.setAbsolutePath(selectedFile.getAbsolutePath());
            if (logger.isInfoEnabled()) {
                logger.info("actionPerformed() - Selected file: " + selectedFile.getAbsolutePath());
            }
            String newDirectory = jfc.getCurrentDirectory().getAbsolutePath();
            this.dataSetModel.setLocalDirectory(newDirectory);
            if (logger.isDebugEnabled()) {
                logger.debug("openJFileChooser() - Current directory: " + this.dataSetModel.getLocalDirectory());
            }
        }
        String filePath = localFile.getAbsolutePath();
        if (this.getView() instanceof ValidationBar) {
            ValidationBar validationBar = (ValidationBar)this.getView();
            validationBar.updateTextField(filePath);
        } else if (this.view == null) {
            logger.warn("openJFileChooser() - Input not notified to any view, since view is null: " + filePath);
        } else {
            logger.warn("openJFileChooser() - Input not notified to any view, since wrong instance: " + String.valueOf(this.view.getClass()));
        }
    }

    protected void openFileDialog(File directory) {
        Frame frame = null;
        if (this.getView() instanceof ValidationBar) {
            ValidationBar validationBar = (ValidationBar)this.getView();
            frame = validationBar.getFrame();
            if (logger.isDebugEnabled()) {
                logger.debug("openFileDialog() - ValidationBare: " + String.valueOf(validationBar));
            }
        }
        if (frame == null) {
            frame = new Frame();
            logger.error("openFileDialog() - Null fram reference -> creating new one: " + String.valueOf(frame));
        }
        FileDialog fileDialog = new FileDialog(frame, "Select file");
        fileDialog.setVisible(true);
        if (logger.isDebugEnabled()) {
            logger.debug("openFileDialog() - Selected file: " + fileDialog.getFile());
        }
        LocalFile localFile = this.dataSetModel.getLocalFile();
        Object absolutePath = fileDialog.getDirectory() + fileDialog.getFile();
        if (fileDialog.getFile() == null) {
            absolutePath = localFile.getAbsolutePath();
            if (logger.isDebugEnabled()) {
                logger.debug("openFileDialog() - Previous user selection was: " + localFile.getAbsolutePath());
            }
        }
        localFile.setAbsolutePath((String)absolutePath);
        localFile.setFileName(fileDialog.getFile());
        this.dataSetModel.setLocalDirectory(fileDialog.getDirectory());
        if (logger.isInfoEnabled()) {
            logger.info("openFileDialog() - Selected directory: " + this.dataSetModel.getLocalDirectory());
        }
        String filePath = localFile.getAbsolutePath();
        if (this.getView() instanceof ValidationBar) {
            ValidationBar validationBar = (ValidationBar)this.getView();
            validationBar.updateTextField(filePath);
        } else if (this.view == null) {
            logger.warn("openFileDialog() - Input not notified to any view, because view is null: " + filePath);
        } else {
            logger.warn("openFileDialog() - Input not notified to any view, because wrong instance: " + String.valueOf(this.view.getClass()));
        }
    }

    protected long getDataSetSize() {
        LocalFile localFile = this.dataSetModel.getLocalFile();
        String filePath = localFile.getAbsolutePath();
        FileConnection connection = new FileConnection(filePath);
        FileHandlerTXT<String> fileHandler = new FileHandlerTXT<String>(connection);
        fileHandler.setType(String.class);
        if (logger.isInfoEnabled()) {
            logger.info("getDataSetSize() - Accessing file: " + filePath);
        }
        fileHandler.readFile();
        this.dataSetModel.setNumberOfRecords(fileHandler.getCursor());
        long size = this.dataSetModel.getNumberOfRecords();
        if (logger.isInfoEnabled()) {
            logger.info("getDataSetSize() - Input file size: " + size + " lines");
        }
        return size;
    }

    public DataSetModel getDataSetModel() {
        return this.dataSetModel;
    }

    public void setDataSetModel(DataSetModel dataSetModel) {
        this.dataSetModel = dataSetModel;
    }
}

