/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.PropertiesHandler;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.ProtocolBasedAction;
import eu.europa.ec.jrc.qcs.gui.model.DataSetModel;
import java.awt.event.ActionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveOptionsAction
extends ProtocolBasedAction {
    private static final long serialVersionUID = -7401857165758086334L;
    private DataSetModel dataSetModel;
    private ValidationOptions validationOptions;
    protected static Logger logger = LoggerFactory.getLogger(SaveOptionsAction.class);

    public SaveOptionsAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    @Override
    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.SAVE);
        this.putValue("Name", name);
        this.putValue("ShortDescription", "Save current configuration on file");
        this.putValue("MnemonicKey", 83);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Saving validation options");
        }
        this.saveValidationOptions();
    }

    public void saveValidationOptions() {
        if (logger.isDebugEnabled()) {
            logger.debug("saveValidationOptions() - Saving validation options : " + String.valueOf(this.validationOptions));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("saveValidationOptions() - Saving current protocol   : " + this.getCurrentProtocolID());
            logger.debug("saveValidationOptions() - Current license's status  : " + this.validationOptions.getValue(Property.GUI_LICENSE_VALUE));
            if (this.dataSetModel != null) {
                logger.debug("saveValidationOptions() - Saving current dataset    : " + this.dataSetModel.getLocalFile().getAbsolutePath());
            } else {
                logger.debug("saveValidationOptions() - Nulla dataSetModel -> not saving the current dataset");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("saveValidationOptions() - Using dataset model       : " + String.valueOf(this.dataSetModel));
        }
        this.validationOptions.setValue(Property.DEFAULT_PROTOCOL, this.getCurrentProtocolID());
        if (this.dataSetModel != null) {
            this.validationOptions.setValue(Property.DEFAULT_INPUT_DIR, this.dataSetModel.getLocalDirectory());
            this.validationOptions.setValue(Property.DEFAULT_INPUT_FILE, this.dataSetModel.getLocalFile().getAbsolutePath());
        } else if (logger.isWarnEnabled()) {
            logger.warn("saveValidationOptions() - Null DataSetModel, some properties will not be saved: is application running in background mode?");
        }
        FileConnection connection = FlatFileDAOFactory.getConnection(FlatFile.OPTIONS);
        connection.setWriteAccess(true);
        PropertiesHandler handler = new PropertiesHandler(connection);
        handler.saveProperties(this.validationOptions.getProperties());
        if (logger.isInfoEnabled()) {
            logger.info("saveValidationOptions() - Saved validation options: " + String.valueOf(this.validationOptions));
        }
    }

    public DataSetModel getDataSetModel() {
        return this.dataSetModel;
    }

    public void setDataSetModel(DataSetModel dataSetModel) {
        this.dataSetModel = dataSetModel;
    }

    public ValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationOptions(ValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
    }
}

