/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultProtocolID;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.SelectProtocolAction;
import eu.europa.ec.jrc.qcs.gui.controller.WorkerAction;
import eu.europa.ec.jrc.qcs.gui.model.ComboBoxUIModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtocolBasedAction
extends WorkerAction {
    private static final long serialVersionUID = 8601059070293052984L;
    protected ValidationEngine validationEngine;
    protected static Logger logger = LoggerFactory.getLogger(ProtocolBasedAction.class);

    public ProtocolBasedAction(MainController mainController) {
        super(mainController);
    }

    public void setValidationEngine(ValidationEngine validationEngine) {
        this.validationEngine = validationEngine;
    }

    public ProtocolView getCurrentProtocolView() {
        int protocolID = this.getCurrentProtocolID();
        this.validationEngine.setProtocolView(protocolID);
        ProtocolView protocolView = this.validationEngine.getProtocolView();
        if (logger.isInfoEnabled()) {
            logger.info("getCurrentProtocolView() - Returning ProtocolView fetched from validation engine: " + String.valueOf(protocolView));
        }
        return protocolView;
    }

    public int getCurrentProtocolID() {
        SelectProtocolAction selectProtocolAction = this.getMainController().getSelectProtocolAction();
        if (selectProtocolAction == null) {
            int defaultProtocolID = DefaultProtocolID.INCIDENCE_2020.id;
            if (logger.isWarnEnabled()) {
                logger.warn("getCurrentProtocolID() - Null SelectProtocolAction, returning " + defaultProtocolID + ". Is application running in background mode?");
            }
            return defaultProtocolID;
        }
        ComboBoxUIModel<Protocol> protocolChoice = selectProtocolAction.getModel();
        Protocol protocol = (Protocol)protocolChoice.getSelectedItem();
        int protocolID = this.validationEngine.getProtocolID(protocol);
        if (logger.isInfoEnabled()) {
            logger.info("getCurrentProtocolID() - Returning protocolID fetched from GUI's combobox: " + protocolID);
        }
        return protocolID;
    }
}

