/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.SelectProtocolAction;
import eu.europa.ec.jrc.qcs.gui.controller.WorkerAction;
import eu.europa.ec.jrc.qcs.gui.model.ComboBoxUIModel;
import eu.europa.ec.jrc.qcs.report.ReportType;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOutputAction
extends WorkerAction {
    private static final long serialVersionUID = 8445454960429595549L;
    protected static Logger logger = LoggerFactory.getLogger(OpenOutputAction.class);

    public OpenOutputAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    @Override
    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.OPEN);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("actionPerformed() - Started by event: " + String.valueOf(event));
        }
        String targetFolder = "incidence";
        SelectProtocolAction selectProtocolAction = this.mainController.getSelectProtocolAction();
        ComboBoxUIModel<Protocol> selectProtocolModel = selectProtocolAction.getModel();
        Object selectedProtocolRaw = selectProtocolModel.getSelectedItem();
        if (logger.isDebugEnabled()) {
            String selectedClass = selectedProtocolRaw != null ? selectedProtocolRaw.getClass().getName() : "null";
            logger.debug("actionPerformed() - Selected protocol: " + String.valueOf(selectedProtocolRaw) + " [" + selectedClass + "]");
        }
        if (selectedProtocolRaw instanceof Protocol) {
            Protocol selectedProtocol = (Protocol)selectedProtocolRaw;
            if (logger.isDebugEnabled()) {
                logger.debug("actionPerformed() - Selected protocol: " + String.valueOf(selectedProtocol));
            }
            if (selectedProtocol.getSchema() != null) {
                int reportTypeId = selectedProtocol.getSchema().getReportID();
                ReportType reportType = ReportType.getByID(reportTypeId);
                if (reportType != null) {
                    targetFolder = reportType.folder;
                    if (logger.isInfoEnabled()) {
                        logger.info("actionPerformed() - ReportTypeId: " + reportTypeId + " -> output folder = \"" + targetFolder + "\"");
                    }
                } else {
                    logger.warn("actionPerformed() - Unknown ReportType for id {}", (Object)reportTypeId);
                }
            } else {
                logger.warn("actionPerformed() - Selected protocol has null schema");
            }
        }
        this.showOutputFilesMenu(event, targetFolder);
    }

    private void showOutputFilesMenu(ActionEvent event, String targetFolder) {
        try {
            String basePath = System.getProperty("user.dir");
            String outputPath = basePath + File.separator + "output" + File.separator + targetFolder;
            File targetDirectory = new File(outputPath);
            if (logger.isDebugEnabled()) {
                logger.debug("showOutputFilesMenu() - Target directory: " + targetDirectory.getAbsolutePath());
            }
            if (!targetDirectory.exists()) {
                logger.warn("showOutputFilesMenu() - Output directory does not exist: " + targetDirectory.getAbsolutePath());
                this.showErrorDialog("Output directory does not exist:\n" + targetDirectory.getAbsolutePath() + "\n\nPlease run validation first.");
                return;
            }
            Object[] files = targetDirectory.listFiles((dir, name) -> {
                String lowerName = name.toLowerCase();
                return lowerName.endsWith(".csv") || lowerName.endsWith(".txt") || lowerName.endsWith(".pdf");
            });
            if (files == null || files.length == 0) {
                logger.warn("showOutputFilesMenu() - No output files found in: " + targetDirectory.getAbsolutePath());
                this.showErrorDialog("No output files found in directory:\n" + targetDirectory.getAbsolutePath() + "\n\nPlease run validation first.");
                return;
            }
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(new Color(200, 200, 200), 1)));
            Arrays.sort(files);
            for (Object file : files) {
                String fileName = ((File)file).getName();
                JMenuItem menuItem = new JMenuItem(fileName);
                menuItem.addActionListener(arg_0 -> this.lambda$showOutputFilesMenu$1((File)file, fileName, arg_0));
                popupMenu.add(menuItem);
            }
            if (event.getSource() instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)event.getSource();
                this.showPopupMenuNearButton(popupMenu, button);
            }
        }
        catch (Exception exception) {
            logger.error("showOutputFilesMenu() - Failed to create output files menu: " + exception.getMessage(), (Throwable)exception);
            this.showErrorDialog("Failed to access output directory.\n");
        }
    }

    private void showPopupMenuNearButton(JPopupMenu popupMenu, AbstractButton button) {
        Window window = SwingUtilities.getWindowAncestor(button);
        if (window == null) {
            popupMenu.show(button, 0, button.getHeight());
            return;
        }
        Dimension popupSize = popupMenu.getPreferredSize();
        Point buttonOnScreen = button.getLocationOnScreen();
        Point windowOnScreen = window.getLocationOnScreen();
        Insets insets = window instanceof Frame ? ((Frame)window).getInsets() : (window instanceof Dialog ? ((Dialog)window).getInsets() : new Insets(0, 0, 0, 0));
        int margin = 4;
        int contentLeft = windowOnScreen.x + insets.left + margin;
        int contentTop = windowOnScreen.y + insets.top + margin;
        int contentWidth = Math.max(0, window.getWidth() - insets.left - insets.right - 2 * margin);
        int contentHeight = Math.max(0, window.getHeight() - insets.top - insets.bottom - 2 * margin);
        int contentRight = contentLeft + contentWidth;
        int contentBottom = contentTop + contentHeight;
        int desiredX = buttonOnScreen.x;
        int desiredY = buttonOnScreen.y + button.getHeight();
        int clampedX = desiredX;
        if (clampedX < contentLeft) {
            clampedX = contentLeft;
        } else if (clampedX + popupSize.width > contentRight) {
            clampedX = contentRight - popupSize.width;
        }
        int clampedY = desiredY;
        if (clampedY + popupSize.height > contentBottom && (clampedY = buttonOnScreen.y - popupSize.height) < contentTop) {
            clampedY = contentTop;
        }
        int finalX = clampedX - buttonOnScreen.x;
        int finalY = clampedY - buttonOnScreen.y;
        popupMenu.show(button, finalX, finalY);
    }

    private void showErrorDialog(String message) {
        try {
            if (this.mainController != null && this.mainController.getMainView() != null) {
                JOptionPane.showMessageDialog(this.mainController.getMainView().getWindowAncestor(), message, "Error", 0);
            } else {
                JOptionPane.showMessageDialog(null, message, "Error", 0);
            }
        }
        catch (Exception e) {
            logger.error("Failed to show error dialog: " + e.getMessage());
        }
    }

    private /* synthetic */ void lambda$showOutputFilesMenu$1(File file, String fileName, ActionEvent e) {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("showOutputFilesMenu() - Opening file: " + file.getAbsolutePath());
            }
            if (!Desktop.isDesktopSupported()) {
                this.showErrorDialog("Cannot open file: Desktop integration is not supported on this system.");
                return;
            }
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.OPEN)) {
                this.showErrorDialog("Cannot open file: Desktop open action is not supported.");
                return;
            }
            desktop.open(file);
        }
        catch (Exception ex) {
            logger.error("showOutputFilesMenu() - Failed to open file: " + file.getAbsolutePath() + " - " + ex.getMessage(), (Throwable)ex);
            this.showErrorDialog("Failed to open file:\n" + fileName + "\n");
        }
    }
}

