/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.gui.controller.GenericAction;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.model.OptionModel;
import eu.europa.ec.jrc.qcs.gui.model.OptionsDataModel;
import eu.europa.ec.jrc.qcs.gui.view.MainView;
import eu.europa.ec.jrc.qcs.gui.view.OptionPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOptionsAction
extends GenericAction {
    private static final long serialVersionUID = -2110730728941709024L;
    private ValidationOptions validationOptions;
    private OptionPanel optionPanel;
    private OptionsDataModel optionsDataModel;
    protected static Logger logger = LoggerFactory.getLogger(OpenOptionsAction.class);

    public OpenOptionsAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.OPTIONS);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.putValue("MnemonicKey", 79);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug("actionPerformed() - Opening options pane with model: " + String.valueOf(this.validationOptions));
        }
        MainView mainView = this.getMainController().getMainView();
        JFrame parent = mainView.getWindowAncestor();
        if (this.optionPanel == null) {
            this.initOptionPanel(parent);
            this.optionPanel.openPanel(parent);
        } else {
            this.optionPanel.setVisible(true);
        }
    }

    protected void initOptionPanel(JFrame parent) {
        if (logger.isInfoEnabled()) {
            logger.info("initOptionPanel() - Creating brand new OptionPanel");
        }
        Property[] checkBoxProperties = new Property[]{Property.REPORTS_DETAILED, Property.MANDATORY_FLAG_1, Property.MPMT_ALGORITHM};
        LinkedHashMap<Property, OptionModel<Boolean>> checkBoxes = new LinkedHashMap<Property, OptionModel<Boolean>>();
        for (Property property : checkBoxProperties) {
            String label = this.getCheckBoxLabel(property);
            boolean value = this.validationOptions.getBooleanValue(property);
            OptionModel<Boolean> optionModel = new OptionModel<Boolean>(property, value);
            optionModel.setLabel(label);
            checkBoxes.put(property, optionModel);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("initOptionPanel() - Check-Box property {} = {}", (Object)property, (Object)value);
        }
        Property[] radioButtonProperties = new Property[]{Property.MPMT_CRITERION, Property.STRIP_CRITERION};
        HashMap<Property, OptionModel<Integer>> radioButtons = new HashMap<Property, OptionModel<Integer>>();
        for (Property property : radioButtonProperties) {
            Map<Integer, String> labels = this.getRadioButtonsLabels(property);
            int value = this.validationOptions.getIntegerValue(property);
            OptionModel<Integer> optionModel = new OptionModel<Integer>(property, value);
            optionModel.setOptionsLabels(labels);
            radioButtons.put(property, optionModel);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("initOptionPanel() - Radio-Button key " + String.valueOf((Object)property) + " = " + value);
        }
        this.optionsDataModel = new OptionsDataModel(checkBoxes, radioButtons);
        this.optionPanel = new OptionPanel(this.optionsDataModel);
        this.optionPanel.setValidationOptionsListener(new ValidationOptionsListener());
    }

    private String getCheckBoxLabel(Property property) {
        switch (property) {
            case MPMT_ALGORITHM: {
                return "Enable the MPMT Algorithm (JRC only)";
            }
            case REPORTS_DETAILED: {
                return "Enable detailed output report";
            }
            case MANDATORY_FLAG_1: {
                return "Enable checks of follow-up variables";
            }
        }
        return property.description;
    }

    private Map<Integer, String> getRadioButtonsLabels(Property property) {
        HashMap<Integer, String> pmAcceptanceCriteria = new HashMap<Integer, String>();
        pmAcceptanceCriteria.put(2, "Primary Duplicate Check All Records");
        pmAcceptanceCriteria.put(3, "Primary Duplicate Check Valid Records");
        HashMap<Integer, String> stripQuotesCriteria = new HashMap<Integer, String>();
        stripQuotesCriteria.put(0, "Do not remove quotes from the dataset");
        stripQuotesCriteria.put(1, "Remove all quotes from the dataset");
        switch (property) {
            case MPMT_CRITERION: {
                return pmAcceptanceCriteria;
            }
            case STRIP_CRITERION: {
                return stripQuotesCriteria;
            }
        }
        logger.error("getRadioButtonsLabels() - Wrong input property: " + String.valueOf((Object)property) + " (" + property.key + ")");
        return null;
    }

    public ValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationOptions(ValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
    }

    private class ValidationOptionsListener
    implements ActionListener {
        private ValidationOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractButton source = (AbstractButton)event.getSource();
            String actionCommand = source.getActionCommand();
            if (logger.isDebugEnabled()) {
                logger.debug("actionPerformed() - Event's action command : " + actionCommand);
            }
            String propertyKey = null;
            String propertyValue = null;
            if (actionCommand.contains("=")) {
                String[] tokens = actionCommand.split("=");
                propertyKey = tokens[0];
                propertyValue = tokens[1];
                if (logger.isTraceEnabled()) {
                    logger.trace("actionPerformed() - Parsed property's key  : " + propertyKey);
                }
            } else {
                propertyKey = actionCommand;
            }
            Property property = Property.getProperty(propertyKey);
            boolean selected = source.getModel().isSelected();
            if (logger.isDebugEnabled()) {
                logger.debug("actionPerformed() - Event's source         : " + String.valueOf((Object)property) + " (" + propertyKey + ") -> " + selected);
            }
            if (source instanceof JCheckBox) {
                OpenOptionsAction.this.validationOptions.setValue(property, selected);
                if (logger.isInfoEnabled()) {
                    logger.info("actionPerformed() - Updated check-box      : " + String.valueOf((Object)property) + " (" + source.getName() + ") -> " + selected);
                }
            } else {
                int value = Integer.parseInt(propertyValue);
                OpenOptionsAction.this.validationOptions.setValue(property, value);
                if (logger.isInfoEnabled()) {
                    logger.info("actionPerformed() - Updated buttons-group  : " + String.valueOf((Object)property) + " (" + source.getName() + ") -> " + propertyValue);
                }
            }
        }
    }
}

