/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.gui.controller.GenericAction;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.view.AboutPanel;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAboutAction
extends GenericAction {
    private static final long serialVersionUID = 862695090186958303L;
    protected static Logger logger = LoggerFactory.getLogger(OpenAboutAction.class);

    public OpenAboutAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.ABOUT);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.putValue("MnemonicKey", 65);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFrame parent = this.getParentFrame();
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Opening about panel from parent frame: " + String.valueOf(parent));
        }
        AboutPanel panel = new AboutPanel(parent);
        SwingUtilities.invokeLater(panel);
    }
}

