/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.gui.controller.BrowseProtocolAction;
import eu.europa.ec.jrc.qcs.gui.controller.CheckIntegrityAction;
import eu.europa.ec.jrc.qcs.gui.controller.CheckLicenseAction;
import eu.europa.ec.jrc.qcs.gui.controller.CheckSchemaAction;
import eu.europa.ec.jrc.qcs.gui.controller.CleanMonitorAction;
import eu.europa.ec.jrc.qcs.gui.controller.ExitAction;
import eu.europa.ec.jrc.qcs.gui.controller.LoadProtocolAction;
import eu.europa.ec.jrc.qcs.gui.controller.OpenAboutAction;
import eu.europa.ec.jrc.qcs.gui.controller.OpenHelpAction;
import eu.europa.ec.jrc.qcs.gui.controller.OpenOptionsAction;
import eu.europa.ec.jrc.qcs.gui.controller.OpenOutputAction;
import eu.europa.ec.jrc.qcs.gui.controller.SaveOptionsAction;
import eu.europa.ec.jrc.qcs.gui.controller.SelectInputAction;
import eu.europa.ec.jrc.qcs.gui.controller.SelectProtocolAction;
import eu.europa.ec.jrc.qcs.gui.controller.SelectSchemaGroupAction;
import eu.europa.ec.jrc.qcs.gui.controller.StartValidationAction;
import eu.europa.ec.jrc.qcs.gui.controller.ValidationWorkerMonitor;
import eu.europa.ec.jrc.qcs.gui.model.ComboBoxUIModel;
import eu.europa.ec.jrc.qcs.gui.model.DataSetModel;
import eu.europa.ec.jrc.qcs.gui.model.MonitorModel;
import eu.europa.ec.jrc.qcs.gui.view.GenericView;
import eu.europa.ec.jrc.qcs.gui.view.MainView;
import eu.europa.ec.jrc.qcs.gui.view.action.GeneralActions;
import eu.europa.ec.jrc.qcs.gui.view.action.ValidationActions;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainController {
    private MainView mainView;
    private ExitAction exitAction;
    private SaveOptionsAction saveOptionsAction;
    private AbstractAction helpAction;
    private AbstractAction aboutAction;
    private AbstractAction cleanMonitorAction;
    private AbstractAction selectSchemaGroupAction;
    private SelectProtocolAction selectProtocolAction;
    private StartValidationAction startValidationAction;
    private SelectInputAction selectInputAction;
    private SelectInputAction alternateSelectInputAction;
    private AbstractAction openOutputAction;
    private CheckIntegrityAction checkIntegrityAction;
    private CheckSchemaAction checkSchemaAction;
    private LoadProtocolAction loadProtocolAction;
    private BrowseProtocolAction browseProtocolAction;
    private OpenOptionsAction openOptionsAction;
    private CheckLicenseAction checkLicenseAction;
    protected static Logger logger = LoggerFactory.getLogger(MainController.class);

    public MainController(MainView view) {
        this.mainView = view;
        if (this.mainView != null) {
            this.mainView.setController(this);
        }
        ValidationOptions options = new ValidationOptions(null);
        options.addPropertyChangeListener(new ModelListener());
        options.doSomething();
        this.saveOptionsAction = new SaveOptionsAction(this);
        this.exitAction = new ExitAction(this);
        this.helpAction = new OpenHelpAction(this);
        this.aboutAction = new OpenAboutAction(this);
        this.startValidationAction = new StartValidationAction(this);
        this.checkIntegrityAction = new CheckIntegrityAction(this);
        this.checkSchemaAction = new CheckSchemaAction(this);
        this.selectInputAction = new SelectInputAction(this);
        this.openOutputAction = new OpenOutputAction(this);
        this.openOptionsAction = new OpenOptionsAction(this);
        this.loadProtocolAction = new LoadProtocolAction(this);
        this.browseProtocolAction = new BrowseProtocolAction(this);
        this.alternateSelectInputAction = new SelectInputAction(this);
        String alternateSelectInputName = Configuration.getInstance().getLabel(Label.OPEN_FILE);
        this.alternateSelectInputAction.putValue("Name", alternateSelectInputName);
        this.alternateSelectInputAction.putValue("MnemonicKey", 79);
        this.exitAction.setMainView(view);
        this.checkLicenseAction = new CheckLicenseAction(this);
        if (logger.isDebugEnabled()) {
            logger.debug("Created main controller");
        }
    }

    public void setGeneralActions(GeneralActions view) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding mainView: " + view.getClass().getName());
        }
        view.setSelectInputAction(this.alternateSelectInputAction);
        view.setSaveOptionsAction(this.saveOptionsAction);
        view.setExitAction(this.exitAction);
        view.setCleanMonitor(this.cleanMonitorAction);
        view.setOptionsAction(this.openOptionsAction);
        view.setAboutAction(this.aboutAction);
        view.setHelpAction(this.helpAction);
        view.setCheckSchemaAction(this.checkSchemaAction);
        view.setCheckAllSchemasAction(this.checkIntegrityAction);
        view.setLoadProtocolAction(this.loadProtocolAction);
        view.setBrowseProtocolAction(this.browseProtocolAction);
    }

    public void setValidationActions(ValidationActions view) {
        if (logger.isDebugEnabled()) {
            logger.debug("setValidationActions() - Adding mainView: " + view.getClass().getName());
        }
        view.setSelectProtocolAction(this.selectProtocolAction);
        view.setSelectInputAction(this.selectInputAction);
        view.setValidateAction(this.startValidationAction);
        view.setOpenOutputAction(this.openOutputAction);
        view.setSelectSchemaGroupAction(this.selectSchemaGroupAction);
        GenericView validationActions = (GenericView)((Object)view);
        this.alternateSelectInputAction.setView(validationActions);
    }

    public void addValidationMonitor(ValidationWorkerMonitor monitor) {
        this.startValidationAction.addWorkerMonitor(monitor);
    }

    public void addCheckIntegrityMonitor(ValidationWorkerMonitor monitor) {
        this.checkSchemaAction.addWorkerMonitor(monitor);
        this.checkIntegrityAction.addWorkerMonitor(monitor);
    }

    public void setSchemaGroupUIModel(ComboBoxUIModel<SchemasGroup> comboBoxUIModel) {
        this.selectSchemaGroupAction = new SelectSchemaGroupAction(comboBoxUIModel);
    }

    public void setProtocolUIModel(ComboBoxUIModel<Protocol> comboBoxUIModel) {
        this.selectProtocolAction = new SelectProtocolAction(comboBoxUIModel);
    }

    public void setMonitorModel(MonitorModel monitorModel) {
        this.cleanMonitorAction = new CleanMonitorAction(monitorModel);
    }

    public void setDataSetModel(DataSetModel dataSetModel) {
        this.selectInputAction.setDataSetModel(dataSetModel);
        this.alternateSelectInputAction.setDataSetModel(dataSetModel);
        this.saveOptionsAction.setDataSetModel(dataSetModel);
    }

    public void setOptionsModel(ValidationOptions validationOptions) {
        this.saveOptionsAction.setValidationOptions(validationOptions);
        this.openOptionsAction.setValidationOptions(validationOptions);
    }

    public void setEngineModel(ValidationEngine validationEngine) {
        this.startValidationAction.setValidationEngine(validationEngine);
        this.checkSchemaAction.setValidationEngine(validationEngine);
        this.loadProtocolAction.setValidationEngine(validationEngine);
        this.browseProtocolAction.setValidationEngine(validationEngine);
        this.saveOptionsAction.setValidationEngine(validationEngine);
        if (logger.isInfoEnabled()) {
            logger.info("setEngineModel() - Set ValidationEngine: " + String.valueOf(validationEngine));
        }
    }

    public void setWaitCursor() {
        JFrame jFrame = this.mainView.getWindowAncestor();
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor() {
        JFrame jFrame = this.mainView.getWindowAncestor();
        jFrame.setCursor(Cursor.getDefaultCursor());
    }

    public MainView getMainView() {
        return this.mainView;
    }

    public void setMainView(MainView mainView) {
        this.mainView = mainView;
    }

    public AbstractAction getSelectSchemaGroupAction() {
        return this.selectSchemaGroupAction;
    }

    public void setSelectSchemaGroupAction(AbstractAction selectSchemaGroupAction) {
        this.selectSchemaGroupAction = selectSchemaGroupAction;
    }

    public SelectInputAction getSelectInputAction() {
        return this.selectInputAction;
    }

    public void setSelectInputAction(SelectInputAction selectInputAction) {
        this.selectInputAction = selectInputAction;
    }

    public ExitAction getExitAction() {
        return this.exitAction;
    }

    public void setExitAction(ExitAction exitAction) {
        this.exitAction = exitAction;
    }

    public OpenOptionsAction getOpenOptionsAction() {
        return this.openOptionsAction;
    }

    public void setOpenOptionsAction(OpenOptionsAction openOptionsAction) {
        this.openOptionsAction = openOptionsAction;
    }

    public AbstractAction getCheckSchemaAction() {
        return this.checkSchemaAction;
    }

    public void setCheckSchemaAction(CheckSchemaAction checkSchemaAction) {
        this.checkSchemaAction = checkSchemaAction;
    }

    public CheckIntegrityAction getCheckIntegrityAction() {
        return this.checkIntegrityAction;
    }

    public void setCheckIntegrityAction(CheckIntegrityAction checkIntegrityAction) {
        this.checkIntegrityAction = checkIntegrityAction;
    }

    public AbstractAction getAboutAction() {
        return this.aboutAction;
    }

    public void setAboutAction(AbstractAction aboutAction) {
        this.aboutAction = aboutAction;
    }

    public AbstractAction getHelpAction() {
        return this.helpAction;
    }

    public void setHelpAction(AbstractAction helpAction) {
        this.helpAction = helpAction;
    }

    public SelectProtocolAction getSelectProtocolAction() {
        return this.selectProtocolAction;
    }

    public void setSelectProtocolAction(SelectProtocolAction selectProtocolAction) {
        this.selectProtocolAction = selectProtocolAction;
    }

    public AbstractAction getOpenOutputAction() {
        return this.openOutputAction;
    }

    public void setOpenOutputAction(OpenOutputAction openOutputAction) {
        this.openOutputAction = openOutputAction;
    }

    public AbstractAction getCleanMonitorAction() {
        return this.cleanMonitorAction;
    }

    public void setCleanMonitorAction(AbstractAction cleanMonitorAction) {
        this.cleanMonitorAction = cleanMonitorAction;
    }

    public SaveOptionsAction getSaveOptionsAction() {
        return this.saveOptionsAction;
    }

    public void setSaveOptionsAction(SaveOptionsAction saveOptionsAction) {
        this.saveOptionsAction = saveOptionsAction;
    }

    public SelectInputAction getAlternateSelectInputAction() {
        return this.alternateSelectInputAction;
    }

    public void setAlternateSelectInputAction(SelectInputAction alternateSelectInputAction) {
        this.alternateSelectInputAction = alternateSelectInputAction;
    }

    public LoadProtocolAction getLoadProtocolAction() {
        return this.loadProtocolAction;
    }

    public void setLoadProtocolAction(LoadProtocolAction loadProtocolAction) {
        this.loadProtocolAction = loadProtocolAction;
    }

    public BrowseProtocolAction getBrowseProtocolAction() {
        return this.browseProtocolAction;
    }

    public void setBrowseProtocolAction(BrowseProtocolAction browseProtocolAction) {
        this.browseProtocolAction = browseProtocolAction;
    }

    public StartValidationAction getStartValidationAction() {
        return this.startValidationAction;
    }

    public void setStartValidationAction(StartValidationAction startValidationAction) {
        this.startValidationAction = startValidationAction;
    }

    public void setOpenOutputAction(AbstractAction openOutputAction) {
        this.openOutputAction = openOutputAction;
    }

    public CheckLicenseAction getCheckLicenseAction() {
        return this.checkLicenseAction;
    }

    public void setCheckLicenseAction(CheckLicenseAction checkLicenseAction) {
        this.checkLicenseAction = checkLicenseAction;
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String changedProp = event.getPropertyName();
            if (logger.isInfoEnabled()) {
                logger.info("propertyChange() - Received property change event: " + changedProp);
            }
            if ("OPTIONS".equals(changedProp)) {
                logger.info("propertyChange() - !!! OPTIONS !!!");
            }
        }
    }
}

