/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.ValidationCycle;
import eu.europa.ec.jrc.qcs.engine.ValidationLevel;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.ProtocolBasedAction;
import eu.europa.ec.jrc.qcs.gui.model.TableDataModel;
import eu.europa.ec.jrc.qcs.gui.view.TablePanel;
import eu.europa.ec.jrc.qcs.gui.view.style.GroupColor;
import eu.europa.ec.jrc.qcs.gui.view.style.RowIndexCellRenderer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadProtocolAction
extends ProtocolBasedAction {
    private static final long serialVersionUID = -6200703991947610609L;
    HashMap<Integer, GroupColor> colorMap = new HashMap();
    GroupColor preRecordCycle = new GroupColor(new Color(0, 0, 150), Color.WHITE);
    GroupColor postRecordCycle = new GroupColor(new Color(0, 0, 150), Color.WHITE);
    protected static Logger logger = LoggerFactory.getLogger(LoadProtocolAction.class);

    public LoadProtocolAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    @Override
    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.LOAD_PROTOCOL);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.putValue("MnemonicKey", 76);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ProtocolView protocolView = this.getCurrentProtocolView();
        int protocolID = protocolView.getProtocolID();
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Opening protocol table: " + protocolID);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadProtocolAction.this.getMainController().setWaitCursor();
                TableDataModel tableDataModel = LoadProtocolAction.this.getTableDataModel(protocolView);
                TablePanel tablePanel = new TablePanel(tableDataModel);
                tablePanel.setTemplate(3);
                LoadProtocolAction.this.applyColourMap(tablePanel);
                tablePanel.openTable();
                tablePanel.centre();
                LoadProtocolAction.this.getMainController().setDefaultCursor();
            }
        });
    }

    protected TableDataModel getTableDataModel(ProtocolView protocolView) {
        TableDataModel tableDataModel = new TableDataModel();
        Object[] header = new String[]{"NICE", "NAME", "CLASS", "RID", "CODE", "SID", "TYPE (LEVEL)", "SCOPE", "CASE", "TARGET", "CYCLE", "BLOCKING"};
        tableDataModel.setHeader(header);
        this.validationEngine.hardReset();
        List<AbstractRule> rules = this.validationEngine.loadAllRules();
        int counter = 0;
        int numberOfRules = rules.size();
        Object[][] rows = new Object[numberOfRules][header.length];
        String name = protocolView.getName();
        tableDataModel.setTitle("Loaded protocol " + name + ": " + numberOfRules + " rules (including function rules)");
        if (logger.isInfoEnabled()) {
            logger.info("getTableDataModel() - Creating protocol table with " + numberOfRules + " rules");
        }
        for (AbstractRule rule : rules) {
            int schemaID;
            SchemaView schema;
            RuleConfiguration cfg = rule.getRuleConfiguration();
            ValidationLevel validationLevel = cfg.getValidationLevel();
            ValidationCycle cycle = validationLevel.cycle;
            switch (cycle) {
                case PRE_RECORD: {
                    this.colorMap.put(counter, this.preRecordCycle);
                    break;
                }
                case POST_RECORD: {
                    this.colorMap.put(counter, this.postRecordCycle);
                    break;
                }
            }
            String ruleName = rule.getModelName();
            String ruleClass = rule.getClass().getSimpleName();
            String errorCode = cfg.getValidationMessage().getCode();
            if (errorCode == null) {
                errorCode = "";
            }
            schemaID = (schema = cfg.getTargetSchemaView()) != null ? (schemaID = schema.getId()) : 0;
            RuleType type = cfg.getRuleType();
            String typeAndLevel = String.valueOf((Object)type) + " (" + type.validationLevel.level + ")";
            rows[counter++] = new Object[]{cfg.getPriority(), ruleName, ruleClass, rule.getId(), errorCode, schemaID, typeAndLevel, cfg.getRuleScope().toString().toLowerCase(), cfg.getCaseSensitivity().symbol, cfg.getRuleTarget(), cycle, cfg.isBlocking() ? "blocking" : ""};
            if (!logger.isDebugEnabled()) continue;
            logger.debug("getTableDataModel() - Added row: " + counter);
        }
        tableDataModel.setData(rows);
        return tableDataModel;
    }

    protected void applyColourMap(TablePanel tablePanel) {
        RowIndexCellRenderer renderer = new RowIndexCellRenderer(new Color(0, 0, 70), Color.WHITE);
        renderer.setRowsColorMap(this.colorMap);
        tablePanel.setTableCellRenderer(renderer);
    }
}

