/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.view.AlertDialog;
import eu.europa.ec.jrc.qcs.gui.view.GenericView;
import eu.europa.ec.jrc.qcs.gui.view.MainFrame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericAction
extends AbstractAction {
    protected MainController mainController;
    protected GenericView view;
    protected boolean demo;
    protected static final String OBJECT_NAME = "%OBJ_NAME%";
    private static final long serialVersionUID = 5308917280039750917L;
    protected static Logger logger = LoggerFactory.getLogger(GenericAction.class);

    public GenericAction() {
    }

    public GenericAction(MainController mainController) {
        this.mainController = mainController;
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public void notifyWarning(String message) {
        AlertDialog alert = AlertDialog.getInstance();
        alert.setTitle("Warning");
        alert.setFirstButtonMessage("OK");
        alert.setAction(0);
        alert.setMessage(message);
        alert.openPanel();
    }

    public JFrame getParentFrame() {
        JFrame parent = null;
        MainFrame mainFrame = null;
        if (this.getMainController() == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("GenericAction() - Returning null parent frame. Is application running without a GUI?");
            }
            return null;
        }
        mainFrame = this.getMainController().getMainView().getMainFrame();
        if (mainFrame instanceof JFrame) {
            parent = (JFrame)((Object)mainFrame);
        }
        return parent;
    }

    public GenericView getView() {
        return this.view;
    }

    public void setView(GenericView view) {
        this.view = view;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean demo) {
        this.demo = demo;
    }

    protected String getObjectIdentifier(Object object) {
        if (object == null) {
            return "NULL_OBJECT";
        }
        String[] fullName = object.toString().split("@");
        String hash = fullName[fullName.length - 1];
        String objectIdentifier = object.getClass().getSimpleName() + "@" + hash;
        return objectIdentifier;
    }
}

