/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.gui.controller.GenericAction;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.SaveOptionsAction;
import eu.europa.ec.jrc.qcs.gui.view.MainFrame;
import eu.europa.ec.jrc.qcs.gui.view.MainView;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExitAction
extends GenericAction {
    private static final long serialVersionUID = 2612480765966223552L;
    protected static Logger logger = LoggerFactory.getLogger(ExitAction.class);

    public ExitAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.EXIT);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.putValue("MnemonicKey", 69);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Closing application (from menu bar)");
        }
        this.handleExitEvent();
    }

    public void handleExitEvent() {
        if (logger.isInfoEnabled()) {
            logger.info("handleExitEvent() - Handling exit operations");
        }
        SaveOptionsAction saveOptionsAction = this.getMainController().getSaveOptionsAction();
        saveOptionsAction.saveValidationOptions();
        System.exit(0);
    }

    public void setMainView(MainView view) {
        if (view == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("setMainView() - Running vithout a view: is application running in background?");
            }
            return;
        }
        MainFrame mainFrame = view.getMainFrame();
        if (mainFrame instanceof Window) {
            Window window = (Window)((Object)mainFrame);
            window.addWindowListener(new ClosingListener());
        } else if (logger.isWarnEnabled()) {
            logger.warn("setMainView() - Wrong view instance: " + String.valueOf(view.getClass()));
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (logger.isInfoEnabled()) {
                logger.info("windowClosing() - Main window closed (from native operation)");
            }
            ExitAction.this.handleExitEvent();
        }
    }
}

