/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.ProtocolBasedAction;
import eu.europa.ec.jrc.qcs.gui.model.workers.CheckIntegrityWorker;
import java.awt.event.ActionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSchemaAction
extends ProtocolBasedAction {
    private static final long serialVersionUID = 3113321353237851567L;
    protected static Logger logger = LoggerFactory.getLogger(CheckSchemaAction.class);

    public CheckSchemaAction(MainController mainController) {
        super(mainController);
    }

    @Override
    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.CHECK_SCHEMA);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.putValue("MnemonicKey", 83);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CheckIntegrityWorker checkIntegrityWorker = new CheckIntegrityWorker(null);
        ProtocolView protocolView = this.getCurrentProtocolView();
        int schemaID = protocolView.getSchemaID();
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Checking current schema: " + schemaID);
        }
        checkIntegrityWorker.setSchemaID(schemaID);
        checkIntegrityWorker.addPropertyChangeListener(this.listener);
        checkIntegrityWorker.execute();
    }
}

