/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.WorkerAction;
import eu.europa.ec.jrc.qcs.gui.model.LicenseModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckLicenseAction
extends WorkerAction {
    private static final long serialVersionUID = -7013754168438492032L;
    ValidationOptions validationOptions;
    LicenseModel licenseModel;
    protected static Logger logger = LoggerFactory.getLogger(CheckLicenseAction.class);

    public CheckLicenseAction() {
        super((MainController)null);
        this.setValues();
    }

    public CheckLicenseAction(MainController mainController) {
        super(mainController);
        this.setValues();
        if (logger.isDebugEnabled()) {
            logger.debug("Constructor() - Set reference to main controller: " + String.valueOf(this.mainController));
        }
    }

    @Override
    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.CHECK_LICENSE);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.putValue("MnemonicKey", 112);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Showing application license");
        }
        this.validationOptions = Configuration.getInstance().getValidationOptions();
        this.licenseModel = this.validationOptions.getLicenseModel();
        String licenseText = this.licenseModel.getLicenseText();
        JTextArea textArea = new JTextArea(30, 50);
        textArea.setText(licenseText);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textArea);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        boolean accepted = this.licenseModel.checkLicenseKey();
        String buttonText = accepted ? "Close" : "Accept";
        String labelText = "<html><div style='margin-right:50px; font-style:italic;'>I have read and understood the above license terms and I agree with them</div></html>";
        JButton acceptButton = new JButton(buttonText);
        JButton declineButton = new JButton("Decline");
        acceptButton.addActionListener(new AcceptButtonListener());
        declineButton.addActionListener(new DeclineButtonListener());
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BorderLayout());
        buttonsPanel.add((Component)new JLabel(labelText), "West");
        buttonsPanel.add((Component)acceptButton, "Center");
        buttonsPanel.add((Component)declineButton, "East");
        Object tagLine = accepted ? buttonText : buttonsPanel;
        JFrame frame = this.getParentFrame();
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Using parent frame: " + String.valueOf(frame));
        }
        int result = JOptionPane.showOptionDialog(frame, mainPanel, "License", -1, -1, null, new Object[]{tagLine}, null);
        if (logger.isDebugEnabled()) {
            logger.info("actionPerformed() - JOptionPane's result: " + result);
        }
    }

    public void notifyMissingLicense() {
        JFrame parent = this.getParentFrame();
        if (logger.isDebugEnabled()) {
            logger.debug("notifyMissingLicense() - Using parent frame: " + String.valueOf(parent));
        }
        Object message = "\nThis is a friendly reminder about the software license.\n\n";
        message = (String)message + "The license allowing to use this application has not been accepted yet.\n";
        message = (String)message + "The application will run in demo mode, meaning that no validation process can be started.\n";
        message = (String)message + "To fully exploit all the application features, please accept the user license:\n";
        message = (String)message + "you can accept the license at any time from the Help - About entry (top menu).\n";
        if (logger.isWarnEnabled()) {
            logger.warn("notifyMissingLicense():\n" + (String)message);
        }
        JOptionPane.showMessageDialog(parent, message, "Warning", 2);
    }

    public void notifyExitingNow() {
        JFrame parent = this.getParentFrame();
        if (logger.isDebugEnabled()) {
            logger.debug("notifyExitingNow() - Using parent frame: " + String.valueOf(parent));
        }
        Object message = "You chose to not accept the license, the application will close.\n\n";
        message = (String)message + "To run the Quality Check Software please restart the application ";
        message = (String)message + "and accept the user license.\n";
        if (logger.isWarnEnabled()) {
            logger.warn("notifyMissingLicense():\n" + (String)message);
        }
        JOptionPane.showMessageDialog(parent, message, "Warning", 2);
        if (logger.isWarnEnabled()) {
            logger.warn("notifyMissingLicense(): exiting now...");
        }
        System.exit(0);
    }

    public void handleUserChoice(int result) {
        if (result == 0) {
            this.validationOptions.setValue(Property.GUI_LICENSE_VALUE, this.licenseModel.getExpectedLicenseKey());
            if (logger.isInfoEnabled()) {
                logger.info("handleUserChoice() - User accepted license ? OK");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("handleUserChoice() - User accepted license ? NO");
        }
    }

    private class AcceptButtonListener
    implements ActionListener {
        private AcceptButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (logger.isInfoEnabled()) {
                logger.info("actionPerformed(Accept) - Event: " + String.valueOf(e));
            }
            CheckLicenseAction.this.handleUserChoice(0);
            if (e != null && e.getSource() != null) {
                ((JDialog)SwingUtilities.getWindowAncestor((Component)e.getSource())).dispose();
            }
        }
    }

    private class DeclineButtonListener
    implements ActionListener {
        private DeclineButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame parent;
            if (logger.isInfoEnabled()) {
                logger.info("actionPerformed(Decline) - Event: " + String.valueOf(e));
            }
            if ((parent = CheckLicenseAction.this.getParentFrame()) instanceof JFrame) {
                JFrame frame = parent;
                frame.dispose();
            } else {
                logger.error("actionPerformed(Decline) - Wrong reference to parent frame: " + String.valueOf(parent));
                logger.warn("Exiting now ...");
                System.exit(-1);
            }
        }
    }
}

