/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.controller;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.engine.ValidationCycle;
import eu.europa.ec.jrc.qcs.engine.ValidationLevel;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.ProtocolBasedAction;
import eu.europa.ec.jrc.qcs.gui.model.RuleTableDataModel;
import eu.europa.ec.jrc.qcs.gui.view.RuleInformationPanel;
import eu.europa.ec.jrc.qcs.gui.view.TablePanel;
import eu.europa.ec.jrc.qcs.gui.view.style.GroupCellRenderer;
import eu.europa.ec.jrc.qcs.gui.view.style.GroupColor;
import eu.europa.ec.jrc.qcs.gui.view.style.RowIndexCellRenderer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseProtocolAction
extends ProtocolBasedAction {
    private static final long serialVersionUID = -2865359626973768564L;
    HashMap<Integer, GroupColor> colorMap = new HashMap();
    private CellMouseListener mouseListener;
    GroupColor preRecordCycle = new GroupColor(new Color(0, 0, 150), Color.WHITE);
    GroupColor postRecordCycle = new GroupColor(new Color(0, 0, 150), Color.WHITE);
    protected static Logger logger = LoggerFactory.getLogger(BrowseProtocolAction.class);

    public BrowseProtocolAction(MainController mainController) {
        super(mainController);
        this.setValues();
    }

    @Override
    public void setValues() {
        String name = Configuration.getInstance().getLabel(Label.BROWSE_PROTOCOL);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
        this.putValue("MnemonicKey", 66);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ProtocolView protocolView = this.getCurrentProtocolView();
        int protocolID = protocolView.getProtocolID();
        if (logger.isInfoEnabled()) {
            logger.info("actionPerformed() - Opening protocol's table for protocolID: " + protocolID);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RuleTableDataModel tableDataModel = BrowseProtocolAction.this.getTableDataModel(protocolView);
                TablePanel tablePanel = new TablePanel(tableDataModel);
                tablePanel.setTemplate(3);
                BrowseProtocolAction.this.applyColourMap(tablePanel);
                BrowseProtocolAction.this.mouseListener = new CellMouseListener(tableDataModel, tablePanel);
                tablePanel.openTable(BrowseProtocolAction.this.mouseListener);
                tablePanel.centre();
            }
        });
    }

    protected RuleTableDataModel getTableDataModel(ProtocolView protocolView) {
        RuleTableDataModel tableDataModel = new RuleTableDataModel();
        Object[] header = new String[]{"NICE", "NAME", "CLASS", "RID", "CODE", "TYPE", "LEVEL", "CASE", "CYCLE", "BLOCKING"};
        tableDataModel.setHeader(header);
        List<ProtocolToRule> protocolTorules = protocolView.getProtocolToRules();
        int counter = 0;
        int numberOfRules = protocolTorules.size();
        Object[][] rows = new Object[numberOfRules][header.length];
        String name = protocolView.getName();
        tableDataModel.setTitle("Browing protocol " + name + ": " + numberOfRules + " rules (could include invalid rules)");
        if (logger.isInfoEnabled()) {
            logger.info("getTableDataModel() - Creating protocol table with " + numberOfRules + " rules");
        }
        for (ProtocolToRule protocolToRule : protocolTorules) {
            tableDataModel.addProtocolToRule(counter, protocolToRule);
            RuleDefinition ruleDefinition = protocolToRule.getRule();
            RuleType ruleType = ruleDefinition.getRuleType();
            int validationLevelAsInt = ruleType.getLevel();
            ValidationLevel validationLevel = ValidationLevel.getValidationLevel(validationLevelAsInt);
            ValidationCycle cycle = validationLevel.cycle;
            switch (cycle) {
                case PRE_RECORD: {
                    this.colorMap.put(counter, this.preRecordCycle);
                    break;
                }
                case POST_RECORD: {
                    this.colorMap.put(counter, this.postRecordCycle);
                    break;
                }
            }
            String ruleName = ruleDefinition.getName();
            String ruleClass = ruleDefinition.getImplementation();
            String errorCode = ruleDefinition.getValidationMessage().getCode();
            String type = String.valueOf((Object)ruleType);
            String level = "" + ruleType.validationLevel.level;
            rows[counter++] = new Object[]{protocolToRule.getPriority(), ruleName, ruleClass, ruleDefinition.getId(), errorCode, type, level, ruleDefinition.getCaseSensitivity().symbol, cycle, protocolToRule.isBlocking() ? "blocking" : ""};
            if (!logger.isDebugEnabled()) continue;
            logger.debug("getTableDataModel() - Added row: " + counter);
        }
        tableDataModel.setData(rows);
        return tableDataModel;
    }

    protected void applyColourMap(TablePanel tablePanel) {
        RowIndexCellRenderer renderer = new RowIndexCellRenderer(Color.BLACK, Color.WHITE);
        renderer.setRowsColorMap(this.colorMap);
        tablePanel.setTableCellRenderer(renderer);
        boolean colourColumn = false;
        if (colourColumn) {
            JTable table = tablePanel.getTable();
            TableColumn firstColumn = table.getColumnModel().getColumn(0);
            firstColumn.setCellRenderer(new GroupCellRenderer(Color.BLUE, Color.LIGHT_GRAY));
        }
    }

    class CellMouseListener
    extends MouseAdapter {
        protected RuleTableDataModel tableModel;
        protected TablePanel tablePanel;
        private RuleInformationPanel infoPanel;

        public CellMouseListener(RuleTableDataModel tableModel, TablePanel tableView) {
            this.tableModel = tableModel;
            this.tablePanel = tableView;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            boolean leftClick = SwingUtilities.isLeftMouseButton(event);
            boolean rightClick = SwingUtilities.isRightMouseButton(event);
            if (logger.isDebugEnabled()) {
                logger.debug("mouseClicked() - event : " + (leftClick ? "left" : "") + (rightClick ? "right" : ""));
            }
            JTable jTable = this.tablePanel.getTable();
            int row = jTable.rowAtPoint(event.getPoint());
            int col = jTable.columnAtPoint(event.getPoint());
            if (logger.isDebugEnabled()) {
                logger.debug("mouseClicked() - MouseEvent - Cell's content: " + String.valueOf(jTable.getValueAt(row, col)));
            }
            if (row >= 0 && col >= 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("mouseClicked() - Moused clicked on: (" + row + "," + col + ")");
                }
                if (leftClick) {
                    this.infoPanel = new RuleInformationPanel(this.tableModel);
                    this.infoPanel.setIndex(row);
                    SwingUtilities.invokeLater(this.infoPanel);
                }
            }
        }
    }
}

