/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.syntax;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.engine.rule.syntax.Bracket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Expression
extends DataRecordCSV {
    protected int expressionID;
    protected String expression;
    protected int messageID;
    protected List<Bracket> brackets;
    protected List<Bracket> terms;
    protected static final String leadingName = "Expression - ";
    private static Logger logger = LoggerFactory.getLogger(Expression.class);

    public Expression(String[] array) {
        super(array);
        this.expressionID = this.parseIntegerValue(array[0]);
        this.expression = array[1];
        this.messageID = this.parseIntegerValue(array[2]);
        this.findBrackets();
        if (logger.isTraceEnabled()) {
            logger.trace("Expression(): " + this.toShortString(true));
        }
    }

    public boolean evalute() {
        boolean result = false;
        for (Bracket term : this.terms) {
            this.evalTerm(term);
        }
        return result;
    }

    protected void findBrackets() {
        int i;
        this.brackets = new ArrayList<Bracket>();
        this.terms = new ArrayList<Bracket>();
        this.getCharIndexes('(', true);
        List<Integer> close = this.getCharIndexes(')', false);
        for (i = this.brackets.size() - 1; i >= 0; --i) {
            Bracket bracket = this.brackets.get(i);
            int matching = this.getMatchingBracket(bracket.getStartPosition(), close);
            bracket.setEndPosition(matching);
        }
        for (i = 0; i < this.brackets.size(); ++i) {
            for (int j = 0; j < this.brackets.size(); ++j) {
                if (i == j || this.brackets.get(i).getStartPosition() >= this.brackets.get(j).getStartPosition() || this.brackets.get(i).getEndPosition() <= this.brackets.get(j).getEndPosition()) continue;
                this.brackets.get(i).addChild(this.brackets.get(j));
                this.brackets.get(j).setParent(this.brackets.get(i));
            }
        }
        for (Bracket bracket : this.brackets) {
            if (bracket.getChildren() != null) continue;
            this.terms.add(bracket);
        }
    }

    protected int getMatchingBracket(int open, List<Integer> close) {
        int closest = 0;
        int minDelta = 9999;
        for (int index : close) {
            int delta = index - open;
            if (delta <= 0 || delta >= minDelta) continue;
            minDelta = delta;
            closest = index;
        }
        if (closest > 0) {
            close.remove((Object)closest);
        }
        return closest;
    }

    protected List<Integer> getCharIndexes(char symbol, boolean open) {
        int index = this.expression.indexOf(symbol);
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (index >= 0) {
            list.add(index);
            if (open) {
                this.brackets.add(new Bracket(index));
            }
            index = this.expression.indexOf(symbol, index + 1);
        }
        return list;
    }

    protected abstract boolean evalTerm(Bracket var1);

    public int getExpressionID() {
        return this.expressionID;
    }

    public void setExpressionID(int expressionID) {
        this.expressionID = expressionID;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getMessageID() {
        return this.messageID;
    }

    public void setMessageID(int messageID) {
        this.messageID = messageID;
    }

    public List<Bracket> getBrackets() {
        return this.brackets;
    }

    public void setBrackets(List<Bracket> brackets) {
        this.brackets = brackets;
    }

    public List<Bracket> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Bracket> terms) {
        this.terms = terms;
    }

    public String toShortString(boolean raw) {
        if (raw) {
            return this.expression;
        }
        List<Bracket> list = this.terms;
        StringBuilder builder = new StringBuilder();
        for (Bracket bracket : list) {
            String content = this.expression.substring(bracket.getStartPosition(), bracket.getEndPosition() + 1);
            builder.append("Print bracket: " + String.valueOf(bracket) + " -> " + content);
        }
        return builder.toString();
    }
}

