/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.field;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Mandatory;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.field.FieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownValueRule
extends FieldRule {
    protected static Logger logger = LoggerFactory.getLogger(UnknownValueRule.class);

    public UnknownValueRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule raises a warning message if the input record contains some variables which value matches the corresponding \"unknown\" label (for that variable).The rule is applied to 'STRICTLY mandatory' variables, and if the user enables it,also to 'USER_DEFINED mandatory' variables.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        List<Integer> checkFieldList = this.getTargetFieldsID();
        DataRecord record = (DataRecord)this.ruleInput;
        for (int position = 1; position <= record.getSize(); ++position) {
            String unknownValue;
            boolean appyToField;
            int recordFieldID;
            String value = record.getValue(position - 1);
            if (this.isEmpty(value)) continue;
            Field schemaField = schemaView.getFieldByPosition(position);
            if (checkFieldList != null && !checkFieldList.contains(recordFieldID = schemaField.getId())) continue;
            boolean optional = Configuration.getInstance().getBooleanProperty(Property.MANDATORY_FLAG_1);
            boolean bl = appyToField = schemaField.getMandatory() == Mandatory.STRICT || optional && schemaField.getMandatory() == Mandatory.USER_DEFINED_1;
            if (position == 16 && logger.isDebugEnabled()) {
                logger.info("applyCheck() - Optional flag         : " + optional);
                logger.info("applyCheck() - Field mandatory level : " + String.valueOf((Object)schemaField.getMandatory()));
                logger.info("applyCheck() - Apply rule            : " + appyToField);
            }
            if (!appyToField || this.isEmpty(unknownValue = schemaField.getUnknownLabel()) || !value.equals(unknownValue)) continue;
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(schemaField, value));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }
}

