/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.field;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.DataType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Range;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeRule
extends GenericRule {
    public static final String ANY = "ANY";
    public static final String YEAR = "YEAR";
    protected static Logger logger = LoggerFactory.getLogger(RangeRule.class);

    public RangeRule(RuleDefinition rule) {
        super(rule);
        this.setLongDescription("This rule performs field range validation. An acceptable value must belong to an accepted range of values, which can an interval (boundary) or list of values.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        DataRecord record = (DataRecord)this.ruleInput;
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck() - Using schema view: " + String.valueOf(schemaView));
        }
        boolean verbose = logger.isTraceEnabled();
        for (int position = 1; position <= record.getSize(); ++position) {
            Field field = schemaView.getFieldByPosition(position);
            Range range = field.getRange();
            if (verbose) {
                logger.info("");
                logger.info("applyCheck() - Field model: " + String.valueOf(field));
            }
            if (verbose) {
                logger.info("applyCheck() - Range model: " + String.valueOf(range));
            }
            String value = this.getFieldValue(field);
            if (verbose) {
                logger.info("applyCheck() - Field value: #" + value + "#");
            }
            if (this.isEmpty(value) || range == null || range == Range.UNDEF || range.getId() <= 0) continue;
            if (verbose) {
                logger.info("applyCheck() - Range is valid, checking field");
            }
            if (!this.isValidAndNotUnknownField(field, value)) {
                if (!verbose) continue;
                logger.info("applyCheck() - Field is invalid or set to unknown: checking next field");
                continue;
            }
            boolean isValid = true;
            if (verbose) {
                logger.info("applyCheck() - Range type ? " + (range.isInterval() ? "interval" : "enumeration"));
            }
            if (range.isInterval()) {
                if (!this.isValidIntervalRange(value, field)) {
                    isValid = false;
                }
            } else if (!this.isValidListRange(value, field)) {
                isValid = false;
            }
            if (isValid) continue;
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(field, value));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    protected boolean isValidIntervalRange(String value, Field field) {
        DataType type = field.getDataType();
        Range fieldRange = field.getRange();
        String fromValue = fieldRange.getFromValue();
        String toValue = fieldRange.getToValue();
        boolean debug = false;
        switch (type) {
            case NUMERIC: {
                try {
                    int valueInt = Integer.parseInt(value);
                    if (debug) {
                        logger.info("isValidIntervalRange() - Is integer " + value + " in interval [" + fromValue + "-" + toValue + "]");
                    }
                    if (ANY.equalsIgnoreCase(fromValue)) {
                        int toValueInt;
                        if (debug) {
                            logger.info("isValidIntervalRange() - From ANY value: " + valueInt);
                        }
                        return valueInt <= (toValueInt = Integer.parseInt(toValue));
                    }
                    if (ANY.equalsIgnoreCase(toValue)) {
                        int fromValueInt;
                        if (debug) {
                            logger.info("isValidIntervalRange() - To ANY value: " + valueInt);
                        }
                        return (fromValueInt = Integer.parseInt(fromValue)) <= valueInt;
                    }
                    if (debug) {
                        logger.info("isValidIntervalRange() - Normal rule: " + valueInt);
                    }
                    int fromValueInt = Integer.parseInt(fromValue);
                    int toValueInt = Integer.parseInt(toValue);
                    return fromValueInt <= valueInt && valueInt <= toValueInt;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case FLOATING: {
                try {
                    double valueFloat = Double.parseDouble(value);
                    if (debug) {
                        logger.info("isValidIntervalRange() - Is floating " + value + " in interval [" + fromValue + "-" + toValue + "]");
                        logger.info("isValidIntervalRange() - Parsed value: " + valueFloat);
                    }
                    if (ANY.equalsIgnoreCase(fromValue)) {
                        double toValueFloat;
                        if (debug) {
                            logger.info("isValidIntervalRange() - From ANY value: " + valueFloat);
                        }
                        return valueFloat <= (toValueFloat = Double.parseDouble(toValue));
                    }
                    if (ANY.equalsIgnoreCase(toValue)) {
                        double fromValueFloat;
                        if (debug) {
                            logger.info("isValidIntervalRange() - To ANY value: " + valueFloat);
                        }
                        return (fromValueFloat = Double.parseDouble(fromValue)) <= valueFloat;
                    }
                    if (debug) {
                        logger.info("isValidIntervalRange() - Normal rule: " + valueFloat);
                    }
                    double fromValueFloat = Double.parseDouble(fromValue);
                    double toValueFloat = Double.parseDouble(toValue);
                    return fromValueFloat <= valueFloat && valueFloat <= toValueFloat;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isValidListRange(String value, Field field) {
        Range fieldRange = field.getRange();
        List<String> rangeValues = fieldRange.getRangeValues();
        boolean fieldSensitivity = field.isCaseSensitive();
        CaseSensitivity ruleSensitivity = this.getRuleConfiguration().getCaseSensitivity();
        boolean isCaseSensitive = ruleSensitivity == CaseSensitivity.SENSITIVE || ruleSensitivity == CaseSensitivity.FIELD_LEVEL && fieldSensitivity;
        for (String rangeValue : rangeValues) {
            if (!(!isCaseSensitive ? value.equalsIgnoreCase(rangeValue) : value.equals(rangeValue))) continue;
            return true;
        }
        return false;
    }

    protected String replaceKeyword(String boundary) {
        if (YEAR.equalsIgnoreCase(boundary)) {
            Calendar calendar = Calendar.getInstance();
            int currentYear = calendar.get(1);
            return Integer.toString(currentYear);
        }
        return boundary;
    }

    @Override
    public void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        this.setDefaultSchemaView(DefaultSchemaID.INCIDENCE_2020_DEFAULT.id);
        this.ruleConfiguration.setRuleType(RuleType.RANGE);
        this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        this.ruleConfiguration.setRuleParameters(RuleParameter.ALL_FIELDS);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
    }
}

