/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.field;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.DataType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.field.DataTypeRule;
import eu.europa.ec.jrc.qcs.engine.rule.field.FieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxSizeRule
extends FieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DataTypeRule.class);

    public MaxSizeRule(RuleDefinition rule) {
        super(rule);
        if (rule.getCaseSensitivity() != CaseSensitivity.INSENSITIVE) {
            rule.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
            String message = "MaxSizeRule cannot be set to " + String.valueOf((Object)rule.getCaseSensitivity()) + ". Forcing it to " + String.valueOf((Object)rule.getCaseSensitivity());
            logger.error(message);
        }
        this.longDescription = "Checks the size of the value of each field in the record (handling it as string, even if numeric), and verifies that such size is not bigger than the 'maxSize' attribute of the field in the schema.";
    }

    @Override
    public List<RuleOutput> applyCheck() {
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        List<Integer> checkFieldList = this.getTargetFieldsID();
        DataRecord record = (DataRecord)this.ruleInput;
        for (int position = 1; position <= record.getSize(); ++position) {
            int recordFieldID;
            String value = record.getValue(position - 1);
            if (value == null) continue;
            Field schemaField = schemaView.getFieldByPosition(position);
            if (checkFieldList != null && !checkFieldList.contains(recordFieldID = schemaField.getId()) || !this.isValidDataType(value, schemaField.getDataType()) || value.length() <= schemaField.getMaxSize()) continue;
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(schemaField, value));
            this.addErrorDetail(fieldValues);
        }
        return this.getRuleOutput();
    }

    public boolean isValidDataType(String value, DataType type) {
        if (value.trim().length() == 0) {
            return true;
        }
        switch (type) {
            case NUMERIC: {
                try {
                    Integer.parseInt(value);
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case FLOATING: {
                try {
                    Float.parseFloat(value);
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return true;
    }
}

