/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.field;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Mandatory;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.field.FieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportantRule
extends FieldRule {
    protected static Logger logger = LoggerFactory.getLogger(ImportantRule.class);

    public ImportantRule(RuleDefinition rule) {
        super(rule);
        if (rule.getCaseSensitivity() != CaseSensitivity.INSENSITIVE) {
            rule.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
            String message = "ImportantRule cannot be set to " + String.valueOf((Object)rule.getCaseSensitivity()) + ". Forcing it to " + String.valueOf((Object)rule.getCaseSensitivity());
            logger.error(message);
        }
        this.setLongDescription("Checks that if a field is declared as 'mandatory = important' in the schema the value of that field is not empty. If a field contains a blank string (i.e. a list of empty chars), such field is also considered empty.");
    }

    @Override
    public List<RuleOutput> applyCheck() {
        DataRecord record = (DataRecord)this.ruleInput;
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        List<Integer> checkFieldList = this.getTargetFieldsID();
        boolean debug = false;
        if (debug) {
            logger.info("applyCheck() - Fields   : " + String.valueOf(checkFieldList));
        }
        for (int position = 1; position <= record.getSize(); ++position) {
            String trimmedValue;
            boolean appyRule;
            int recordFieldID;
            String value = record.getValue(position - 1);
            if (value == null) continue;
            Field schemaField = schemaView.getFieldByPosition(position);
            if (checkFieldList != null && !checkFieldList.contains(recordFieldID = schemaField.getId())) continue;
            if (debug && position == 4) {
                logger.info("applyCheck() - RecordID : " + record.getValue(0));
                logger.info("applyCheck() - Field    : " + String.valueOf(schemaField));
                logger.info("applyCheck() - Age      : #" + record.getValue(3) + "#");
            }
            boolean optional = Configuration.getInstance().getBooleanProperty(Property.MANDATORY_FLAG_1);
            boolean bl = appyRule = schemaField.getMandatory() == Mandatory.IMPORTANT || optional && schemaField.getMandatory() == Mandatory.USER_DEFINED_1;
            if (!appyRule || (trimmedValue = value.trim()).length() != 0) continue;
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(schemaField, value));
            this.addErrorDetail(fieldValues);
        }
        if (debug) {
            logger.info("applyCheck() - Returning output: " + String.valueOf(this.getRuleOutput()));
        }
        return this.getRuleOutput();
    }
}

