/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.field;

import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.GenericRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import java.util.ArrayList;
import java.util.List;

public abstract class FieldRule
extends GenericRule {
    public FieldRule(RuleDefinition rule) {
        super(rule);
    }

    @Override
    public void setDefaultConfiguration() {
        this.ruleConfiguration = new RuleConfiguration();
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)daoFactory.getDAO(DAO.SCHEMA_VIEW));
        SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(DefaultSchemaID.INCIDENCE_2014_DEFAULT.id);
        this.ruleConfiguration.setDefaultSchemaView(schemaView);
        this.ruleConfiguration.setRuleType(RuleType.FIELD_FORMAT);
        this.ruleConfiguration.setRuleTarget(RuleTarget.ALL_FIELDS);
        this.ruleConfiguration.setDefaultRuleParameters(RuleParameter.ALL_FIELDS);
    }

    public List<Integer> getTargetFieldsID() {
        ArrayList<Integer> targetFields = null;
        RuleTarget target = this.getRuleConfiguration().getRuleTarget();
        if (target != RuleTarget.ALL_FIELDS) {
            targetFields = new ArrayList<Integer>();
            List<RuleParameter> parameters = this.getRuleConfiguration().getRuleParameters();
            for (RuleParameter parameter : parameters) {
                targetFields.add(parameter.getFieldID());
            }
        }
        return targetFields;
    }
}

