/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.field;

import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.CaseSensitivity;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.DataType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.FieldValue;
import eu.europa.ec.jrc.qcs.engine.rule.field.FieldRule;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeRule
extends FieldRule {
    protected static Logger logger = LoggerFactory.getLogger(DataTypeRule.class);

    public DataTypeRule(RuleDefinition rule) {
        super(rule);
        if (rule.getCaseSensitivity() != CaseSensitivity.INSENSITIVE) {
            rule.setCaseSensitivity(CaseSensitivity.INSENSITIVE);
            String message = "DataTypeRule cannot be set to " + String.valueOf((Object)rule.getCaseSensitivity()) + ". Forcing it to " + String.valueOf((Object)rule.getCaseSensitivity());
            logger.error(message);
        }
        this.longDescription = "Checks that each field's value is of the datatype expected by the current schema.";
    }

    @Override
    public List<RuleOutput> applyCheck() {
        SchemaView schemaView = this.getRuleConfiguration().getTargetSchemaView();
        boolean debug = logger.isTraceEnabled();
        List<Integer> checkFieldList = this.getTargetFieldsID();
        DataRecord record = (DataRecord)this.ruleInput;
        for (int position = 1; position <= record.getSize(); ++position) {
            DataType fieldType;
            int recordFieldID;
            String value = record.getValue(position - 1);
            if (value == null) continue;
            if (debug) {
                logger.info("applyCheck() - Checking data type for position " + position + " -> value: #" + value + "#");
            }
            Field schemaField = schemaView.getFieldByPosition(position);
            if (checkFieldList != null && !checkFieldList.contains(recordFieldID = schemaField.getId())) continue;
            if (debug) {
                logger.info("applyCheck() - Checking data type for field: " + String.valueOf(schemaField));
            }
            if (this.isValidDataType(value, fieldType = schemaField.getDataType())) continue;
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            fieldValues.add(new FieldValue(schemaField, value));
            this.addErrorDetail(fieldValues);
            if (!debug) continue;
            logger.info("applyCheck() - WRONG datatype: " + String.valueOf((Object)fieldType));
        }
        return this.getRuleOutput();
    }

    public boolean isValidDataType(String value, DataType type) {
        if (value.trim().length() == 0) {
            return true;
        }
        switch (type) {
            case NUMERIC: {
                try {
                    Integer.parseInt(value);
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case FLOATING: {
                try {
                    Float.parseFloat(value);
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return true;
    }
}

