/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2020;

import eu.europa.ec.jrc.qcs.dao.DataRecordDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.DataRecordDAOImpl;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CandidateRecord;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CrossRecordMatch;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CrossRecordResult;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceCriterion;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.ExternalSorter;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2020.PrimaryDuplicatesRule2;
import eu.europa.ec.jrc.qcs.report.ReportType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryDuplicatesRule3
extends PrimaryDuplicatesRule2 {
    protected Map<Integer, String> singleSitesMap;
    protected List<DataRecord> mergedBunch;
    protected List<String> handledPrimaryKeys;
    protected List<String> topographyLateralityList;
    protected String reportName = "QCS-After-MPMT-Deletion.csv";
    protected String tempName = "QCS-After-MPMT-Deletion-Draft.csv";
    protected String tempFilePath;
    protected DataRecordDAO dataRecordDAO;
    private static Logger logger = LoggerFactory.getLogger(PrimaryDuplicatesRule3.class);

    public PrimaryDuplicatesRule3(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        this.debugLevel = 0;
        this.debugMainRecordID = null;
        this.setLongDescription("Checks if the input dataset contains some primary duplicate records, andmerge/delete such duplicates in order to produce a new filtered dataset.\nDefinition of \"Primary Duplicates\" is quite complex and regards only the ENCR Incidence protocols. See specification of the ENCR documentation for further details about this rule.");
    }

    @Override
    public boolean init() {
        List<DataRecordCSV> list;
        List<DataRecordCSV> singleSiteTopographies;
        boolean loadedParent = super.init();
        String fileName = "PrimaryMultipleGroups_1.csv";
        String configurationPath = this.ruleConfiguration.getConfigurationPath();
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Configuration path: " + configurationPath);
        }
        try {
            singleSiteTopographies = this.readCSVFile(configurationPath, fileName);
        }
        catch (MissingResourceException e) {
            logger.error("init() - Configuration file not found: " + configurationPath + "/" + fileName);
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("init() - Loaded merging groups list for context:\n" + this.getFormattedList(singleSiteTopographies));
        }
        this.singleSitesMap = new HashMap<Integer, String>();
        for (DataRecord dataRecord : singleSiteTopographies) {
            String groupIDAsString = dataRecord.getValue(0);
            String topographyGroup = dataRecord.getValue(1);
            int groupID = Integer.parseInt(groupIDAsString);
            this.singleSitesMap.put(groupID, topographyGroup);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("init() - Created merging groups map for context:\n");
            for (Map.Entry entry : this.singleSitesMap.entrySet()) {
                logger.trace("init() - groupID: " + String.valueOf(entry.getKey()) + " -> " + (String)entry.getValue());
            }
        }
        fileName = "TopographyLateralityRule.csv";
        String legacyConfigurationPath = "configuration/rules/encr2014";
        try {
            list = this.readCSVFile(legacyConfigurationPath, fileName);
        }
        catch (MissingResourceException e) {
            logger.error("init() - Configuration file not found: " + legacyConfigurationPath + "/" + fileName);
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("init() - Loaded list of topography with laterality values:\n" + this.getFormattedList(list));
        }
        this.topographyLateralityList = new ArrayList<String>();
        for (DataRecordCSV record : list) {
            this.topographyLateralityList.add(record.getValue(1));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("init() - Loaded list of topography with laterality values: " + String.valueOf(this.topographyLateralityList));
        }
        return loadedParent;
    }

    @Override
    protected Field prepareCheck() {
        Field field = super.prepareCheck();
        this.tempFilePath = this.customDirectory + this.tempName;
        boolean deleted = false;
        File file = new File(this.tempFilePath);
        try {
            deleted = Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            logger.error("prepareCheck() - Error deleting working file: " + this.tempFilePath);
        }
        if (deleted) {
            logger.info("prepareCheck() - Deleted previous working file: " + this.tempName);
        } else {
            logger.info("prepareCheck() - Previous working file (" + this.tempName + ") not found: running from clean installation");
        }
        FileConnection connection = new FileConnection(this.tempName, this.customDirectory);
        connection.setAppend(true);
        connection.setTemporary(true);
        this.dataRecordDAO = new DataRecordDAOImpl(connection);
        RuleConfiguration ruleConfig = this.getRuleConfiguration();
        SchemaView schemaView = ruleConfig.getTargetSchemaView();
        DataRecord header = schemaView.getHeader();
        DataRecord newHeader = header.clone();
        newHeader.push("Line", "Line");
        this.dataRecordDAO.save(newHeader);
        return field;
    }

    @Override
    public boolean isAcceptableRecord(List<RuleOutput> issues) {
        if (logger.isTraceEnabled()) {
            logger.trace("isAcceptableRecord() - Using acceptance criterion: " + this.acceptanceCriterion);
        }
        switch (this.acceptanceCriterion) {
            case 1: 
            case 2: 
            case 3: {
                return super.isAcceptableRecord(issues);
            }
        }
        String message = "Acceptance criterion " + this.acceptanceCriterion + " not supported by parent class.\n";
        message = message + "-> Any record is going to be marked as NOT ACCEPTABLE";
        logger.warn("isAcceptableRecord() - !!! !!! !!! ALL_EXCEPT_MPMT_EXCEPTIONS !!! !!! !!! : " + message);
        switch (this.acceptanceCriterion) {
            case 5: {
                return this.acceptAllExcepMPMTExceptions(issues);
            }
        }
        return false;
    }

    protected boolean acceptAllExcepMPMTExceptions(List<RuleOutput> issues) {
        return false;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        Field patientID_field = this.prepareCheck();
        RuleConfiguration ruleConfig = this.getRuleConfiguration();
        SchemaView schemaView = ruleConfig.getTargetSchemaView();
        int patientIDPosition = schemaView.getFieldPosition(patientID_field.getId());
        int keyIndex = patientIDPosition - 1;
        if (logger.isDebugEnabled()) {
            logger.debug("applyCheck() - " + this.getModelName() + " (ruleID=" + this.getId() + ")");
            logger.debug("applyCheck() - Reading bunch on column's index " + keyIndex);
        }
        int counter = 0;
        while (this.dataSetReader.hasNext()) {
            List<CrossRecordMatch> duplicates;
            this.bunch = this.dataSetReader.getNextBunch(keyIndex);
            if (this.isDebugEnabled(1)) {
                DataRecord firstRecord = (DataRecord)this.bunch.get(0);
                String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
                logger.debug("applyCheck() - Main recordID " + mainRecordID + " -> Fetched bunch with " + this.bunch.size() + " records");
                if (this.isDebugEnabledForCurrentBunch(1)) {
                    for (DataRecord record : this.bunch) {
                        logger.debug("\t" + record.toShortString());
                    }
                }
            }
            List<DataRecord> toBeSaved = (duplicates = this.checkBunchOfRecords(this.bunch)).size() == 0 ? this.bunch : this.compareRecords(duplicates);
            this.saveBunch(toBeSaved);
            if (!this.enableInstrumentation || ++counter % 50000 != 0) continue;
            this.logMemoryStatus(counter);
        }
        if (this.isDebugEnabled(13)) {
            int matched = this.crossRecordMatches != null ? this.crossRecordMatches.size() : 0;
            logger.debug("");
            logger.debug("applyCheck() - Primary duplicates output: (found " + matched + " \"raw\" duplicates)");
            logger.debug("");
        }
        List<RuleOutput> duplicates = this.filterCrossRecordMatches();
        this.restoreOriginalOrder();
        return duplicates;
    }

    @Override
    public boolean filterRecord(EquivalenceCriterion criterion, CandidateRecord candidateRecord) {
        if (this.isDebugEnabledForCurrentBunch(1) || this.isDebugEnabledForCurrentBunch(2)) {
            logger.info("filterRecord() - Invoking parent's filtering criterion (should be defined in PrimaryDuplicatesRule1 class)");
        }
        boolean passed = super.filterRecord(criterion, candidateRecord);
        if (this.isDebugEnabledForCurrentBunch(1) || this.isDebugEnabledForCurrentBunch(2)) {
            logger.info("filterRecord() - Filtering record for bunch: " + this.getBunchInformation(this.bunch));
        }
        return passed;
    }

    protected List<DataRecord> compareRecords(List<CrossRecordMatch> duplicates) {
        this.mergedBunch = new ArrayList<DataRecord>();
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        if (this.isDebugEnabled(14)) {
            logger.debug("compareRecords() - Duplicates in bunch:\n" + String.valueOf(duplicates));
        }
        this.handledPrimaryKeys = new ArrayList<String>();
        for (DataRecord record : this.bunch) {
            CandidateRecord firstRecord;
            String firstPrimaryKey;
            String singleSiteTopography;
            boolean singleSite;
            String primaryKey;
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("");
                logger.debug("compareRecords() ---------------------------------------------------------");
                logger.debug("compareRecords() - Checking record: " + String.valueOf(record));
            }
            if (this.handledPrimaryKeys.contains(primaryKey = this.getPrimaryKeyBySchemaPerspective(record))) {
                if (!this.isDebugEnabledForCurrentBunch(14)) continue;
                logger.debug("compareRecords() - Record already handled -> skipping");
                continue;
            }
            CrossRecordMatch crossRecordMatch = this.findCrossRecordMatchByPrimaryKey(duplicates, primaryKey);
            boolean duplicate = crossRecordMatch != null;
            if (!duplicate) continue;
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("compareRecords() - Checking cross record match: " + String.valueOf(crossRecordMatch));
            }
            boolean bl = singleSite = (singleSiteTopography = this.isSingleSiteTopography(crossRecordMatch)) != null;
            if (!singleSite) {
                if (this.isDebugEnabledForCurrentBunch(14)) {
                    logger.debug("compareRecords() - NOT a single topography site -> saving " + primaryKey);
                }
                this.mergedBunch.add(record);
                continue;
            }
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("compareRecords() - Found a single topography site for record: " + primaryKey);
            }
            String otherKey = null;
            CandidateRecord otherRecord = null;
            List<CandidateRecord> allOtherRecords = crossRecordMatch.getOtherRecords();
            for (CandidateRecord other : allOtherRecords) {
                otherKey = this.getPrimaryKeyBySchemaPerspective(other);
                if (this.isDebugEnabledForCurrentBunch(14)) {
                    logger.debug("compareRecords() - Comparing duplicates : " + primaryKey + " vs " + otherKey);
                }
                if (this.handledPrimaryKeys.contains(otherKey)) {
                    if (!this.isDebugEnabledForCurrentBunch(14)) continue;
                    logger.debug("compareRecords() - Other record already handled (" + otherKey + ") -> skipping");
                    continue;
                }
                otherRecord = other;
                break;
            }
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("compareRecords() - Selected other record: " + String.valueOf(otherRecord));
            }
            if (otherRecord == null) {
                if (!logger.isInfoEnabled()) continue;
                logger.info("compareRecords() - No other records     : ending comparison for record " + primaryKey);
                continue;
            }
            Field month_DoI_field = ruleConfiguration.getFieldByPosition(6);
            Field year_DoI_field = ruleConfiguration.getFieldByPosition(7);
            String monthDoI = this.getFieldValue(record, month_DoI_field);
            String yearDoI = this.getFieldValue(record, year_DoI_field);
            String other_monthDoI = this.getFieldValue((DataRecord)otherRecord, month_DoI_field);
            String other_yearDoI = this.getFieldValue((DataRecord)otherRecord, year_DoI_field);
            Date firstDate = this.getDateFromFields(monthDoI, yearDoI);
            Date secondDate = this.getDateFromFields(other_monthDoI, other_yearDoI);
            long days = this.getDifferenceInDays(firstDate, secondDate);
            if (this.isDebugEnabledForCurrentBunch(14)) {
                String record_1 = primaryKey + " (" + monthDoI + "/" + yearDoI + ")";
                String record_2 = otherKey + " (" + other_monthDoI + "/" + other_yearDoI + ")";
                logger.debug("compareRecords() - Duplicates records   : " + record_1 + " vs " + record_2 + " -> " + days + " days");
            }
            if (!primaryKey.equals(firstPrimaryKey = this.getPrimaryKeyBySchemaPerspective(firstRecord = crossRecordMatch.getFirstRecord()))) {
                logger.error("compareRecords() - Wrong reference to first record: " + firstPrimaryKey + " differs from " + primaryKey);
            }
            if (Math.abs(days) > 92L) {
                if (this.isDebugEnabledForCurrentBunch(14)) {
                    logger.debug("compareRecords() - Asynchronous records : saving only earlier record");
                }
                this.saveEarlierRecord(firstRecord, otherRecord, days);
                continue;
            }
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("compareRecords() - SYNCHRONOUS records  : evaluating merge logic");
            }
            this.compareSynchronousRecords(firstRecord, otherRecord, crossRecordMatch, days, singleSiteTopography);
        }
        return this.mergedBunch;
    }

    protected void compareSynchronousRecords(CandidateRecord first, CandidateRecord second, CrossRecordMatch crossRecordMatch, long days, String singleSite) {
        String laterTopography;
        String earlierTopography;
        String label;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        boolean correctOrder = days >= 0L;
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        String string = label = correctOrder ? "1st" : "2nd";
        if (correctOrder) {
            earlierTopography = this.getFieldValue((DataRecord)first, topography_field);
            laterTopography = this.getFieldValue((DataRecord)second, topography_field);
        } else {
            earlierTopography = this.getFieldValue((DataRecord)second, topography_field);
            laterTopography = this.getFieldValue((DataRecord)first, topography_field);
        }
        boolean isEarlierSpecific = this.isSpecificTopography(earlierTopography);
        boolean isLaterSpecific = this.isSpecificTopography(laterTopography);
        if (this.isDebugEnabledForCurrentBunch(14)) {
            logger.debug("synchronousRecords() - Topography (" + label + ") : " + earlierTopography + (isEarlierSpecific ? " (specific)" : " (a-specific)"));
        }
        if (isEarlierSpecific) {
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("synchronousRecords() - EARLIER record has specific topography: " + earlierTopography);
            }
            this.modifyEarlierRecord(first, second, days, singleSite);
            this.saveEarlierRecord(first, second, days);
        } else if (isLaterSpecific) {
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("synchronousRecords() - LATER record has specific topography: " + laterTopography);
            }
            this.saveEarlierRecord(first, second, -days);
        } else {
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("synchronousRecords() - NO record has specific topography: " + earlierTopography + "/" + laterTopography);
            }
            this.saveEarlierRecord(first, second, days);
        }
    }

    protected void modifyEarlierRecord(CandidateRecord first, CandidateRecord second, long days, String singleSite) {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        SchemaView schemaView = ruleConfiguration.getTargetSchemaView();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        int topographyIndex = schemaView.getFieldPosition(topography_field) - 1;
        if (days >= 0L) {
            first.setValue(topographyIndex, singleSite);
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("modifyEarlierRecord() - MODIFIED first record - Set topography to: " + singleSite);
            }
        } else {
            second.setValue(topographyIndex, singleSite);
            if (this.isDebugEnabledForCurrentBunch(14)) {
                logger.debug("modifyEarlierRecord() - MODIFIED second record - Set topography to: " + singleSite);
            }
        }
    }

    protected void saveEarlierRecord(CandidateRecord firstRecord, CandidateRecord secondRecord, long days) {
        if (days >= 0L) {
            this.saveFirstRecord(firstRecord, secondRecord);
        } else {
            this.saveFirstRecord(secondRecord, firstRecord);
        }
    }

    protected void saveFirstRecord(CandidateRecord saved, CandidateRecord discarded) {
        String primaryKey = this.getPrimaryKeyBySchemaPerspective(saved);
        String otherKey = this.getPrimaryKeyBySchemaPerspective(discarded);
        this.mergedBunch.add(saved);
        this.handledPrimaryKeys.add(otherKey);
        if (this.isDebugEnabledForCurrentBunch(14)) {
            logger.debug("saveEarlierRecord() - SAVED record      : " + primaryKey + " (and discarted " + otherKey + ")");
        }
    }

    protected void saveBunch(List<DataRecord> list) {
        for (DataRecord record : list) {
            this.dataRecordDAO.save(record);
        }
    }

    protected void restoreOriginalOrder() {
        ExternalSorter sorter = new ExternalSorter(this.customDirectory);
        sorter.setAlphaNumeric(false);
        sorter.setAddLineNumber(false);
        sorter.setRemoveLineNumber(true);
        sorter.setOutputFile(this.reportName);
        String reportFolder = ReportType.getRelativePath(ReportType.INCIDENCE_2014) + "/";
        sorter.setOutputPath(reportFolder);
        if (logger.isInfoEnabled()) {
            logger.info("restoreOriginalOrder() - Draft custom report   : " + this.tempFilePath);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("restoreOriginalOrder() - Custom output folder : " + reportFolder);
        }
        long startTime = System.currentTimeMillis();
        String orderedFileName = sorter.sortFile(this.tempFilePath, "Line");
        long endTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info("restoreOriginalOrder() - Sorted file \"" + orderedFileName + "\" in " + (endTime - startTime) + " ms");
        }
    }

    protected String isSingleSiteTopography(CrossRecordMatch crossRecordMatch) {
        boolean isSingleSite;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        int topographyFieldID = topography_field.getId();
        CrossRecordResult crossRecordResult = crossRecordMatch.getMatchResult();
        Set<Integer> sharedGroupIDs = crossRecordResult.getIntersection(topographyFieldID);
        if (sharedGroupIDs == null) {
            logger.error("isSingleSiteTopography() - Found null list of shared group IDs");
            return null;
        }
        String singleSiteTopography = null;
        ArrayList<Integer> intersection = new ArrayList<Integer>(sharedGroupIDs);
        Set<Integer> singleSiteTopographies = this.singleSitesMap.keySet();
        intersection.retainAll(singleSiteTopographies);
        boolean bl = isSingleSite = intersection.size() == 1;
        if (isSingleSite) {
            int commonGroupID = (Integer)intersection.get(0);
            singleSiteTopography = this.singleSitesMap.get(commonGroupID);
        }
        if (this.isDebugEnabledForCurrentBunch(14)) {
            logger.debug("isSingleSiteTopography() - IDs of matched groups         : " + String.valueOf(sharedGroupIDs));
            logger.debug("isSingleSiteTopography() - Intersection with single site : " + String.valueOf(intersection));
            logger.debug("isSingleSiteTopography() - Are duplicates a single site  ? " + isSingleSite + " [" + singleSiteTopography + "]");
        }
        return singleSiteTopography;
    }

    protected boolean isSingleSiteTopography(String value) {
        return false;
    }

    protected boolean isSpecificTopography(String value) {
        if (value == null) {
            logger.error("isSpecificTopography() - Null topography");
            return false;
        }
        if (value.length() < 3) {
            logger.error("isSpecificTopography() - Wrong topography: " + value);
            return false;
        }
        if (value.length() == 3) {
            return false;
        }
        char lastDigit = value.charAt(3);
        boolean specific = lastDigit != '0';
        return specific;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        List<RuleParameter> defaultRuleParameters = this.ruleConfiguration.getDefaultRuleParameters();
        RuleParameter param_6 = new RuleParameter(6, DefaultFieldIDencr2020.INCIDENCE_MONTH_DOI.id, false);
        RuleParameter param_7 = new RuleParameter(7, DefaultFieldIDencr2020.INCIDENCE_YEAR_DOI.id, false);
        defaultRuleParameters.add(param_6);
        defaultRuleParameters.add(param_7);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        if (logger.isDebugEnabled()) {
            logger.debug("setDefaultConfiguration() - Loaded default configuration");
        }
    }
}

