/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2020;

import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultSchemaID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceContext;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014.PrimaryDuplicatesRule1;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryDuplicatesRule2
extends PrimaryDuplicatesRule1 {
    private static Logger logger = LoggerFactory.getLogger(PrimaryDuplicatesRule2.class);

    public PrimaryDuplicatesRule2(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        this.debugLevel = 0;
        this.debugMainRecordID = null;
        this.debugPrimaryKey = null;
        this.setLongDescription("Checks if the input dataset contains some primary duplicate records (ENCR 2020 protocol).\nDefinition of \"Primary Duplicates\" is quite complex and regards only the ENCR Incidence protocols. See specification of the ENCR documentation for further details about this rule.");
    }

    @Override
    public boolean init() {
        this.resetCriteria();
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        String equivalenceFileContext_1 = files.get(0).getFileName();
        String equivalenceFileContext_2 = files.get(1).getFileName();
        String criteriaFile = files.get(2).getFileName();
        EquivalenceContext equivalenceContext_1 = new EquivalenceContext(1, equivalenceFileContext_1, true);
        EquivalenceContext equivalenceContext_2 = new EquivalenceContext(2, equivalenceFileContext_2, false);
        this.equivalenceContexts.put(1, equivalenceContext_1);
        this.equivalenceContexts.put(2, equivalenceContext_2);
        boolean criteria = this.loadMultiplePrimaryCriteria(criteriaFile);
        boolean metaData = this.loadMetaData();
        boolean hematological = this.loadHematologicalMorphologies();
        String legacyConfigurationPath = "configuration/rules/encr2014";
        boolean expceptions = this.loadExceptionsData(legacyConfigurationPath);
        boolean unspecifiedMorphologies = this.loadUnspecifiedMorphologies();
        boolean behaviour = this.loadFilteringData(legacyConfigurationPath);
        boolean topographyGroups = this.loadTopographyGroups(legacyConfigurationPath);
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Initialisation concluded");
        }
        return criteria && metaData && hematological && expceptions && unspecifiedMorphologies && behaviour && topographyGroups;
    }

    @Override
    protected boolean acceptAllExceptSomeErrors(List<RuleOutput> issues) {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        Field patientIDField = ruleConfiguration.getFieldByPosition(1);
        String patientID = this.getFieldValue(this.acceptingRecord, patientIDField);
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptSomeErrors() - Applying Topo Morpho criteria on record " + patientID);
        }
        if (!this.isValidField(topography_field)) {
            return false;
        }
        if (!this.isValidField(morphology_field)) {
            return false;
        }
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptSomeErrors() - Applied Topo Morpho criteria on record " + patientID);
            logger.debug("acceptAllExceptSomeErrors() - Previous : " + String.valueOf(this.previousOutputs));
        }
        if (this.previousOutputContainsRule(DefaultRuleID.SEX_TOPOGRAPHY.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.AGE_BIRTH_INCIDENCE_3.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.AGE_BIRTH_INCIDENCE_4.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.DATE_BIRTH_INCIDENCE_2.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.AGE_TUMOUR_H2.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.MORPHOLOGY_TOPOGRAPHY.id)) {
            if (this.isDebugEnabledForCurrentBunch(10)) {
                logger.debug("acceptAllExceptSomeErrors() - " + patientID + " failed rule " + DefaultRuleID.MORPHOLOGY_TOPOGRAPHY.id);
            }
            return false;
        }
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptSomeErrors() - Applied all minor criteria on record " + patientID);
        }
        return true;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        this.setDefaultSchemaView(DefaultSchemaID.INCIDENCE_2020_DEFAULT.id);
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param_1 = new RuleParameter(1, DefaultFieldIDencr2020.INCIDENCE_PATIENT_ID.id, false);
        RuleParameter param_2 = new RuleParameter(2, DefaultFieldIDencr2020.INCIDENCE_TUMOUR_ID.id, false);
        RuleParameter param_3 = new RuleParameter(3, DefaultFieldIDencr2020.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param_4 = new RuleParameter(4, DefaultFieldIDencr2020.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param_5 = new RuleParameter(5, DefaultFieldIDencr2020.INCIDENCE_BEHAVIOUR.id, false);
        defaultRuleParameters.add(param_1);
        defaultRuleParameters.add(param_2);
        defaultRuleParameters.add(param_3);
        defaultRuleParameters.add(param_4);
        defaultRuleParameters.add(param_5);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("PrimaryMultipleContext_3.csv", "", "", "Equivalents records in context 1 - 2020 (Topography and Morphology"));
        files.add(new LocalFile("PrimaryMultipleContext_4.csv", "", "", "Equivalents records in context 2 - 2020 (Topography and Morphology"));
        files.add(new LocalFile("PrimaryMultipleCriteria.csv", "", "", "Defintion of the equivalence criteria (not used yes)"));
        files.add(new LocalFile("TopographyLateralityTable.csv", "", "", "Definition of topographies allowing laterality"));
        files.add(new LocalFile("PrimaryMultipleFilter.csv", "", "", "List of criteria for filtering records (before comparing them)"));
        files.add(new LocalFile("PrimaryMultipleGroups.csv", "", "", "Table 3, based on Table 14 of the QC report (2023)"));
        this.ruleConfiguration.setConfigurationFiles(files);
        this.ruleConfiguration.setConfigurationPath("config/rules/encr2020");
        if (logger.isDebugEnabled()) {
            logger.debug("setDefaultConfiguration(): loaded default configuration");
        }
    }
}

