/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TopographyParser;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopographyGroup
extends SerializableModel
implements Comparable<TopographyGroup> {
    public static TopographyParser topographyParser;
    protected String groupCode;
    protected String siteCode;
    protected String notAllowed;
    protected int topoStart = -1;
    protected int topoEnd = -1;
    public static final char SEPARATOR = ',';
    public static final String RANGE = "-";
    public static final String ANY = "Any";
    public static final char TOPO_START = 'C';
    public static final int WRONG_TOPO = -1;
    public static final TopographyGroup UNDEF;
    protected static Logger logger;

    public TopographyGroup() {
        this.setValid(false);
        this.setName("undefined_filter_condition");
        this.setDescription("Empty reference for a \"null\" TopographyGroup instance");
    }

    public TopographyGroup(String groupID, String group_code, String site_code, String description, String not_allowed) {
        this();
        if (logger.isTraceEnabled()) {
            String values = groupID + ", " + group_code + ", " + site_code + ", " + description + ", " + not_allowed;
            logger.trace("Constructor(NO_ID) - Using values: " + values);
        }
        this.setId(groupID);
        this.setName(group_code);
        this.setDescription(description);
        this.groupCode = group_code;
        this.siteCode = site_code;
        this.notAllowed = not_allowed;
    }

    public TopographyGroup(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4]);
    }

    public static List<TopographyGroup> expandTopographies(TopographyGroup topographyGroup) {
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopographies() - Expanding group: " + String.valueOf(topographyGroup));
        }
        String siteCode = topographyGroup.getSiteCode();
        String separator = String.valueOf(',');
        String[] topographies = siteCode.split(separator);
        ArrayList<TopographyGroup> expandedTopographyGroups = new ArrayList<TopographyGroup>();
        for (String topography : topographies) {
            int[] range = topographyParser.expandTopographies(topography);
            TopographyGroup newGroup = topographyGroup.clone();
            newGroup.setTopoStart(range[0]);
            newGroup.setTopoEnd(range[1]);
            expandedTopographyGroups.add(newGroup);
        }
        return expandedTopographyGroups;
    }

    public boolean isAllowed(String topography) {
        String not_allowed = this.getNotAllowed();
        if (logger.isTraceEnabled()) {
            logger.trace("isNotAllowed() - Checking topography: " + topography + " VS " + not_allowed);
        }
        if (not_allowed == null) {
            return true;
        }
        if (not_allowed.contains(topography)) {
            return false;
        }
        if (not_allowed.contains(topography.substring(0, 3))) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("isNotAllowed() - Topography OK: " + topography);
        }
        return true;
    }

    public int getTopoStart() {
        return this.topoStart;
    }

    public void setTopoStart(int topoStart) {
        this.topoStart = topoStart;
    }

    public int getTopoEnd() {
        return this.topoEnd;
    }

    public void setTopoEnd(int topoEnd) {
        this.topoEnd = topoEnd;
    }

    public String getGroupCode() {
        return this.groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getNotAllowed() {
        return this.notAllowed;
    }

    public void setNotAllowed(String not_allowed) {
        this.notAllowed = not_allowed;
    }

    @Override
    public String[] serialize() {
        String description;
        String groupID = this.getIdAsString();
        String string = description = this.description != null ? this.description : this.name;
        if (logger.isTraceEnabled()) {
            logger.trace("serialize() - serialising record having ID: " + groupID + " (" + description + ")");
        }
        String[] values = new String[]{groupID, this.groupCode, this.siteCode, description, this.notAllowed};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"GROUPID", "GROUP_CODE", "SITE_CODE", "DESCRIPTION", "NOT_ALLOWED"};
        return values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.topoStart >= 0 && this.topoEnd > 0) {
            builder.append(this.topoStart);
            builder.append(RANGE);
            builder.append(this.topoEnd);
            int blanks = 7 - builder.length();
            if (blanks > 0) {
                String suffix = new String(new char[blanks]).replace('\u0000', ' ');
                builder.append(suffix);
            }
            builder.append(" -> ");
        }
        if (this.groupCode != null) {
            builder.append("groupCode=");
            builder.append(this.groupCode);
        }
        if (this.siteCode != null) {
            builder.append(" ,siteCode=");
            builder.append(this.siteCode);
        }
        if (this.notAllowed != null) {
            builder.append(" ,not_allowed=");
            builder.append(this.notAllowed);
        }
        return builder.toString();
    }

    public TopographyGroup clone() {
        if (logger.isTraceEnabled()) {
            logger.trace("clone() - Cloning object: " + String.valueOf(this));
        }
        String _groupID = new String(this.getIdAsString());
        String _groupCode = new String(this.groupCode);
        String _siteCode = new String(this.siteCode);
        String _description = new String(this.description);
        String _not_allowed = new String(this.notAllowed);
        TopographyGroup newObject = new TopographyGroup(_groupID, _groupCode, _siteCode, _description, _not_allowed);
        return newObject;
    }

    @Override
    public int compareTo(TopographyGroup other) {
        if (this.topoStart != other.topoStart) {
            return Integer.compare(this.topoStart, other.topoStart);
        }
        return Integer.compare(this.topoEnd, other.topoEnd);
    }

    static {
        UNDEF = new TopographyGroup();
        logger = LoggerFactory.getLogger(TopographyGroup.class);
        topographyParser = new TopographyParser();
    }
}

