/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Range;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CandidateRecord;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.CrossRecordMatch;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceContext;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.EquivalenceCriterion;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.ExternalSorter;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014.BehaviourTable;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014.EquivalentsRecordRule;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014.FilterCondition;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014.TopographyGroup;
import eu.europa.ec.jrc.qcs.util.RangeProducer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryDuplicatesRule1
extends EquivalentsRecordRule {
    protected int acceptanceCriterion;
    protected boolean strictCheck;
    protected Map<String, Integer> topographyLateralityMap;
    protected Set<String> haematologicalMorphologies;
    protected Set<String> unspecifiedMorphologies;
    protected List<FilterCondition> behaviourTableRaw;
    protected BehaviourTable behaviourTable;
    protected List<TopographyGroup> topographyGroups;
    public static final int ONLY_VALID_RECORDS = 1;
    public static final int ALL_EXCEPT_WRONG_MORPHO = 2;
    public static final int ALL_EXCEPT_SOME_ERRORS = 3;
    public static final int ALL_EXCEPT_WRONG_TOPO_MORPHO = 4;
    public static final int ALL_EXCEPT_MPMT_EXCEPTIONS = 5;
    private static Logger logger = LoggerFactory.getLogger(PrimaryDuplicatesRule1.class);

    public PrimaryDuplicatesRule1(RuleDefinition ruleDefinition) {
        super(ruleDefinition);
        this.debugLevel = 0;
        this.debugMainRecordID = null;
        this.debugPrimaryKey = null;
        if (this.debugLevel != 0) {
            logger.info("Debug fine level and monitored record    : " + this.debugLevel + " (recordID=" + this.debugMainRecordID + ")");
        }
        this.setLongDescription("Checks if the input dataset contains some Primary Duplicate records (ENCR 2014 protocol).\nDefinition of \"Primary Duplicates\" is quite complex and regards only the ENCR Incidence protocols. See specification of the ENCR documentation for further details about this rule.");
    }

    @Override
    public boolean init() {
        this.resetCriteria();
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        String equivalenceFileContext_1 = files.get(0).getFileName();
        String equivalenceFileContext_2 = files.get(1).getFileName();
        String criteriaFile = files.get(2).getFileName();
        EquivalenceContext equivalenceContext_1 = new EquivalenceContext(1, equivalenceFileContext_1, true);
        EquivalenceContext equivalenceContext_2 = new EquivalenceContext(2, equivalenceFileContext_2, false);
        this.equivalenceContexts.put(1, equivalenceContext_1);
        this.equivalenceContexts.put(2, equivalenceContext_2);
        boolean criteria = this.loadMultiplePrimaryCriteria(criteriaFile);
        boolean metaData = this.loadMetaData();
        boolean hematological = this.loadHematologicalMorphologies();
        String legacyConfigurationPath = this.ruleConfiguration.getConfigurationPath();
        boolean expceptions = this.loadExceptionsData(legacyConfigurationPath);
        boolean unspecifiedMorphologies = this.loadUnspecifiedMorphologies();
        boolean behaviour = this.loadFilteringData(legacyConfigurationPath);
        boolean topographyGroups = this.loadTopographyGroups(legacyConfigurationPath);
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Initialisation concluded");
        }
        return criteria && metaData && hematological && expceptions && unspecifiedMorphologies && behaviour && topographyGroups;
    }

    protected boolean loadMultiplePrimaryCriteria(String criteriaFileName) {
        boolean loaded = this.loadEquivalenceCriteria(criteriaFileName);
        if (logger.isDebugEnabled()) {
            logger.debug("loadMultiplePrimaryCriteria() - Loaded criterions from file " + criteriaFileName + " ? " + loaded);
        }
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        EquivalenceCriterion criterion_1 = this.getCriterionByID(1);
        EquivalenceCriterion criterion_2 = this.getCriterionByID(2);
        Integer[] fieldIDs_criterion_1 = new Integer[]{topography_field.getId(), morphology_field.getId()};
        Integer[] fieldIDs_criterion_2 = new Integer[]{morphology_field.getId()};
        criterion_1.setFieldIDs(Arrays.asList(fieldIDs_criterion_1));
        criterion_2.setFieldIDs(Arrays.asList(fieldIDs_criterion_2));
        criterion_1.setEquivalenceContexts((EquivalenceContext)this.equivalenceContexts.get(1));
        criterion_2.setEquivalenceContexts((EquivalenceContext)this.equivalenceContexts.get(2));
        if (logger.isDebugEnabled()) {
            logger.debug("loadMultiplePrimaryCriteria() - Initialised criterion: " + String.valueOf(criterion_1));
            logger.debug("loadMultiplePrimaryCriteria() - Initialised criterion: " + String.valueOf(criterion_2));
        }
        return true;
    }

    protected boolean loadMetaData() {
        boolean loaded;
        String configurationPath = this.ruleConfiguration.getConfigurationPath();
        if (logger.isDebugEnabled()) {
            logger.debug("loadMetaData(file) - configurationPath: " + configurationPath);
        }
        if (!(loaded = this.loadMetaData(configurationPath))) {
            String path = configurationPath.replace("config", "configuration");
            if (logger.isWarnEnabled()) {
                logger.warn("loadMetaData(file) - File not found in directory : " + configurationPath);
                logger.warn("loadMetaData(file) - Retry with                  : " + path);
            }
            loaded = this.loadMetaData(path);
        }
        return loaded;
    }

    protected boolean loadMetaData(String basePath) {
        if (logger.isDebugEnabled()) {
            logger.debug("loadMetaData(path) - Configuration path: " + basePath);
        }
        for (Map.Entry item : this.equivalenceContexts.entrySet()) {
            EquivalenceContext context = (EquivalenceContext)item.getValue();
            int contextID = context.getContextID();
            String fileName = context.getConfigurationFile();
            if (logger.isDebugEnabled()) {
                logger.debug("loadMetaData(path) - Loading configuration file: " + fileName);
            }
            List<DataRecordCSV> groupsList = null;
            try {
                groupsList = this.readCSVFile(basePath, fileName);
            }
            catch (MissingResourceException e) {
                logger.error("loadMetaData(path) - Configuration file not found: " + basePath + "/" + fileName);
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("loadMetaData(path) - Loaded groups list for context " + contextID + ":\n" + this.getFormattedList(groupsList));
            }
            List<DataRecordCSV> actualGroupsList = null;
            actualGroupsList = context.isShortSyntax() ? this.getExpandedGroupsList(groupsList) : groupsList;
            EquivalenceContext equivalentGroups = this.createEquivalenceGroups(contextID, actualGroupsList);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(equivalentGroups.printMap());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadMetaData(path) - Loaded equivalence groups for " + this.equivalenceContexts.size() + " contexts");
        }
        return true;
    }

    public List<DataRecordCSV> getExpandedGroupsList(List<DataRecordCSV> list) {
        Field topography_field = this.ruleConfiguration.getFieldByPosition(3);
        Range topographyRange = topography_field.getRange();
        List<String> validTopographies = topographyRange.getRangeValues();
        if (logger.isTraceEnabled()) {
            for (String value : validTopographies) {
                logger.trace("init() - Topography: " + value);
            }
        }
        RangeProducer rangeProducer = new RangeProducer();
        ArrayList<DataRecordCSV> expandedList = new ArrayList<DataRecordCSV>();
        for (DataRecordCSV record : list) {
            String value = record.getValue(3);
            int topoDigits = value.length();
            if (value.contains("C") && topoDigits == 3) {
                boolean debug = false;
                if (debug) {
                    logger.info("getExpandedGroupsList() - >>> INPUT_RECORD : " + String.valueOf(record));
                    logger.info("getExpandedGroupsList() - Topography       : " + value + " (" + topoDigits + " digits)");
                }
                String start = value + "0";
                String end = value + "9";
                List<String> range = rangeProducer.getRangeAsList(start, end);
                range.retainAll(validTopographies);
                for (int i = 0; i < range.size(); ++i) {
                    DataRecordCSV newRecord = (DataRecordCSV)record.clone();
                    newRecord.setValue(3, range.get(i));
                    expandedList.add(newRecord);
                    if (!debug) continue;
                    logger.info("getExpandedGroupsList() - Added record     : " + String.valueOf(newRecord));
                }
                continue;
            }
            expandedList.add(record);
        }
        return expandedList;
    }

    protected boolean loadUnspecifiedMorphologies() {
        this.unspecifiedMorphologies = null;
        Stream<String> morphologies_1 = Stream.of("8000", "8001", "8002", "8003", "8004", "8005");
        this.unspecifiedMorphologies = morphologies_1.collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            logger.trace("loadUnspecifiedMorphologies() - Loaded list of unspecified Morphologies: " + String.valueOf(this.unspecifiedMorphologies));
        }
        return !this.unspecifiedMorphologies.isEmpty();
    }

    protected boolean loadHematologicalMorphologies() {
        EquivalenceContext context = (EquivalenceContext)this.equivalenceContexts.get(2);
        Field morphology_field = this.ruleConfiguration.getFieldByPosition(4);
        int morphologFieldID = morphology_field.getId();
        if (logger.isDebugEnabled()) {
            logger.debug("loadHematologicalMorphologies() - Morphology field ID: " + morphologFieldID);
        }
        this.haematologicalMorphologies = context.getAllValues(morphologFieldID);
        if (this.haematologicalMorphologies == null) {
            logger.warn("loadHematologicalMorphologies() - Found null morphology set");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadHematologicalMorphologies() - Size of morphology set: " + this.haematologicalMorphologies.size());
        }
        if (logger.isTraceEnabled()) {
            logger.debug("loadHematologicalMorphologies() - List of all hematological morphologies:\n" + String.valueOf(this.haematologicalMorphologies));
        }
        if (logger.isTraceEnabled()) {
            logger.info("Hematological morphologies (UNSORTED):\n");
            for (String value : this.haematologicalMorphologies) {
                logger.info(value);
            }
        }
        if (logger.isTraceEnabled()) {
            List<String> sorted = this.sortCollection(this.haematologicalMorphologies);
            logger.info("Hematological morphologies (SORTED):\n");
            for (String value : sorted) {
                logger.info(value);
            }
        }
        return this.haematologicalMorphologies.size() > 0;
    }

    protected boolean loadExceptionsData(String basepath) {
        List<DataRecordCSV> topographyLaterality;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        String topographyLateralityFile = files.get(3).getFileName();
        if (logger.isTraceEnabled()) {
            logger.trace("loadExceptionsData() - Loading list of topography with laterality from path:\n" + basepath);
        }
        try {
            topographyLaterality = this.readCSVFile(basepath, topographyLateralityFile);
        }
        catch (MissingResourceException e) {
            logger.error("loadExceptionsData() - Configuration file not found: " + basepath + "/" + topographyLateralityFile);
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("loadExceptionsData() - Loaded list of topography with laterality values:\n" + this.getFormattedList(topographyLaterality));
        }
        this.topographyLateralityMap = new HashMap<String, Integer>();
        for (DataRecordCSV record : topographyLaterality) {
            int cellIndex = Integer.parseInt(record.getValue(0));
            this.topographyLateralityMap.put(record.getValue(1), cellIndex);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("loadExceptionsData() - Loaded topography laterality item: " + String.valueOf(record));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadExceptionsData() - Size of Topography-Laterality map: " + this.topographyLateralityMap.size());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("loadExceptionsData() - Loaded list of topography with laterality values: " + String.valueOf(this.topographyLateralityMap));
        }
        return true;
    }

    protected boolean loadTopographyGroups(String basepath) {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        String topographyGroupsFile = files.get(5).getFileName();
        if (logger.isTraceEnabled()) {
            logger.trace("loadTopographyGroups() - Loading definition of Topography groups from file:\n" + topographyGroupsFile);
            logger.trace("loadTopographyGroups() - Loading definition of Topography groups from path:\n" + basepath);
        }
        this.topographyGroups = new ArrayList<TopographyGroup>();
        List<Object> topographyGroupsRaw = new ArrayList();
        try {
            FileConnection fileConnection = new FileConnection(topographyGroupsFile, basepath);
            FileHandlerCSV<TopographyGroup> fileHandlerCSV = new FileHandlerCSV<TopographyGroup>(fileConnection, TopographyGroup.class);
            fileHandlerCSV.setHeader(true);
            topographyGroupsRaw = fileHandlerCSV.readFile();
        }
        catch (MissingResourceException e) {
            logger.error("loadTopographyGroups() - Configuration file not found: " + basepath + "/" + topographyGroupsFile);
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("loadTopographyGroups() - Loaded list of \"raw\" Topography groups: " + topographyGroupsRaw.size() + " lines");
        }
        for (TopographyGroup topographyGroup : topographyGroupsRaw) {
            List<TopographyGroup> expandedList = TopographyGroup.expandTopographies(topographyGroup);
            this.topographyGroups = Stream.concat(this.topographyGroups.stream(), expandedList.stream()).collect(Collectors.toList());
        }
        Collections.sort(this.topographyGroups);
        for (TopographyGroup topographyGroup : this.topographyGroups) {
            if (!logger.isTraceEnabled()) continue;
            logger.trace("loadTopographyGroups() - Expanded Topography group: " + String.valueOf(topographyGroup));
        }
        return true;
    }

    protected boolean loadFilteringData(String basepath) {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        List<LocalFile> files = ruleConfiguration.getConfigurationFiles();
        String fileName = files.get(4).getFileName();
        if (logger.isTraceEnabled()) {
            logger.trace("loadFilteringData() - Loading table of Behaviour conditions from file:\n" + fileName);
            logger.trace("loadFilteringData() - Loading table of Behaviour conditions from path:\n" + basepath);
        }
        try {
            FileConnection fileConnection = new FileConnection(fileName, basepath);
            FileHandlerCSV<FilterCondition> fileHandler = new FileHandlerCSV<FilterCondition>(fileConnection, FilterCondition.class);
            fileHandler.setHeader(true);
            this.behaviourTableRaw = fileHandler.readFile();
        }
        catch (MissingResourceException e) {
            logger.error("loadFilteringData() - Configuration file not found: " + basepath + "/" + fileName);
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("loadFilteringData() - Loaded list of filtering conditions: " + this.behaviourTableRaw.size() + " lines");
        }
        this.behaviourTable = new BehaviourTable();
        List<FilterCondition> allConditions = this.behaviourTable.expandFilterConditions(this.behaviourTableRaw);
        for (FilterCondition condition : allConditions) {
            condition.expandTopographies();
            if (!logger.isTraceEnabled()) continue;
            logger.trace("loadFilteringData() - Parsed condition: " + String.valueOf(condition));
        }
        if (logger.isInfoEnabled()) {
            logger.info("loadFilteringData() - Number of filtered conditions (expanded): " + allConditions.size());
        }
        return true;
    }

    @Override
    public boolean initAcceptableFile() {
        this.acceptanceCriterion = Configuration.getInstance().getIntegerProperty(Property.MPMT_CRITERION);
        this.enableInstrumentation = false;
        if (this.acceptanceCriterion < 1 || this.acceptanceCriterion > 5) {
            this.acceptanceCriterion = 2;
            if (logger.isWarnEnabled()) {
                logger.warn("Primary Duplicate wrong acceptance criterion: " + this.acceptanceCriterion + " -> Setting default value: " + this.acceptanceCriterion);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Primary Duplicate acceptance criterion   : " + this.acceptanceCriterion);
        }
        return super.initAcceptableFile();
    }

    @Override
    public boolean isAcceptableRecord(List<RuleOutput> issues) {
        if (logger.isTraceEnabled()) {
            logger.trace("isAcceptableRecord() - Using acceptance criterion: " + this.acceptanceCriterion);
        }
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field patientIDField = ruleConfiguration.getFieldByPosition(1);
        boolean validPatientID = this.isValidField(patientIDField);
        Field tumourIDField = ruleConfiguration.getFieldByPosition(2);
        String patientID = this.getFieldValue(this.acceptingRecord, patientIDField);
        String tumourID = this.getFieldValue(this.acceptingRecord, tumourIDField);
        String recordLabel = "[" + patientID + "-" + tumourID + "]";
        if (this.isDebugEnabled(10)) {
            logger.debug("");
            logger.debug("isAcceptableRecord() - Checking patient: " + recordLabel);
        }
        if (!validPatientID) {
            if (logger.isDebugEnabled()) {
                logger.debug("isAcceptableRecord() - Discarded record with invalid patient ID: " + recordLabel);
            }
            return false;
        }
        if (this.isDebugEnabled(10)) {
            logger.debug("isAcceptableRecord() - Apply criterion : " + this.acceptanceCriterion + " on " + recordLabel);
            logger.debug("isAcceptableRecord() - Record's issues : " + RuleOutput.printShortList(issues));
        }
        switch (this.acceptanceCriterion) {
            case 1: {
                return super.isAcceptableRecord(issues);
            }
            case 2: {
                return this.acceptAllExceptWrongMorphology(issues);
            }
            case 3: {
                return this.acceptAllExceptSomeErrors(issues);
            }
        }
        return false;
    }

    protected boolean acceptAllExceptWrongMorphology(List<RuleOutput> issues) {
        Field patientIDField = this.ruleConfiguration.getFieldByPosition(1);
        String patientID = this.getFieldValue(this.acceptingRecord, patientIDField);
        boolean superAcceptance = super.isAcceptableRecord(issues);
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptWrongMorphology() - Record " + patientID + " passed super criterion ? " + superAcceptance);
        }
        if (superAcceptance) {
            return true;
        }
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptWrongMorphology() - Applying custom criterion on record " + patientID);
        }
        boolean isValid = this.isValidField(morphology_field);
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptWrongMorphology() - Applied custom criterion on record " + patientID + " -> result : " + isValid);
        }
        return isValid;
    }

    protected boolean acceptAllExceptSomeErrors(List<RuleOutput> issues) {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        Field patientIDField = ruleConfiguration.getFieldByPosition(1);
        String patientID = this.getFieldValue(this.acceptingRecord, patientIDField);
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptSomeErrors() - Applying custom criteria on record " + patientID);
        }
        if (!this.isValidField(topography_field)) {
            return false;
        }
        if (!this.isValidField(morphology_field)) {
            return false;
        }
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptSomeErrors() - Applied Topo Morpho criteria on record " + patientID);
        }
        if (this.previousOutputContainsRule(DefaultRuleID.SEX_TOPOGRAPHY.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.AGE_BIRTH_INCIDENCE_1.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.AGE_BIRTH_INCIDENCE_2.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.DATE_BIRTH_INCIDENCE_1.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.AGE_TUMOUR_H1.id)) {
            return false;
        }
        if (this.previousOutputContainsRule(DefaultRuleID.MORPHOLOGY_TOPOGRAPHY.id)) {
            return false;
        }
        if (this.isDebugEnabledForCurrentBunch(10)) {
            logger.debug("acceptAllExceptSomeErrors() - Applied all minor criteria on record " + patientID);
        }
        return true;
    }

    protected boolean acceptWarningOrWrongTopography(List<RuleOutput> issues) {
        if (super.isAcceptableRecord(issues)) {
            return true;
        }
        int errors = 0;
        RuleOutputDetail ruleOutputDetail = null;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topograpy_field = ruleConfiguration.getFieldByPosition(3);
        for (RuleOutput ruleOutput : issues) {
            MessageType messageType = ruleOutput.getMessageType();
            if (MessageType.ERROR == messageType) {
                ++errors;
            }
            if (this.isValidField(topograpy_field)) continue;
            List<RuleOutputDetail> details = ruleOutput.getAllRuleOutputDetail();
            for (RuleOutputDetail detail : details) {
                if (detail.getFieldID() != topograpy_field.getId()) continue;
                ruleOutputDetail = detail;
            }
        }
        if (errors == 1 && ruleOutputDetail != null) {
            if (logger.isInfoEnabled()) {
                logger.info("isAcceptableRecord() - Accepting issue: " + String.valueOf(ruleOutputDetail));
            }
            return true;
        }
        return false;
    }

    @Override
    public List<RuleOutput> applyCheck() {
        Field patientID_field = this.prepareCheck();
        RuleConfiguration ruleConfig = this.getRuleConfiguration();
        SchemaView schemaView = ruleConfig.getTargetSchemaView();
        int patientIDPosition = schemaView.getFieldPosition(patientID_field.getId());
        int keyIndex = patientIDPosition - 1;
        String prefix = this.getClassName() + " - applyCheck() - ";
        if (logger.isDebugEnabled()) {
            logger.debug(prefix + this.getModelName() + " (ruleID=" + this.getId() + ")");
            logger.debug(prefix + "Reading bunch on column's index " + keyIndex);
        }
        int counter = 0;
        while (this.dataSetReader.hasNext()) {
            List<CrossRecordMatch> duplicatesInBunch;
            Map<String, List<CrossRecordMatch>> duplicatesByEquivalence;
            boolean debug_exceptions;
            this.bunch = this.dataSetReader.getNextBunch(keyIndex);
            if (this.bunch == null || this.bunch.isEmpty()) {
                if (!logger.isInfoEnabled()) break;
                logger.info(prefix + "Found empty bunch -> stopping check");
                break;
            }
            DataRecord firstRecord = (DataRecord)this.bunch.get(0);
            String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
            String recordPrimaryKey = this.getPrimaryKeyBySchemaPerspective(firstRecord);
            this.setBunchID(mainRecordID);
            boolean bl = debug_exceptions = this.isDebugEnabledForCurrentBunch(8) || this.isDebugEnabledForCurrentBunch(4) || this.isDebugEnabledForCurrentBunch(5) || this.isDebugEnabledForCurrentBunch(6) || this.isDebugEnabledForCurrentBunch(7);
            if (this.isDebugEnabled(1)) {
                logger.debug(prefix + "Main recordID " + mainRecordID + " -> Fetched bunch with " + this.bunch.size() + " records");
                if (this.isDebugEnabledForCurrentBunch(1)) {
                    for (DataRecord record : this.bunch) {
                        logger.debug(prefix + this.getPrimaryKeyBySchemaPerspective(record));
                    }
                }
            }
            if ((duplicatesByEquivalence = this.groupByEquivalence(duplicatesInBunch = this.checkBunchOfRecords(this.bunch))) == null || duplicatesByEquivalence.isEmpty()) continue;
            if (debug_exceptions) {
                logger.debug("");
                logger.debug(prefix + "looping_over " + duplicatesByEquivalence.size() + " reasons for record: " + recordPrimaryKey);
            }
            this.initSecondaryIDs();
            int reasonIndex = 1;
            for (String key : duplicatesByEquivalence.keySet()) {
                if (debug_exceptions || this.isDebugEnabledForCurrentBunch(9)) {
                    logger.debug("");
                    logger.debug(prefix + "RECORD_ID: " + this.getBunchID());
                    logger.debug(prefix + "EQUIVALENCE_REASON #" + reasonIndex++ + " >>> " + key);
                }
                List<CrossRecordMatch> allCrossRecordMatches = duplicatesByEquivalence.get(key);
                boolean matchedException = this.filterENCRExceptions(allCrossRecordMatches, this.strictCheck);
                this.storeRecordsByEquivalenceReasons(key, allCrossRecordMatches, matchedException);
            }
            boolean equivalenceIntersection = this.hasSharedSecondaryIDs();
            if (this.isDebugEnabledForCurrentBunch(9)) {
                logger.debug("");
                logger.debug(prefix + "AFTER_EXCEPTIONS for ALL_REASONS");
                logger.debug(prefix + "Set of secondary IDs (whole bunch)   : " + String.valueOf(this.getSecondaryIDs()));
                logger.debug(prefix + "Map of secondary IDs (whole bunch)   : " + String.valueOf(this.getEquivalenceDataByReason()));
                logger.debug(prefix + "Intersection among all sub-bunches   ? " + equivalenceIntersection);
            }
            if (equivalenceIntersection) {
                if (this.strictCheck) {
                    if (this.isDebugEnabledForCurrentBunch(9)) {
                        logger.debug(prefix + "Strict: merging items in sub-bunch   : " + String.valueOf(duplicatesInBunch));
                    }
                    this.mergeCrossRecordMatches(duplicatesInBunch);
                    if (this.isDebugEnabledForCurrentBunch(9)) {
                        logger.debug(prefix + "Strict: merged items in sub-bunch    : " + this.getBunchID());
                    }
                } else {
                    if (this.isDebugEnabledForCurrentBunch(9)) {
                        logger.debug(prefix + "Soft: removing item in sub-bunch     : " + String.valueOf(duplicatesInBunch));
                    }
                    for (CrossRecordMatch crossRecordMatch : duplicatesInBunch) {
                        this.removeCrossRecordMatch(crossRecordMatch);
                        if (!this.isDebugEnabledForCurrentBunch(9)) continue;
                        logger.debug(prefix + "Soft: removed item in sub-bunch  : " + crossRecordMatch.getPrimaryKey());
                    }
                }
            }
            if (this.isDebugEnabledForCurrentBunch(9)) {
                logger.debug(prefix + "Final duplicates after exceptions    : " + String.valueOf(this.crossRecordMatches));
            }
            if (!this.enableInstrumentation || ++counter % 50000 != 0) continue;
            this.logMemoryStatus(counter);
        }
        int matched = this.crossRecordMatches != null ? this.crossRecordMatches.size() : 0;
        logger.debug("");
        logger.debug(prefix + "Primary duplicates output: (found " + matched + " \"raw\" duplicates)");
        logger.debug("");
        List<RuleOutput> duplicates = this.filterCrossRecordMatches();
        return duplicates;
    }

    protected Field prepareCheck() {
        ValidationEngine engine = this.getValidationEngine();
        String errorCode = this.getRuleDefinition().getValidationMessage().getCode();
        String suffix = " (" + errorCode + ")";
        RuleConfiguration ruleConfig = this.getRuleConfiguration();
        Field patientID_field = ruleConfig.getFieldByPosition(1);
        String columnToOrder = patientID_field.getName();
        ExternalSorter sorter = new ExternalSorter(this.workingDirectory);
        sorter.setAddLineNumber(false);
        engine.notifyMessageToWorker("\nSorting file for primary duplicates" + suffix);
        if (logger.isInfoEnabled()) {
            logger.info("prepareCheck() - Valid records file: " + this.acceptableRecordsFullName);
        }
        long startTime = System.currentTimeMillis();
        String orderedFileName = sorter.sortFile(this.acceptableRecordsFullName, columnToOrder);
        long endTime = System.currentTimeMillis();
        engine.notifyMessageToWorker("Sorted file for primary duplicates" + suffix);
        if (logger.isInfoEnabled()) {
            logger.info("prepareCheck() - Sorted file \"" + orderedFileName + "\" in " + (endTime - startTime) + " ms");
        }
        this.dataSetReader = new DataSetReader();
        this.dataSetReader.setMaxRows(0);
        this.dataSetReader.setFilePath(orderedFileName);
        this.dataSetReader.resetDataset();
        if (logger.isDebugEnabled()) {
            logger.debug("prepareCheck() - DataSetReader: " + String.valueOf(this.dataSetReader));
        }
        this.crossRecordMatches = new ArrayList();
        return patientID_field;
    }

    protected List<RuleOutput> filterCrossRecordMatches() {
        RuleConfiguration ruleConfig = this.getRuleConfiguration();
        SchemaView schemaView = ruleConfig.getTargetSchemaView();
        boolean printMatchInfo = Configuration.getInstance().getBooleanProperty(Property.MPMT_MATCH_INFO);
        HashSet<String> set = new HashSet<String>();
        ArrayList<RuleOutput> duplicates = new ArrayList<RuleOutput>();
        int lineIndex = schemaView.getNumberOfFields();
        if (logger.isDebugEnabled()) {
            logger.debug("filterCrossRecordMatches() - Index of original line number : " + lineIndex);
        }
        for (CrossRecordMatch crossRecordMatch : this.crossRecordMatches) {
            String primaryKey = crossRecordMatch.getPrimaryKey();
            if (logger.isTraceEnabled()) {
                logger.trace("filterCrossRecordMatches() - CrossRecordMatch: " + crossRecordMatch.toString());
            }
            if (!set.add(primaryKey)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("filterCrossRecordMatches() - CrossRecordMatch: " + crossRecordMatch.toString());
            }
            RuleOutput ruleOutput = null;
            CandidateRecord record = crossRecordMatch.getFirstRecord();
            ruleOutput = printMatchInfo ? this.produceRichRuleOutput(crossRecordMatch) : this.produceRuleOutput(record);
            String lineNumber = ((DataRecord)record).getValue(lineIndex);
            ruleOutput.setLineNumber(lineNumber);
            duplicates.add(ruleOutput);
            this.addMatchedRecord(record);
            if (this.validationEngine.isSaveReferenceData()) {
                this.addReferenceData(ruleOutput, record);
            }
            if (!this.isDebugEnabled(13)) continue;
            logger.debug("filterCrossRecordMatches() - CrossRecordMatch unique record: " + String.valueOf(record));
        }
        if (this.isDebugEnabled(13)) {
            int matched = duplicates != null ? duplicates.size() : 0;
            logger.debug("");
            logger.debug("filterCrossRecordMatches() - Primary duplicates output: (filtered " + matched + " \"unique\" duplicates)");
            logger.debug("");
            logger.debug("List of all RuleOutput items");
            logger.debug("----------------------------");
            for (RuleOutput output : duplicates) {
                logger.debug("filterCrossRecordMatches() - RuleOutput : " + String.valueOf(output));
            }
            logger.debug("");
        }
        return duplicates;
    }

    protected void storeRecordsByEquivalenceReasons(String key, List<CrossRecordMatch> matches, boolean exception) {
        String prefix = this.getClassName() + " - storeRecordsByEquivalenceReasons() - ";
        HashSet<String> secondaryIDs = new HashSet<String>();
        for (CrossRecordMatch crossRecordMatch : matches) {
            secondaryIDs.add(crossRecordMatch.getSecondaryKey());
        }
        if (!secondaryIDs.isEmpty()) {
            int typeId = exception ? 1 : 2;
            this.addSecondaryID(key, typeId, secondaryIDs);
        }
        if (this.isDebugEnabledForCurrentBunch(9)) {
            logger.debug("");
            logger.debug(prefix + "AFTER_EXCEPTIONS for record     : " + this.getBunchID());
            logger.debug(prefix + "Equivalence reason              : " + key);
            logger.debug(prefix + "Number of matches in sub-bunch  : " + matches.size());
            logger.debug(prefix + "Exceptions \"strict\" flag        : " + (this.strictCheck ? "STRICT" : "SOFT"));
            logger.debug(prefix + "Mached exception                ? " + exception);
            logger.debug(prefix + "Secondary IDs (sub bunch)       : " + String.valueOf(secondaryIDs));
            logger.debug(prefix + "Secondary IDs (class set)       : " + String.valueOf(this.secondaryIDs));
            logger.debug(prefix + "Secondary IDs (class map)       : " + String.valueOf(this.secondaryIDsByReason));
        }
    }

    protected boolean filterENCRExceptions(List<CrossRecordMatch> allMatchesWithSameReason, boolean strict) {
        boolean debug;
        DataRecord firstRecord = (DataRecord)this.bunch.get(0);
        String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
        String prefix = this.getClassName() + " - filterENCRExceptions() - ";
        if (allMatchesWithSameReason == null || allMatchesWithSameReason.isEmpty()) {
            if (this.isDebugEnabledForCurrentBunch(2)) {
                logger.debug(prefix + "No duplicates in current bunch: returning");
            }
            return false;
        }
        boolean debug_filter = this.isDebugEnabledForCurrentBunch(2);
        boolean debug_exceptions = this.isDebugEnabledForCurrentBunch(8) || this.isDebugEnabledForCurrentBunch(4) || this.isDebugEnabledForCurrentBunch(5) || this.isDebugEnabledForCurrentBunch(6) || this.isDebugEnabledForCurrentBunch(7);
        boolean after_exceptions = this.isDebugEnabledForCurrentBunch(9);
        if (logger.isTraceEnabled()) {
            logger.trace("Debug flags: " + debug_exceptions + "," + after_exceptions);
        }
        if (debug = debug_filter) {
            logger.debug("");
            logger.debug("--------------------------------------------------------");
            logger.debug(prefix + "Analysing bunch for recordID      : " + mainRecordID);
            logger.debug(prefix + "Number of matches in sub-bunch    : " + allMatchesWithSameReason.size());
            logger.debug(prefix + "Exceptions \"strict\" flag          : " + (strict ? "STRICT" : "SOFT"));
            for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
                logger.debug(prefix + "CrossRecordMatch                  : " + String.valueOf(crossRecordMatch));
            }
        }
        boolean matchedException = false;
        boolean hasUnspecifiedMorphology = false;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
            CandidateRecord record = crossRecordMatch.getFirstRecord();
            String morphology = this.getFieldValue((DataRecord)record, morphology_field);
            if (!this.unspecifiedMorphologies.contains(morphology)) continue;
            hasUnspecifiedMorphology = true;
            break;
        }
        if (debug) {
            logger.debug(prefix + "Contains unspecified morphology   ? " + hasUnspecifiedMorphology);
        }
        if (debug) {
            logger.debug("");
            logger.debug(prefix + "Cross Record Match Info:");
        }
        boolean matchedException_1 = this.checkException_1(allMatchesWithSameReason);
        boolean matchedException_2 = this.checkException_2(allMatchesWithSameReason);
        boolean matchedException_3 = this.checkException_3(allMatchesWithSameReason);
        boolean matchedException_4 = this.checkException_4(allMatchesWithSameReason);
        boolean bl = matchedException = matchedException_1 || matchedException_2 || matchedException_3 || matchedException_4;
        if (debug) {
            Object exceptions = (matchedException_1 ? "1, " : "") + (matchedException_2 ? "2, " : "") + (matchedException_3 ? "3, " : "") + (matchedException_4 ? "4 " : "");
            if (((String)exceptions).length() <= 1) {
                exceptions = "none";
            }
            logger.debug("");
            logger.debug(prefix + "Does the sub-bunch match any exception  ? " + matchedException);
            logger.debug(prefix + "IDs of all matched exceptions           : " + (String)exceptions);
        }
        if (hasUnspecifiedMorphology) {
            matchedException = false;
            if (debug) {
                logger.debug(prefix + "Found unspecified morphology -> forcing NO exception behavior");
            }
        }
        if (debug) {
            logger.debug(prefix + "Initial number of \"CrossRecordMatches\"  : " + this.crossRecordMatches.size());
        }
        if (!strict) {
            if (!matchedException) {
                if (debug) {
                    logger.debug("");
                    logger.debug(prefix + "SOFT - Removing all W-MPCR duplicates from sub-bunch of \"CrossRecordMatch\" items. Matches size: " + allMatchesWithSameReason.size());
                }
                for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
                    this.removeCrossRecordMatch(crossRecordMatch);
                    if (!debug) continue;
                    logger.debug(prefix + "SOFT - Removed following W-MPCR possible duplicates from list of \"CrossRecordMatch\" items: " + String.valueOf(crossRecordMatch));
                    logger.debug(prefix + "SOFT - Duplicates size (after removal): " + allMatchesWithSameReason.size());
                }
            } else if (debug) {
                logger.debug(prefix + "SOFT - Bunch did match at least an exception -> nothing to do ");
            }
        }
        if (strict) {
            if (matchedException) {
                if (debug) {
                    logger.debug("");
                    logger.debug(prefix + "STRICT - Removing all W-MPMT duplicates from sub-bunch of \"CrossRecordMatch\" items. Matches size: " + allMatchesWithSameReason.size());
                }
                for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
                    this.removeCrossRecordMatch(crossRecordMatch);
                    if (!debug) continue;
                    logger.debug(prefix + "STRICT - Removed following W-MPMT possible duplicates from list of \"CrossRecordMatch\" items: " + String.valueOf(crossRecordMatch));
                    logger.debug(prefix + "STRICT - Duplicates size (after removal): " + allMatchesWithSameReason.size());
                }
            } else if (debug) {
                logger.debug(prefix + "STRICT - Bunch did NOT match at least one exception -> nothing to do ");
            }
        }
        if (debug) {
            logger.debug(prefix + "Filtered number of \"CrossRecordMatches\" : " + this.crossRecordMatches.size());
        }
        return matchedException;
    }

    protected boolean checkHaematological(CandidateRecord record) {
        String morphology;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        String recordPrimaryKey = this.getPrimaryKeyBySchemaPerspective(record);
        String prefix = this.getClassName() + " - checkHaematological() - ";
        boolean debug_exceptions = this.isDebugEnabledForCurrentBunch(8);
        if (debug_exceptions) {
            logger.debug(prefix + "Analysing candidate record: " + recordPrimaryKey);
        }
        if (this.haematologicalMorphologies.contains(morphology = this.getFieldValue((DataRecord)record, morphology_field))) {
            if (debug_exceptions) {
                logger.info(prefix + "Found haema_morphology: " + recordPrimaryKey);
            }
            return true;
        }
        if (debug_exceptions) {
            logger.info(prefix + "NO haema_morphology : " + recordPrimaryKey);
        }
        return false;
    }

    protected boolean checkException_1(List<CrossRecordMatch> allMatchesWithSameReason) {
        boolean matchesException;
        boolean debug;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(5);
        DataRecord firstRecord = (DataRecord)this.bunch.get(0);
        String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
        String recordPrimaryKey = this.getPrimaryKeyBySchemaPerspective(firstRecord);
        String prefix = this.getClassName() + " - checkException_1() - ";
        if (this.topographyLateralityMap == null || this.topographyLateralityMap.isEmpty()) {
            logger.error(prefix + "Found null Topography-Laterality map -> exiting");
        }
        if (logger.isTraceEnabled()) {
            logger.trace(prefix + "Using topography laterality map: " + String.valueOf(this.topographyLateralityMap));
        }
        int[] topographiesInSameCell = new int[this.topographyLateralityMap.size()];
        boolean condition_1 = false;
        boolean condition_2 = true;
        boolean condition_3 = true;
        boolean urological = false;
        HashMap<CallSite, Integer> sameFirstDigitSameBeh = new HashMap<CallSite, Integer>();
        boolean bl = debug = this.isDebugEnabledForCurrentBunch(8) || this.isDebugEnabledForCurrentBunch(4);
        if (debug) {
            logger.debug("");
            logger.debug(prefix + "EXCEPTION_1: checking all duplicates for patient: " + mainRecordID);
        }
        HashSet<String> checkedPrimaryKeys = new HashSet<String>();
        for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
            String shortTopo;
            String mapKey;
            Integer howMany;
            boolean isHaematological;
            CandidateRecord record = crossRecordMatch.getFirstRecord();
            String duplicatePrimaryKey = this.getPrimaryKeyBySchemaPerspective(record);
            if (!checkedPrimaryKeys.add(duplicatePrimaryKey)) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace(prefix + "Skipping record (already analyzed): " + duplicatePrimaryKey);
                continue;
            }
            String topography = this.getFieldValue((DataRecord)record, topography_field);
            String behaviour = this.getFieldValue((DataRecord)record, behaviour_field);
            if (debug) {
                logger.debug("");
                logger.debug(prefix + "Primary_key: " + duplicatePrimaryKey + " -> topography = " + topography);
            }
            if (isHaematological = this.checkHaematological(record)) {
                if (!debug) continue;
                logger.debug(prefix + "Ignoring haematological record: " + recordPrimaryKey);
                continue;
            }
            if (debug) {
                logger.debug(prefix + "Checking all conditions:");
            }
            if (this.topographyLateralityMap.containsKey(topography)) {
                int cellIndex;
                int n = cellIndex = this.topographyLateralityMap.get(topography).intValue();
                topographiesInSameCell[n] = topographiesInSameCell[n] + 1;
                if (debug) {
                    logger.debug(prefix + "Condition 1 - PatientID: " + mainRecordID + "'s topography (" + topography + ") in_cell " + cellIndex);
                }
            }
            if (debug) {
                logger.debug(prefix + "Condition 1 - PatientID: " + mainRecordID + " topographies_same_cell:  " + Arrays.toString(topographiesInSameCell));
            }
            if (!urological) {
                boolean bl2 = urological = "C659".equalsIgnoreCase(topography) || "C669".equalsIgnoreCase(topography);
                if (debug) {
                    logger.debug(prefix + "Condition 1 - PatientID: " + mainRecordID + " found_urological:  " + topography);
                }
            }
            if ((howMany = (Integer)sameFirstDigitSameBeh.get(mapKey = (shortTopo = topography.substring(0, 3)) + "/" + behaviour)) == null) {
                sameFirstDigitSameBeh.put((CallSite)((Object)mapKey), 1);
            } else {
                howMany = howMany + 1;
                sameFirstDigitSameBeh.put((CallSite)((Object)mapKey), howMany);
            }
            if (debug) {
                logger.debug(prefix + "Condition 2 - PatientID: " + mainRecordID + " -> topography_map = " + mapKey + " -> " + String.valueOf(sameFirstDigitSameBeh.get(mapKey)) + " items");
            }
            if (condition_3) {
                boolean bl3 = condition_3 = !"C809".equalsIgnoreCase(topography) && !"C768".equalsIgnoreCase(topography);
            }
            if (!debug) continue;
            logger.debug(prefix + "Condition 3 - PatientID: " + mainRecordID + " -> containsC809orC768 = " + condition_3);
        }
        for (int index = 0; index < topographiesInSameCell.length; ++index) {
            if (topographiesInSameCell[index] > 0 && debug) {
                logger.debug(prefix + "PatientID: " + mainRecordID + " -> Records in_same_cell[" + index + "] : " + topographiesInSameCell[index]);
            }
            if (topographiesInSameCell[index] < 2) continue;
            condition_1 = true;
            break;
        }
        if (!urological) {
            for (Map.Entry entry : sameFirstDigitSameBeh.entrySet()) {
                int howMany = (Integer)entry.getValue();
                if (howMany == 2) {
                    condition_2 = true;
                    continue;
                }
                if (howMany <= 2) continue;
                condition_2 = false;
                break;
            }
        } else {
            condition_2 = true;
            if (debug) {
                logger.debug(prefix + "PatientID: " + mainRecordID + " -> skip_condition_2, because of pre-condition");
            }
        }
        boolean bl4 = matchesException = condition_1 && condition_2 && condition_3;
        if (debug) {
            logger.debug(prefix + "Analysed sub-bunch for recordID                 : " + mainRecordID + " (" + allMatchesWithSameReason.size() + " records)");
            logger.debug(prefix + "At least 2 records in same cell (Table 2)       : " + condition_1);
            logger.debug(prefix + "Condition 2 always true (C659, C669)            ? " + urological);
            logger.debug(prefix + "Number of records with same 3 first digits      : " + String.valueOf(sameFirstDigitSameBeh));
            logger.debug(prefix + "No more than 2 records with same 3 first digits ? " + condition_2);
            logger.debug(prefix + "No records with topo C809_OR_C768               ? " + condition_3);
            logger.debug(prefix + "Does bunch match Exception_1                    ? " + matchesException);
        }
        return matchesException;
    }

    protected boolean checkException_2(List<CrossRecordMatch> allMatchesWithSameReason) {
        boolean matchesException;
        boolean debug;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        DataRecord firstRecord = (DataRecord)this.bunch.get(0);
        String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
        String recordPrimaryKey = this.getPrimaryKeyBySchemaPerspective(firstRecord);
        String prefix = this.getClassName() + " - checkException_2() - ";
        String[] topoArrayCondition_2 = new String[]{"C188", "C189", "C260", "C268", "C269", "C762", "C768", "C809"};
        HashSet<String> topoSetCondition_2 = new HashSet<String>(Arrays.asList(topoArrayCondition_2));
        int recordsInCondition_1 = 0;
        boolean recordInCondition_2 = false;
        boolean duplicatesInCondition_3 = false;
        HashSet<String> candidateDuplicates = new HashSet<String>();
        boolean bl = debug = this.isDebugEnabledForCurrentBunch(8) || this.isDebugEnabledForCurrentBunch(5);
        if (debug) {
            logger.debug("");
            logger.debug(prefix + "EXCEPTION_2: checking all duplicates for patient: " + mainRecordID);
        }
        HashSet<String> alreadyCheckedPrimaryKeys = new HashSet<String>();
        for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
            CandidateRecord record = crossRecordMatch.getFirstRecord();
            String topography = this.getFieldValue((DataRecord)record, topography_field);
            String duplicatePrimaryKey = this.getPrimaryKeyBySchemaPerspective(record);
            if (debug) {
                logger.debug("");
                logger.debug(prefix + "Primary key: " + duplicatePrimaryKey + " -> topography = " + topography);
            }
            if (!alreadyCheckedPrimaryKeys.add(duplicatePrimaryKey)) {
                if (!debug) continue;
                logger.debug(prefix + "SKIPPING: " + duplicatePrimaryKey + " -> topography = " + topography);
                continue;
            }
            boolean isHaematological = this.checkHaematological(record);
            if (isHaematological) {
                if (!debug) continue;
                logger.debug(prefix + "Ignoring haematological record: " + recordPrimaryKey);
                continue;
            }
            if (debug) {
                logger.debug(prefix + "Checking all conditions:");
            }
            boolean currentTopoInCondition_1 = false;
            String shortTopo = topography.substring(0, 3);
            if ("C18".equalsIgnoreCase(shortTopo)) {
                char topoSuffix = topography.charAt(3);
                int suffix = this.parseIntegerValue(topoSuffix);
                boolean bl2 = currentTopoInCondition_1 = suffix >= 0 && suffix <= 7;
                if (currentTopoInCondition_1) {
                    ++recordsInCondition_1;
                    if (debug) {
                        logger.debug(prefix + "Number of records within C180-C187: " + recordsInCondition_1);
                    }
                }
            }
            if (!recordInCondition_2) {
                recordInCondition_2 = topoSetCondition_2.contains(topography);
                if (debug) {
                    if (recordInCondition_2) {
                        logger.debug(prefix + "Found topography in \"forbidden\" set        : " + topography);
                    } else {
                        logger.debug(prefix + "No topography in \"forbidden\" set");
                    }
                }
            }
            if (duplicatesInCondition_3 || !currentTopoInCondition_1) continue;
            duplicatesInCondition_3 = !candidateDuplicates.add(topography);
        }
        boolean bl3 = matchesException = recordsInCondition_1 > 1 && !recordInCondition_2 && !duplicatesInCondition_3;
        if (debug) {
            logger.debug(prefix + "Analysed sub-bunch for recordID            : " + mainRecordID + " (" + allMatchesWithSameReason.size() + " records)");
            logger.debug(prefix + "Number of records with topo in C180-C187   : " + recordsInCondition_1);
            logger.debug(prefix + "Found topography in \"forbidden\" set        ? " + recordInCondition_2);
            logger.debug(prefix + "Duplicate topographies in in C180-C187     : " + duplicatesInCondition_3);
            logger.debug(prefix + "Does bunch match Exception_2               ? " + matchesException);
        }
        return matchesException;
    }

    protected boolean checkException_3(List<CrossRecordMatch> allMatchesWithSameReason) {
        boolean matchesException;
        boolean debug;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        DataRecord firstRecord = (DataRecord)this.bunch.get(0);
        String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
        String recordPrimaryKey = this.getPrimaryKeyBySchemaPerspective(firstRecord);
        String prefix = this.getClassName() + " - checkException_3() - ";
        String[] topoArrayCondition_2 = new String[]{"C448", "C449", "C760", "C761", "C762", "C763", "C764", "C765", "C766", "C767", "C768", "C809"};
        HashSet<String> topoSetCondition_2 = new HashSet<String>(Arrays.asList(topoArrayCondition_2));
        int recordsInCondition_1 = 0;
        boolean recordInCondition_2 = false;
        boolean duplicatesInCondition_3 = false;
        HashSet<String> candidateDuplicatesInCondition_3 = new HashSet<String>();
        HashSet<String> alreadyCheckedPrimaryKeys = new HashSet<String>();
        boolean bl = debug = this.isDebugEnabledForCurrentBunch(8) || this.isDebugEnabledForCurrentBunch(6);
        if (debug) {
            logger.debug("");
            logger.debug(prefix + "EXCEPTION_3: checking all duplicates for patient: " + mainRecordID);
        }
        for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
            boolean topoInForbiddenSet;
            char topoSuffix;
            int suffix;
            String shortTopo;
            CandidateRecord record = crossRecordMatch.getFirstRecord();
            String topography = this.getFieldValue((DataRecord)record, topography_field);
            String duplicatePrimaryKey = this.getPrimaryKeyBySchemaPerspective(record);
            if (debug) {
                logger.debug("");
                logger.debug(prefix + "Primary key: " + duplicatePrimaryKey + " -> topography = " + topography);
            }
            if (!alreadyCheckedPrimaryKeys.add(duplicatePrimaryKey)) {
                if (!debug) continue;
                logger.debug(prefix + "SKIPPING: " + duplicatePrimaryKey + " -> topography = " + topography);
                continue;
            }
            boolean isHaematological = this.checkHaematological(record);
            if (isHaematological) {
                if (!debug) continue;
                logger.debug(prefix + "Ignoring haematological record: " + recordPrimaryKey);
                continue;
            }
            if (debug) {
                logger.debug(prefix + "Checking all conditions:");
            }
            if ("C44".equalsIgnoreCase(shortTopo = topography.substring(0, 3)) && (suffix = this.parseIntegerValue(topoSuffix = topography.charAt(3))) >= 0 && suffix <= 7) {
                ++recordsInCondition_1;
                if (debug) {
                    logger.debug(prefix + "Number of records within C440-C447: " + recordsInCondition_1);
                }
            }
            if (!recordInCondition_2) {
                recordInCondition_2 = topoSetCondition_2.contains(topography);
                if (debug) {
                    logger.debug(prefix + "Found topography in \"forbidden\" set    : " + topography);
                }
            }
            if (duplicatesInCondition_3) continue;
            String topoDigits = topography.substring(1, 4);
            int topoAsInteger = Integer.parseInt(topoDigits);
            boolean bl2 = topoInForbiddenSet = topoAsInteger >= 440 && topoAsInteger <= 445;
            if (debug) {
                logger.debug(prefix + "Counting duplicates for : " + duplicatePrimaryKey + " -> topography = " + topography);
            }
            if (!topoInForbiddenSet && !"C448".equalsIgnoreCase(topography)) continue;
            boolean bl3 = duplicatesInCondition_3 = !candidateDuplicatesInCondition_3.add(topography);
            if (!debug) continue;
            logger.debug(prefix + "Found duplicates topography in (C440-C445, C448): " + topography);
        }
        boolean bl4 = matchesException = recordsInCondition_1 > 1 && !recordInCondition_2 && !duplicatesInCondition_3;
        if (debug) {
            logger.debug(prefix + "Analysed sub-bunch for recordID            : " + mainRecordID + " (" + allMatchesWithSameReason.size() + " records)");
            logger.debug(prefix + "Number of records with topo in C440-C447        : " + recordsInCondition_1);
            logger.debug(prefix + "Found topography in \"forbidden\" set             ? " + recordInCondition_2);
            logger.debug(prefix + "Duplicate topographies in in (C440-C445 | C448) : " + duplicatesInCondition_3);
            logger.debug(prefix + "Does bunch match Exception_3                    ? " + matchesException);
        }
        return matchesException;
    }

    protected boolean checkException_4(List<CrossRecordMatch> allMatchesWithSameReason) {
        boolean matchesException;
        boolean debug;
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        DataRecord firstRecord = (DataRecord)this.bunch.get(0);
        String mainRecordID = this.getMainKeyBySchemaPerspective(firstRecord);
        String prefix = this.getClassName() + " - checkException_4() - ";
        boolean bl = debug = this.isDebugEnabledForCurrentBunch(8) || this.isDebugEnabledForCurrentBunch(7);
        if (debug) {
            logger.debug("");
            logger.debug(prefix + "EXCEPTION_4: checking all duplicates for patient: " + mainRecordID);
        }
        boolean condition_2 = false;
        HashMap topographiesInGroup = new HashMap();
        TopographyGroup topographyGroup = TopographyGroup.UNDEF;
        HashSet<String> uniqueKeys = new HashSet<String>();
        HashSet<String> notInTopographyGroup = new HashSet<String>();
        for (CrossRecordMatch crossRecordMatch : allMatchesWithSameReason) {
            boolean isHaematological;
            CandidateRecord record = crossRecordMatch.getFirstRecord();
            String recordPrimaryKey = this.getPrimaryKeyBySchemaPerspective(record);
            if (debug) {
                logger.debug("");
                logger.debug(prefix + "Evaluating Exception_4 for record: " + (String)recordPrimaryKey);
            }
            if (isHaematological = this.checkHaematological(record)) {
                if (!debug) continue;
                logger.debug(prefix + "Ignoring haematological record: " + (String)recordPrimaryKey);
                continue;
            }
            String primaryKey = this.getPrimaryKeyBySchemaPerspective(record);
            if (uniqueKeys.add(primaryKey)) {
                if (logger.isTraceEnabled()) {
                    logger.trace(prefix + "Added primaryKey: " + primaryKey);
                }
            } else {
                if (!debug) continue;
                logger.debug(prefix + "Skipping duplicate key: " + primaryKey);
                continue;
            }
            String topography = this.getFieldValue((DataRecord)record, topography_field);
            int topographyInt = TopographyGroup.topographyParser.parseTopography(topography);
            if (debug) {
                String message = "Record " + primaryKey + ": parsed_topography = " + topography + " -> " + topographyInt;
                logger.debug(prefix + message);
            }
            if (this.getTopographyGroup(topographyInt) != TopographyGroup.UNDEF) {
                TopographyGroup currentTopographyGroup = this.getTopographyGroup(topographyInt);
                if (topographyGroup == TopographyGroup.UNDEF) {
                    topographyGroup = currentTopographyGroup;
                } else {
                    String newGroupCode;
                    String oldGroupCode = topographyGroup.getGroupCode();
                    if (!oldGroupCode.equalsIgnoreCase(newGroupCode = currentTopographyGroup.getGroupCode()) && logger.isWarnEnabled()) {
                        String message = "TopographyGroup changed from " + oldGroupCode + " to " + newGroupCode;
                        message = message + " : the algorithm will continue using the firt group. ";
                        logger.warn(prefix + message + " : please verify that this the wanted behaviuor");
                    }
                }
            }
            if (debug) {
                logger.debug(prefix + "Topography = " + topography + " in_topography_group: " + topographyGroup.getGroupCode());
            }
            if (topographyGroup == TopographyGroup.UNDEF) {
                notInTopographyGroup.add(topography);
                if (debug) {
                    logger.debug(prefix + "TopographyGroup has not been defined (it set to UNDEF)");
                    logger.debug(prefix + "List of topographies not in any group: " + String.valueOf(notInTopographyGroup));
                }
            }
            if (!topographyGroup.isAllowed(topography)) {
                condition_2 = true;
                if (!debug) break;
                logger.debug(prefix + "Topography not_allowed = " + topography);
                break;
            }
            for (String unmatchedTopo : notInTopographyGroup) {
                if (topographyGroup.isAllowed(unmatchedTopo)) continue;
                condition_2 = true;
                if (!debug) break;
                logger.debug(prefix + "Found an unmatched_topo that is not_allowed = " + unmatchedTopo);
                break;
            }
            if (topographyGroup != TopographyGroup.UNDEF) {
                List<String> list;
                String groupCode = topographyGroup.getGroupCode();
                if (debug) {
                    logger.debug(prefix + "Topography = " + topography + " in_group " + groupCode);
                }
                if (topographiesInGroup.containsKey(groupCode)) {
                    list = (List)topographiesInGroup.get(groupCode);
                    list.add(topography);
                } else {
                    list = new ArrayList();
                    list.add(topography);
                    topographiesInGroup.put(groupCode, list);
                }
                if (!debug) continue;
                list = (List)topographiesInGroup.get(groupCode);
                logger.debug(prefix + "Topography = " + topography + " -> group_code " + groupCode + " = " + list.size());
                continue;
            }
            if (!debug) continue;
            logger.debug(prefix + "Topography = " + topography + " not found in any Topography Group");
        }
        if (debug) {
            logger.debug("");
            logger.debug(prefix + "Cycled over whole sub-bunch, found topographiesInGroup : " + String.valueOf(topographiesInGroup.values()));
        }
        boolean condition_1 = false;
        int groupNumber = 0;
        HashSet<String> toposWithDifferent_3_Chars = new HashSet<String>();
        block2: for (List values : topographiesInGroup.values()) {
            if (debug) {
                logger.debug(prefix + "Checking topographies in group " + groupNumber++ + " -> values: " + String.valueOf(values));
            }
            for (String topography : values) {
                String topographyCut = topography.substring(0, 3);
                if (toposWithDifferent_3_Chars.add(topographyCut)) {
                    condition_1 = toposWithDifferent_3_Chars.size() > 1;
                    continue;
                }
                condition_1 = false;
                if (!debug) continue block2;
                logger.debug(prefix + "Found topographies starting with same first 3 digits: " + topography + " -> " + topographyCut);
                continue block2;
            }
        }
        boolean bl2 = matchesException = condition_1 && !condition_2;
        if (debug) {
            logger.debug("");
            logger.debug(prefix + "Summary for record: " + mainRecordID);
            logger.debug(prefix + "Does verify condition_1                      ? " + condition_1);
            logger.debug(prefix + "Does verify condition_2                      ? " + condition_2);
            logger.debug(prefix + "Does bunch match Exception_4                 ? " + matchesException);
        }
        return matchesException;
    }

    public TopographyGroup getTopographyGroup(int topography) {
        int low = 0;
        int high = this.topographyGroups.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            TopographyGroup group = this.topographyGroups.get(mid);
            if (group.getTopoStart() <= topography && topography <= group.getTopoEnd()) {
                return group;
            }
            if (group.getTopoStart() > topography) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return TopographyGroup.UNDEF;
    }

    @Override
    public boolean filterRecord(EquivalenceCriterion criterion, CandidateRecord candidateRecord) {
        if (this.behaviourTable == null) {
            String message = "BehaviourTable is null: wrong configuration?";
            logger.error("filterRecord() - " + message);
            return false;
        }
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(5);
        String topography = this.getFieldValue((DataRecord)candidateRecord, topography_field);
        String morphology = this.getFieldValue((DataRecord)candidateRecord, morphology_field);
        String behaviour = this.getFieldValue((DataRecord)candidateRecord, behaviour_field);
        String mainKey = this.getMainKeyBySchemaPerspective(candidateRecord);
        String primaryKey = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
        boolean debug = logger.isTraceEnabled();
        if (logger.isTraceEnabled()) {
            logger.trace("filterRecord() - checking_record " + primaryKey + " with behaviour = " + behaviour);
        }
        if (!this.isValidField(morphology_field)) {
            if (debug) {
                logger.info("filterRecord() - Invalid morphology  " + primaryKey + " -> discarted");
            }
            return false;
        }
        if (!"3".equals(behaviour)) {
            boolean isException = false;
            if (debug) {
                String recordData = "morhpo_beh = " + morphology + "/" + behaviour + " (topo= " + topography + ")";
                logger.info("filterRecord() - evaluating_record " + primaryKey + " with " + recordData);
            }
            if (this.behaviourTable != null) {
                FilterCondition condition = this.behaviourTable.getFilterCondition(mainKey, topography, morphology, behaviour);
                boolean bl = isException = condition != null;
                if (isException && debug) {
                    logger.info("filterRecord() - matched_condition: " + String.valueOf(condition));
                }
            } else {
                String message = "Null behaviour table: please check location of configuration file";
                logger.error("filterRecord() - " + message);
                return false;
            }
            if (!isException) {
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - discarted_record " + primaryKey + " because not listed in the behaviourTable");
                }
                return false;
            }
        }
        return super.filterRecord(criterion, candidateRecord);
    }

    public boolean filterRecord2023Bis(EquivalenceCriterion criterion, CandidateRecord candidateRecord) {
        RuleConfiguration ruleConfiguration = this.getRuleConfiguration();
        Field topography_field = ruleConfiguration.getFieldByPosition(3);
        Field morphology_field = ruleConfiguration.getFieldByPosition(4);
        Field behaviour_field = ruleConfiguration.getFieldByPosition(5);
        String topography = this.getFieldValue((DataRecord)candidateRecord, topography_field);
        String morphology = this.getFieldValue((DataRecord)candidateRecord, morphology_field);
        String behaviour = this.getFieldValue((DataRecord)candidateRecord, behaviour_field);
        if (!"3".equals(behaviour)) {
            boolean isException = false;
            String primaryKey = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
            if (topography == null || topography.length() <= 2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("filterRecord() - Skipping record because wrong topography: " + topography);
                }
                return false;
            }
            String topographyPrexix = topography.substring(0, 3);
            int morphologyNumber = 0;
            try {
                morphologyNumber = Integer.parseInt(morphology);
            }
            catch (NumberFormatException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("filterRecord() - Skipping record because wrong morphology: " + morphology);
                }
                return false;
            }
            if (this.isDebugEnabledForCurrentBunch(2)) {
                logger.debug("filterRecord() - Evaluating record " + primaryKey + " with: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
            }
            if (!(isException = this.filterRecord2023(candidateRecord, behaviour, topographyPrexix, morphologyNumber))) {
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - Discarding Record_" + primaryKey + " because behaviour is not 3 (Beh = " + behaviour + ")");
                }
                return false;
            }
        }
        return super.filterRecord(criterion, candidateRecord);
    }

    protected boolean filterRecord2023(CandidateRecord candidateRecord, String behaviour, String topographyPrexix, int morphologyNumber) {
        boolean solid;
        boolean isException = false;
        Field topography_field = this.ruleConfiguration.getFieldByPosition(3);
        String topography = this.getFieldValue((DataRecord)candidateRecord, topography_field);
        String primaryKey = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
        boolean urothelial = "C65".equals(topographyPrexix) || "C66".equals(topographyPrexix) || "C67".equals(topographyPrexix) || "C68".equals(topographyPrexix);
        boolean ovary = "C56".equals(topographyPrexix);
        boolean cns_1 = "C70".equals(topographyPrexix) || "C71".equals(topographyPrexix) || "C72".equals(topographyPrexix);
        boolean cns_2 = "C751".equals(topography) || "C752".equals(topography) || "C753".equals(topography);
        boolean cns = cns_1 || cns_2;
        boolean gist = morphologyNumber == 8935 || morphologyNumber == 8836;
        boolean bl = solid = morphologyNumber < 9590;
        if ("2".equals(behaviour)) {
            boolean inSitu;
            boolean breast = "C50".equals(topographyPrexix);
            boolean skinMelanoma = morphologyNumber >= 8720 & morphologyNumber <= 8790;
            boolean bl2 = inSitu = breast || urothelial || ovary || skinMelanoma;
            if (inSitu && solid) {
                isException = true;
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - IN SITU - Accepted " + primaryKey + " because: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
                }
            }
        }
        if ("1".equals(behaviour)) {
            boolean uncertain;
            boolean thymoma = morphologyNumber >= 8580 & morphologyNumber <= 8585;
            boolean gep_net_topo_1 = "C15".equals(topographyPrexix) || "C16".equals(topographyPrexix) || "C17".equals(topographyPrexix) || "C18".equals(topographyPrexix);
            boolean gep_net_topo_2 = "C19".equals(topographyPrexix) || "C20".equals(topographyPrexix) || "C21".equals(topographyPrexix) || "C22".equals(topographyPrexix);
            boolean gep_net_topo_3 = "C23".equals(topographyPrexix) || "C24".equals(topographyPrexix) || "C25".equals(topographyPrexix) || "C26".equals(topographyPrexix);
            boolean gep_net_topo = gep_net_topo_1 || gep_net_topo_2 || gep_net_topo_3;
            boolean gep_net_morpho_1 = morphologyNumber >= 8150 & morphologyNumber <= 8158;
            boolean gep_net_morpho_2 = morphologyNumber >= 8240 & morphologyNumber <= 8242;
            boolean gep_net_morpho_3 = morphologyNumber == 8248;
            boolean gep_net_morpho = gep_net_morpho_1 || gep_net_morpho_2 || gep_net_morpho_3;
            boolean gep_net = gep_net_topo && gep_net_morpho;
            boolean bl3 = uncertain = thymoma || urothelial || ovary || cns || gist || gep_net;
            if (uncertain && solid) {
                isException = true;
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - UNCERTAIN BEHAVIOUR  - Accepted " + primaryKey + " because: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
                }
            }
        }
        if ("0".equals(behaviour)) {
            boolean benign;
            boolean bl4 = benign = cns || gist;
            if (benign && solid) {
                isException = true;
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - BENIGN TUMOURS - Accepted " + primaryKey + " because: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
                }
            }
        }
        return isException;
    }

    protected boolean filterRecord2022(CandidateRecord candidateRecord, String behaviour, String topographyPrexix, int morphologyNumber) {
        boolean targetTopography;
        boolean isException = false;
        String primaryKey = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
        if ("2".equals(behaviour)) {
            boolean bl = targetTopography = "C65".equals(topographyPrexix) || "C66".equals(topographyPrexix) || "C67".equals(topographyPrexix) || "C68".equals(topographyPrexix);
            if (targetTopography && morphologyNumber < 9590) {
                isException = true;
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - 1) Accepted " + primaryKey + " because: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
                }
            }
        }
        if ("0".equals(behaviour) || "1".equals(behaviour)) {
            boolean bl = targetTopography = "C70".equals(topographyPrexix) || "C71".equals(topographyPrexix) || "C72".equals(topographyPrexix);
            if (targetTopography && morphologyNumber < 9590) {
                isException = true;
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - 2) Accepted " + primaryKey + " because: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
                }
            }
        }
        return isException;
    }

    protected boolean filterRecord2021(CandidateRecord candidateRecord, String behaviour, String topographyPrexix, int morphologyNumber) {
        boolean isException = false;
        String primaryKey = this.getPrimaryKeyBySchemaPerspective(candidateRecord);
        if (("1".equals(behaviour) || "2".equals(behaviour)) && "C67".equals(topographyPrexix) && morphologyNumber < 9590) {
            isException = true;
            if (this.isDebugEnabledForCurrentBunch(2)) {
                logger.debug("filterRecord() - 1) Accepted " + primaryKey + " because: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
            }
        }
        if ("0".equals(behaviour) || "1".equals(behaviour)) {
            boolean targetTopography;
            boolean bl = targetTopography = "C70".equals(topographyPrexix) || "C71".equals(topographyPrexix) || "C72".equals(topographyPrexix);
            if (targetTopography && morphologyNumber < 9590) {
                isException = true;
                if (this.isDebugEnabledForCurrentBunch(2)) {
                    logger.debug("filterRecord() - 2) Accepted " + primaryKey + " because: beh = " + behaviour + ", topo = " + topographyPrexix + ", morpho = " + morphologyNumber);
                }
            }
        }
        return isException;
    }

    @Override
    public void setDefaultConfiguration() {
        super.setDefaultConfiguration();
        this.ruleConfiguration.setRuleType(RuleType.CROSS_RECORD);
        ArrayList<RuleParameter> defaultRuleParameters = new ArrayList<RuleParameter>();
        RuleParameter param_1 = new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_PATIENT_ID.id, true);
        RuleParameter param_2 = new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_TUMOUR_ID.id, false);
        RuleParameter param_3 = new RuleParameter(3, DefaultFieldIDencr2014.INCIDENCE_TOPOGRAPHY.id, false);
        RuleParameter param_4 = new RuleParameter(4, DefaultFieldIDencr2014.INCIDENCE_MORPHOLOGY.id, false);
        RuleParameter param_5 = new RuleParameter(5, DefaultFieldIDencr2014.INCIDENCE_BEHAVIOUR.id, false);
        defaultRuleParameters.add(param_1);
        defaultRuleParameters.add(param_2);
        defaultRuleParameters.add(param_3);
        defaultRuleParameters.add(param_4);
        defaultRuleParameters.add(param_5);
        this.ruleConfiguration.setDefaultRuleParameters(defaultRuleParameters);
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        files.add(new LocalFile("PrimaryMultipleContext_1.csv", "", "", "Equivalents records in context 1 - 2014 (Topography and Morphology"));
        files.add(new LocalFile("PrimaryMultipleContext_2.csv", "", "", "Equivalents records in context 2 - 2014 (Topography and Morphology"));
        files.add(new LocalFile("PrimaryMultipleCriteria.csv", "", "", "Definition of the equivalence criteria (not used yes)"));
        files.add(new LocalFile("TopographyLateralityTable.csv", "", "", "Definition of topographies allowing laterality"));
        files.add(new LocalFile("PrimaryMultipleFilter.csv", "", "", "List of criteria for filtering records (before comparing them)"));
        files.add(new LocalFile("PrimaryMultipleGroups.csv", "", "", "Table 3, based on Table 14 of the QC report (2023)"));
        this.ruleConfiguration.setConfigurationFiles(files);
        ArrayList<Integer> preparatoryRules = new ArrayList<Integer>();
        preparatoryRules.add(DefaultRuleID.FIELD_DATA_TYPE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MANDATORY.id);
        preparatoryRules.add(DefaultRuleID.FIELD_MAX_SIZE.id);
        preparatoryRules.add(DefaultRuleID.FIELD_RANGE.id);
        this.ruleConfiguration.setPreparatoryRuleIDs(preparatoryRules);
        if (logger.isDebugEnabled()) {
            logger.debug("setDefaultConfiguration() - Loaded default configuration");
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    public int getAcceptanceCriterion() {
        return this.acceptanceCriterion;
    }

    public void setAcceptanceCriterion(int acceptanceCriterion) {
        this.acceptanceCriterion = acceptanceCriterion;
    }

    public boolean isStrictCheck() {
        return this.strictCheck;
    }

    public void setStrictCheck(boolean strictCheck) {
        this.strictCheck = strictCheck;
    }
}

