/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014;

import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TopographyParser;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterCondition
extends SerializableModel {
    protected static TopographyParser topographyParser;
    protected String topography;
    protected String morphology;
    protected String[] behaviour;
    protected int topoStart = -1;
    protected int topoEnd = -1;
    protected List<String> validTopographies;
    public static final String RANGE = "-";
    public static final String ANY = "Any";
    public static final char TOPO_START = 'C';
    public static final int WRONG_TOPO = -1;
    public static final FilterCondition UNDEF;
    protected static Logger logger;

    public FilterCondition() {
        this.setValid(false);
        this.setName("undefined_filter_condition");
        this.setDescription("Empty reference for a \"null\" FilterCondition instance");
        this.behaviour = new String[3];
    }

    public FilterCondition(String topography, String morphology, String behaviour_0, String behaviour_1, String behaviour_2) {
        this();
        if (logger.isTraceEnabled()) {
            String values = topography + ", " + morphology + ", " + behaviour_0 + ", " + behaviour_1 + ", " + behaviour_2;
            logger.trace("Constructor(NO_ID) - Using values: " + values);
        }
        this.topography = topography;
        this.morphology = morphology;
        this.behaviour[0] = behaviour_0;
        this.behaviour[1] = behaviour_1;
        this.behaviour[2] = behaviour_2;
    }

    public FilterCondition(String id, String name, String description, String topography, String morphology, String behaviour_0, String behaviour_1, String behaviour_2) {
        this();
        if (logger.isTraceEnabled()) {
            String values = topography + ", " + morphology + ", " + behaviour_0 + ", " + behaviour_1 + ", " + behaviour_2;
            logger.trace("Constructor(ID) - Using values: " + values);
        }
        this.topography = topography;
        this.morphology = morphology;
        this.behaviour[0] = behaviour_0;
        this.behaviour[1] = behaviour_1;
        this.behaviour[2] = behaviour_2;
    }

    public FilterCondition(String[] array) {
        this(array[0], array[1], array[2], array[3], array[4]);
    }

    public void expandTopographies() {
        int[] range = topographyParser.expandTopographies(this.topography);
        this.topoStart = range[0];
        this.topoEnd = range[1];
    }

    public boolean hasBehaviour(int beh) {
        return this.behaviour[beh] != null && this.behaviour[beh].length() > 0;
    }

    public String getBehaviour(int beh) {
        return this.behaviour[beh];
    }

    public boolean allowsAnyMorphology(int beh) {
        if (!this.hasBehaviour(beh)) {
            return false;
        }
        String cellContent = this.behaviour[beh].trim();
        return ANY.equalsIgnoreCase(cellContent);
    }

    public boolean matchesMorphology(int beh, String morphoBeh) {
        if (!this.hasBehaviour(beh)) {
            return false;
        }
        if (this.allowsAnyMorphology(beh)) {
            return true;
        }
        String haystack = this.behaviour[beh];
        if (haystack == null) {
            return false;
        }
        return haystack.contains(morphoBeh);
    }

    public String getTopography() {
        return this.topography;
    }

    public void setTopography(String topography) {
        this.topography = topography;
    }

    public String getMorphology() {
        return this.morphology;
    }

    public void setMorphology(String morphology) {
        this.morphology = morphology;
    }

    public String[] getBehaviour() {
        return this.behaviour;
    }

    public void setBehaviour(String[] behaviour) {
        this.behaviour = behaviour;
    }

    public List<String> getValidTopographies() {
        return this.validTopographies;
    }

    public void setValidTopographies(List<String> validTopographies) {
        this.validTopographies = validTopographies;
    }

    public int getTopoStart() {
        return this.topoStart;
    }

    public void setTopoStart(int topoStart) {
        this.topoStart = topoStart;
    }

    public int getTopoEnd() {
        return this.topoEnd;
    }

    public void setTopoEnd(int topoEnd) {
        this.topoEnd = topoEnd;
    }

    @Override
    public String[] serialize() {
        String conditionID = this.getIdAsString();
        if (logger.isTraceEnabled()) {
            logger.trace("serialize() - serialising record having ID: " + conditionID);
        }
        String[] values = new String[]{this.topography, this.morphology, this.behaviour[0], this.behaviour[1], this.behaviour[2]};
        return values;
    }

    @Override
    protected String[] getHeader() {
        String[] values = new String[]{"TOPOGRAHY", "MORPHOLOGY", "BEHAVIOUR_0", "BEHAVIOUR_1", "BEHAVIOUR_2"};
        return values;
    }

    public String toString() {
        int maxChars = 42;
        StringBuilder builder = new StringBuilder();
        if (this.topography != null) {
            builder.append("topography=");
            builder.append(this.topography);
        }
        if (this.topoStart >= 0 && this.topoEnd > 0) {
            int blanks = 9 - this.topography.length();
            if (blanks > 0) {
                String suffix = new String(new char[blanks]).replace('\u0000', ' ');
                builder.append(suffix);
            }
            builder.append(" -> ");
            builder.append(this.topoStart);
            builder.append(RANGE);
            builder.append(this.topoEnd);
        }
        if (this.morphology != null && this.morphology.length() > 0) {
            builder.append(", morphology=");
            if (this.morphology.length() <= maxChars) {
                builder.append(this.morphology);
            } else {
                builder.append(this.morphology.substring(0, maxChars));
                builder.append("... ");
            }
            builder.append(" (");
            builder.append(this.countValues(this.morphology));
            builder.append(" values)");
        } else {
            builder.append(", morphology=N/A");
        }
        for (int beh = 0; beh < 3; ++beh) {
            if (!this.hasBehaviour(beh)) continue;
            builder.append(", Beh[");
            builder.append(beh);
            builder.append("]=");
            if (this.allowsAnyMorphology(beh)) {
                builder.append(ANY);
                continue;
            }
            builder.append(this.countValues(this.behaviour[beh]));
            builder.append(" morphos");
        }
        return builder.toString();
    }

    public FilterCondition clone() {
        if (logger.isTraceEnabled()) {
            logger.trace("clone() - Cloning object: " + String.valueOf(this));
        }
        String _topography = String.valueOf(this.topography);
        String _morphology = String.valueOf(this.morphology);
        String _behaviour_0 = String.valueOf(this.behaviour[0]);
        String _behaviour_1 = String.valueOf(this.behaviour[1]);
        String _behaviour_2 = String.valueOf(this.behaviour[2]);
        FilterCondition newObject = new FilterCondition(_topography, _morphology, _behaviour_0, _behaviour_1, _behaviour_2);
        return newObject;
    }

    protected long countValues(String string) {
        if (string == null || string.length() == 0) {
            return 0L;
        }
        long separators = string.chars().filter(e -> e == 44).count();
        return separators + 1L;
    }

    static {
        UNDEF = new FilterCondition();
        logger = LoggerFactory.getLogger(FilterCondition.class);
        topographyParser = new TopographyParser();
    }
}

