/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014;

import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.encr2014.FilterCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BehaviourTable {
    protected List<String>[] morphologiesByBehaviour = new ArrayList[3];
    protected List<FilterCondition> conditions;
    protected Map<Integer, List<FilterCondition>> conditionsByBehaviour;
    public static final char SEPARATOR = ',';
    protected static Logger logger = LoggerFactory.getLogger(BehaviourTable.class);

    public BehaviourTable() {
        this.morphologiesByBehaviour[0] = new ArrayList<String>();
        this.morphologiesByBehaviour[1] = new ArrayList<String>();
        this.morphologiesByBehaviour[2] = new ArrayList<String>();
    }

    public List<FilterCondition> expandFilterConditions(List<FilterCondition> list) {
        if (logger.isTraceEnabled()) {
            logger.trace("expandFilterConditions() - Input list: " + list.size());
        }
        this.conditions = new ArrayList<FilterCondition>();
        this.conditionsByBehaviour = new HashMap<Integer, List<FilterCondition>>();
        for (FilterCondition condition : list) {
            if (logger.isTraceEnabled()) {
                logger.trace("expandFilterConditions() - Expading line: " + String.valueOf(condition));
            }
            String topography = condition.getTopography();
            String separator = String.valueOf(',');
            String[] tokens = topography.split(separator);
            ArrayList<FilterCondition> newConditions = new ArrayList<FilterCondition>();
            for (String token : tokens) {
                FilterCondition newCondition = condition.clone();
                newCondition.setTopography(token);
                newConditions.add(newCondition);
                this.conditions.add(newCondition);
            }
            for (FilterCondition newCondition : newConditions) {
                this.parseMorphologies(newCondition);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("expandFilterConditions() - Output list: " + this.conditions.size());
        }
        if (logger.isDebugEnabled()) {
            String sep = "";
            StringBuilder builder = new StringBuilder();
            for (int beh = 0; beh < 3; ++beh) {
                builder.append(sep);
                builder.append((String)(this.morphologiesByBehaviour[beh] != null ? "Beh[" + beh + "]=" + this.morphologiesByBehaviour[beh].size() : "0"));
                sep = ", ";
            }
            logger.debug("expandFilterConditions() - morphologiesByBehaviour[0/1/2] size: " + String.valueOf(builder));
        }
        return this.conditions;
    }

    protected void parseMorphologies(FilterCondition condition) {
        String regex = "\\s*,\\s*";
        for (int beh = 0; beh < 3; ++beh) {
            List<FilterCondition> list;
            String values;
            if (logger.isTraceEnabled()) {
                logger.trace("parseMorphologies() - Checking behaviour: " + beh);
            }
            if ((values = condition.getBehaviour(beh)) == null || values.isEmpty()) continue;
            List<String> items = Arrays.asList(values.split(regex));
            this.morphologiesByBehaviour[beh] = Stream.concat(this.morphologiesByBehaviour[beh].stream(), items.stream()).collect(Collectors.toList());
            if (logger.isTraceEnabled()) {
                logger.trace("parseMorphologies() - Morphologies by behaviour[" + beh + "]: " + String.valueOf(this.morphologiesByBehaviour[beh]));
            }
            if ((list = this.conditionsByBehaviour.get(beh)) == null || list.isEmpty()) {
                list = new ArrayList<FilterCondition>();
                this.conditionsByBehaviour.put(beh, list);
            }
            list.add(condition);
        }
    }

    public String getMorphoBehString(String morphology, String behaviour) {
        StringBuilder builder = new StringBuilder(morphology);
        builder.append("/");
        builder.append(behaviour);
        String morphoBeh = builder.toString().trim();
        return morphoBeh.toString();
    }

    public FilterCondition getFilterCondition(String mainKey, String topography, String morphology, String behaviour) {
        int beh;
        boolean debug = logger.isTraceEnabled();
        String morphoBeh = this.getMorphoBehString(morphology, behaviour);
        if (debug) {
            logger.info("getFilterConditions() - " + mainKey + " - Looking for morhpo_beh: " + morphoBeh);
        }
        if ((beh = this.parseBehaviourValue(behaviour)) < 0 || beh > 3) {
            return FilterCondition.UNDEF;
        }
        if (this.isMorphologyAddressedByBehaviour(beh, morphoBeh)) {
            if (debug) {
                logger.info("getFilterConditions() - " + mainKey + " - Found morpho_beh_match: " + morphoBeh);
            }
            int topo = this.parseTopographyValue(mainKey, topography);
            if (debug) {
                logger.info("getFilterConditions() - Evaluating topography: " + topo);
            }
            List<FilterCondition> candidateConditions = this.conditionsByBehaviour.get(beh);
            for (FilterCondition condition : candidateConditions) {
                boolean isWithin = condition.getTopoStart() <= topo && topo <= condition.getTopoEnd();
                if (!isWithin) continue;
                if (debug) {
                    logger.info("getFilterConditions() - Matched condition: " + String.valueOf(condition));
                }
                if (!condition.matchesMorphology(beh, morphoBeh)) continue;
                return condition;
            }
        }
        if (debug) {
            logger.info("getFilterConditions() - Input record did_not match any filter condition");
        }
        return null;
    }

    public boolean isMorphologyAddressedByBehaviour(int beh, String morphoBeh) {
        if (this.morphologiesByBehaviour[beh].contains("Any")) {
            if (logger.isTraceEnabled()) {
                logger.trace("isMorphologyAddressedByBehaviour() - Accepting value " + morphoBeh + " since behaviour contains ANY");
            }
            return true;
        }
        return this.morphologiesByBehaviour[beh].contains(morphoBeh);
    }

    private int parseTopographyValue(String recordID, String topography) {
        int topo;
        block2: {
            topo = -1;
            try {
                String topoAsNumber = topography.substring(1, 4);
                topo = Integer.parseInt(topoAsNumber);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("parseTopographyValue() - " + recordID + " - Wrong topography value: " + topography);
            }
        }
        return topo;
    }

    private int parseBehaviourValue(String behaviour) {
        int beh;
        block2: {
            beh = -1;
            try {
                beh = Integer.parseInt(behaviour);
            }
            catch (NumberFormatException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("parseBehaviourValue() - Wrong Behaviour value: " + behaviour);
            }
        }
        return beh;
    }

    public List<String>[] getMorphologiesByBehaviour() {
        return this.morphologiesByBehaviour;
    }

    public void setMorphologiesByBehaviour(List<String>[] morphologiesByBehaviour) {
        this.morphologiesByBehaviour = morphologiesByBehaviour;
    }

    public List<FilterCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<FilterCondition> conditions) {
        this.conditions = conditions;
    }
}

